/*
 * Decompiled with CFR 0.152.
 */
package sync.common.shell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.Level;
import sync.common.Sync;
import sync.common.core.ChunkLoadHandler;
import sync.common.packet.PacketClearShellList;
import sync.common.packet.PacketShellState;
import sync.common.tileentity.TileEntityDualVertical;

public class ShellHandler {
    public static SetMultimap<String, TileEntityDualVertical> playerShells = HashMultimap.create();
    public static HashMap<String, TileEntityDualVertical> syncInProgress = new HashMap();

    public static void addShell(String playerName, TileEntityDualVertical dualVertical, boolean shouldChunkLoad) {
        if (!playerShells.containsEntry((Object)playerName, (Object)dualVertical)) {
            playerShells.put((Object)playerName, (Object)dualVertical);
            if (shouldChunkLoad && !ChunkLoadHandler.isAlreadyChunkLoaded(dualVertical)) {
                ChunkLoadHandler.addShellAsChunkloader(dualVertical);
            }
        }
    }

    public static void removeShell(String playerName, TileEntityDualVertical dualVertical) {
        if (playerName != null && dualVertical != null) {
            playerShells.remove((Object)playerName, (Object)dualVertical);
            ChunkLoadHandler.removeShellAsChunkloader(dualVertical);
            dualVertical.reset();
            dualVertical.func_145831_w().func_147471_g(dualVertical.field_145851_c, dualVertical.field_145848_d, dualVertical.field_145849_e);
            dualVertical.func_145831_w().func_147471_g(dualVertical.field_145851_c, dualVertical.field_145848_d + 1, dualVertical.field_145849_e);
        } else {
            Sync.logger.log(Level.WARN, String.format("Attempted to remove a shell but something was null for %s at %s", new Object[]{playerName, dualVertical}));
        }
    }

    public static boolean isShellAlreadyRegistered(TileEntityDualVertical dualVertical) {
        return playerShells.containsValue((Object)dualVertical);
    }

    public static void updatePlayerOfShells(EntityPlayer player, TileEntityDualVertical dv, boolean all) {
        ArrayList<TileEntityDualVertical> dvs = new ArrayList<TileEntityDualVertical>();
        ArrayList<TileEntityDualVertical> remove = new ArrayList<TileEntityDualVertical>();
        if (all) {
            PacketHandler.sendToPlayer(Sync.channels, (AbstractPacket)new PacketClearShellList(), (EntityPlayer)player);
            for (Map.Entry e : playerShells.entries()) {
                if (!((String)e.getKey()).equalsIgnoreCase(player.func_70005_c_())) continue;
                TileEntityDualVertical dualVertical = (TileEntityDualVertical)((Object)e.getValue());
                if (dualVertical.func_145831_w().func_147438_o(dualVertical.field_145851_c, dualVertical.field_145848_d, dualVertical.field_145849_e) == dualVertical) {
                    dvs.add(dualVertical);
                    continue;
                }
                remove.add(dualVertical);
            }
        } else if (dv != null) {
            dvs.add(dv);
        }
        for (TileEntityDualVertical dv1 : dvs) {
            if (dv1.top) continue;
            PacketHandler.sendToPlayer(Sync.channels, (AbstractPacket)new PacketShellState(dv1, false), (EntityPlayer)player);
        }
        for (TileEntityDualVertical dv1 : remove) {
            ShellHandler.removeShell(dv1.getPlayerName(), dv1);
        }
    }

    public static void updatePlayerOfShellRemoval(EntityPlayer player, TileEntityDualVertical dv) {
        if (dv.top) {
            return;
        }
        PacketHandler.sendToPlayer(Sync.channels, (AbstractPacket)new PacketShellState(dv, true), (EntityPlayer)player);
    }
}

