/*
 * Decompiled with CFR 0.152.
 */
package sync.common.core;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ichun.client.keybind.KeyEvent;
import ichun.common.core.network.AbstractPacket;
import ichun.common.core.network.PacketHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import org.apache.logging.log4j.Level;
import sync.common.Sync;
import sync.common.packet.PacketPlayerDeath;
import sync.common.packet.PacketSession;
import sync.common.packet.PacketSyncRequest;
import sync.common.packet.PacketZoomCamera;
import sync.common.shell.ShellHandler;
import sync.common.shell.ShellState;
import sync.common.tileentity.TileEntityDualVertical;
import sync.common.tileentity.TileEntityShellConstructor;
import sync.common.tileentity.TileEntityTreadmill;

public class EventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyEvent(KeyEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null && event.keyBind.isPressed()) {
            if (event.keyBind.keyIndex == -100) {
                double mag = Math.sqrt(Sync.proxy.tickHandlerClient.radialDeltaX * Sync.proxy.tickHandlerClient.radialDeltaX + Sync.proxy.tickHandlerClient.radialDeltaY * Sync.proxy.tickHandlerClient.radialDeltaY);
                double magAcceptance = 0.8;
                double radialAngle = -720.0;
                if (mag > magAcceptance) {
                    double aSin = Math.toDegrees(Math.asin(Sync.proxy.tickHandlerClient.radialDeltaX));
                    if (Sync.proxy.tickHandlerClient.radialDeltaY >= 0.0 && Sync.proxy.tickHandlerClient.radialDeltaX >= 0.0) {
                        radialAngle = aSin;
                    } else if (Sync.proxy.tickHandlerClient.radialDeltaY < 0.0 && Sync.proxy.tickHandlerClient.radialDeltaX >= 0.0) {
                        radialAngle = 90.0 + (90.0 - aSin);
                    } else if (Sync.proxy.tickHandlerClient.radialDeltaY < 0.0 && Sync.proxy.tickHandlerClient.radialDeltaX < 0.0) {
                        radialAngle = 180.0 - aSin;
                    } else if (Sync.proxy.tickHandlerClient.radialDeltaY >= 0.0 && Sync.proxy.tickHandlerClient.radialDeltaX < 0.0) {
                        radialAngle = 270.0 + (90.0 + aSin);
                    }
                }
                if (mag > 0.9999999) {
                    mag = Math.round(mag);
                }
                ArrayList<ShellState> selectedShells = new ArrayList<ShellState>(Sync.proxy.tickHandlerClient.shells);
                Collections.sort(selectedShells);
                for (int i = selectedShells.size() - 1; i >= 0; --i) {
                    ShellState state = selectedShells.get(i);
                    if (state.playerState == null || state.dimension != mc.field_71441_e.field_73011_w.field_76574_g && (Sync.config.getSessionInt("allowCrossDimensional") == 0 || Sync.config.getSessionInt("allowCrossDimensional") == 1 && (state.dimension == 1 && mc.field_71441_e.field_73011_w.field_76574_g != 1 || state.dimension != 1 && mc.field_71441_e.field_73011_w.field_76574_g == 1))) {
                        selectedShells.remove(i);
                    }
                    if (Sync.proxy.tickHandlerClient.lockedStorage == null || Sync.proxy.tickHandlerClient.lockedStorage.field_145851_c != state.xCoord || Sync.proxy.tickHandlerClient.lockedStorage.field_145848_d != state.yCoord || Sync.proxy.tickHandlerClient.lockedStorage.field_145849_e != state.zCoord || Sync.proxy.tickHandlerClient.lockedStorage.func_145831_w().field_73011_w.field_76574_g != state.dimension) continue;
                    selectedShells.remove(i);
                }
                ShellState selected = null;
                for (int i = 0; i < selectedShells.size(); ++i) {
                    float leeway = 360.0f / (float)selectedShells.size();
                    if (!(mag > magAcceptance * 0.75) || !(i == 0 && (radialAngle < (double)(leeway / 2.0f) && radialAngle >= 0.0 || radialAngle > (double)(360.0f - leeway / 2.0f))) && (i == 0 || !(radialAngle < (double)(leeway * (float)i + leeway / 2.0f)) || !(radialAngle > (double)(leeway * (float)i - leeway / 2.0f)))) continue;
                    selected = selectedShells.get(i);
                    break;
                }
                if (selected != null && selected.buildProgress >= (float)Sync.config.getSessionInt("shellConstructionPowerRequirement") && Sync.proxy.tickHandlerClient.lockedStorage != null) {
                    PacketHandler.sendToServer(Sync.channels, (AbstractPacket)new PacketSyncRequest(Sync.proxy.tickHandlerClient.lockedStorage.field_145851_c, Sync.proxy.tickHandlerClient.lockedStorage.field_145848_d, Sync.proxy.tickHandlerClient.lockedStorage.field_145849_e, Sync.proxy.tickHandlerClient.lockedStorage.func_145831_w().field_73011_w.field_76574_g, selected.xCoord, selected.yCoord, selected.zCoord, selected.dimension));
                }
                Sync.proxy.tickHandlerClient.radialShow = false;
                Sync.proxy.tickHandlerClient.lockedStorage = null;
            } else if (event.keyBind.keyIndex == -99) {
                Sync.proxy.tickHandlerClient.radialShow = false;
                Sync.proxy.tickHandlerClient.lockedStorage = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        if (Sync.proxy.tickHandlerClient.radialShow) {
            if (!Sync.proxy.tickHandlerClient.shells.isEmpty()) {
                Sync.proxy.tickHandlerClient.radialDeltaX += (double)event.dx / 100.0;
                Sync.proxy.tickHandlerClient.radialDeltaY += (double)event.dy / 100.0;
                double mag = Math.sqrt(Sync.proxy.tickHandlerClient.radialDeltaX * Sync.proxy.tickHandlerClient.radialDeltaX + Sync.proxy.tickHandlerClient.radialDeltaY * Sync.proxy.tickHandlerClient.radialDeltaY);
                if (mag > 1.0) {
                    Sync.proxy.tickHandlerClient.radialDeltaX /= mag;
                    Sync.proxy.tickHandlerClient.radialDeltaY /= mag;
                }
            }
            if (event.button == 0 || event.button == 1) {
                event.setCanceled(true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (Sync.proxy.tickHandlerClient.refusePlayerRender.containsKey(event.entityPlayer.func_70005_c_()) && !Sync.proxy.tickHandlerClient.forceRender && Sync.proxy.tickHandlerClient.refusePlayerRender.get(event.entityPlayer.func_70005_c_()) < 118) {
            event.entityPlayer.field_70142_S = event.entityPlayer.field_70169_q = event.entityPlayer.field_70165_t;
            event.entityPlayer.field_70167_r = event.entityPlayer != Minecraft.func_71410_x().field_71439_g && Sync.proxy.tickHandlerClient.refusePlayerRender.get(event.entityPlayer.func_70005_c_()) > 60 ? 500.0 : event.entityPlayer.field_70163_u;
            event.entityPlayer.field_70137_T = event.entityPlayer.field_70167_r;
            event.entityPlayer.field_70136_U = event.entityPlayer.field_70166_s = event.entityPlayer.field_70161_v;
            event.entityPlayer.field_70761_aq = event.entityPlayer.field_70177_z;
            event.entityPlayer.field_70725_aQ = 0;
            if (!event.entityPlayer.func_70089_S()) {
                event.entityPlayer.func_70606_j(1.0f);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClientConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Sync.config.resetSession();
        Sync.proxy.tickHandlerClient.radialShow = false;
        Sync.proxy.tickHandlerClient.zoom = false;
        Sync.proxy.tickHandlerClient.lockTime = 0;
        Sync.proxy.tickHandlerClient.zoomTimer = -10;
        Sync.proxy.tickHandlerClient.zoomTimeout = 0;
        Sync.proxy.tickHandlerClient.shells.clear();
        Sync.proxy.tickHandlerClient.refusePlayerRender.clear();
        Sync.proxy.tickHandlerClient.lockedStorage = null;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PacketHandler.sendToPlayer(Sync.channels, (AbstractPacket)new PacketSession(), (EntityPlayer)event.player);
        ShellHandler.updatePlayerOfShells(event.player, null, true);
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)event.player;
        if (entityPlayerMP.getEntityData().func_74764_b("isDeathSyncing") && entityPlayerMP.getEntityData().func_74767_n("isDeathSyncing")) {
            TileEntityDualVertical tpPosition = EventHandler.getClosestRespawnShell((EntityPlayer)entityPlayerMP);
            if (tpPosition != null) {
                PacketHandler.sendToPlayer(Sync.channels, (AbstractPacket)new PacketZoomCamera((int)Math.floor(entityPlayerMP.field_70165_t), (int)Math.floor(entityPlayerMP.field_70163_u), (int)Math.floor(entityPlayerMP.field_70161_v), entityPlayerMP.field_71093_bK, -1, false, true), (EntityPlayer)event.player);
                tpPosition.resyncPlayer = 120;
                PacketHandler.sendToAll(Sync.channels, (AbstractPacket)new PacketPlayerDeath(entityPlayerMP.func_70005_c_(), true));
                entityPlayerMP.func_70606_j(20.0f);
                if (!ShellHandler.syncInProgress.containsKey(entityPlayerMP.func_70005_c_())) {
                    ShellHandler.syncInProgress.put(entityPlayerMP.func_70005_c_(), tpPosition);
                }
            } else {
                entityPlayerMP.func_70106_y();
                entityPlayerMP.func_70606_j(0.0f);
                entityPlayerMP.getEntityData().func_74757_a("isDeathSyncing", false);
                ShellHandler.syncInProgress.remove(entityPlayerMP.func_70005_c_());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (ShellHandler.syncInProgress.containsKey(event.player.func_70005_c_())) {
            TileEntityDualVertical tileEntityDualVertical = ShellHandler.syncInProgress.get(event.player.func_70005_c_());
            Sync.logger.log(Level.INFO, String.format("%s logged out mid-sync whilst sync process was at %s", event.player.func_70005_c_(), tileEntityDualVertical.resyncPlayer));
            if (tileEntityDualVertical.resyncPlayer > 60) {
                tileEntityDualVertical.resyncPlayer = -10;
                if (tileEntityDualVertical.resyncOrigin != null) {
                    tileEntityDualVertical.reset();
                    tileEntityDualVertical.func_145831_w().func_147471_g(tileEntityDualVertical.field_145851_c, tileEntityDualVertical.field_145848_d, tileEntityDualVertical.field_145849_e);
                    tileEntityDualVertical.func_145831_w().func_147471_g(tileEntityDualVertical.field_145851_c, tileEntityDualVertical.field_145848_d + 1, tileEntityDualVertical.field_145849_e);
                }
            }
            ShellHandler.syncInProgress.remove(event.player.func_70005_c_());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS && Sync.proxy.tickHandlerClient.radialShow) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityPlayerMP player;
        TileEntityDualVertical tpPosition;
        if (Sync.config.getSessionInt("overrideDeathIfThereAreAvailableShells") > 0 && event.entityLiving instanceof EntityPlayerMP && !(event.entityLiving instanceof FakePlayer) && !event.entityLiving.field_70170_p.field_72995_K && (tpPosition = EventHandler.getClosestRespawnShell((EntityPlayer)(player = (EntityPlayerMP)event.entityLiving))) != null) {
            PacketHandler.sendToPlayer(Sync.channels, (AbstractPacket)new PacketZoomCamera((int)Math.floor(event.entityLiving.field_70165_t), (int)Math.floor(event.entityLiving.field_70163_u), (int)Math.floor(event.entityLiving.field_70161_v), event.entityLiving.field_71093_bK, -1, false, true), (EntityPlayer)player);
            tpPosition.resyncPlayer = 120;
            PacketHandler.sendToAll(Sync.channels, (AbstractPacket)new PacketPlayerDeath(event.entityLiving.func_70005_c_(), true));
            player.func_70606_j(20.0f);
            if (!ShellHandler.syncInProgress.containsKey(player.func_70005_c_())) {
                player.getEntityData().func_74757_a("isDeathSyncing", true);
                ShellHandler.syncInProgress.put(player.func_70005_c_(), tpPosition);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityAttacked(LivingAttackEvent event) {
        if (event.entityLiving instanceof EntityPlayer && event.source != DamageSource.field_76380_i && ShellHandler.syncInProgress.containsKey(((EntityPlayer)event.entityLiving).func_70005_c_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityHurt(LivingHurtEvent event) {
        if (event.entityLiving instanceof EntityPlayer && event.source != DamageSource.field_76380_i && ShellHandler.syncInProgress.containsKey(((EntityPlayer)event.entityLiving).func_70005_c_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        if (ShellHandler.syncInProgress.containsKey(event.entityPlayer.func_70005_c_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        TileEntity tileEntity;
        if (TileEntityTreadmill.isEntityValidForTreadmill(event.target) && (tileEntity = event.target.field_70170_p.func_147438_o((int)Math.floor(event.target.field_70165_t), (int)Math.floor(event.target.field_70163_u), (int)Math.floor(event.target.field_70161_v))) instanceof TileEntityTreadmill) {
            TileEntityTreadmill tm = (TileEntityTreadmill)tileEntity;
            if (tm.back) {
                tm = tm.pair;
            }
            if (tm != null && tm.latchedEnt == event.target) {
                double velo = 1.3;
                switch (tm.face) {
                    case 0: {
                        tm.latchedEnt.field_70179_y = velo;
                        break;
                    }
                    case 1: {
                        tm.latchedEnt.field_70159_w = -velo;
                        break;
                    }
                    case 2: {
                        tm.latchedEnt.field_70179_y = -velo;
                        break;
                    }
                    case 3: {
                        tm.latchedEnt.field_70159_w = velo;
                    }
                }
                tm.latchedEnt = null;
                tm.timeRunning = 0;
                tm.func_145831_w().func_147471_g(tm.field_145851_c, tm.field_145848_d, tm.field_145849_e);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent e) {
        if (ShellHandler.syncInProgress.containsKey(e.player.func_70005_c_())) {
            e.setCanceled(true);
        }
    }

    public static TileEntityDualVertical getClosestRespawnShell(EntityPlayer player) {
        ArrayList<TileEntityDualVertical> dvs = new ArrayList<TileEntityDualVertical>();
        boolean reiterateShells = false;
        for (Map.Entry e : ShellHandler.playerShells.entries()) {
            if (!((String)e.getKey()).equalsIgnoreCase(player.func_70005_c_())) continue;
            TileEntityDualVertical dv1 = (TileEntityDualVertical)((Object)e.getValue());
            if (dv1.func_145831_w().func_147438_o(dv1.field_145851_c, dv1.field_145848_d, dv1.field_145849_e) == dv1) {
                dvs.add(dv1);
                continue;
            }
            reiterateShells = true;
        }
        if (reiterateShells) {
            ShellHandler.updatePlayerOfShells(player, null, true);
        }
        TileEntityDualVertical nearestCrossDimHome = null;
        TileEntityDualVertical nearestCrossDim = null;
        TileEntityDualVertical nearestDv = null;
        TileEntityDualVertical nearestHome = null;
        TileEntityDualVertical tpPosition = null;
        double crossDimHomeDist = -1.0;
        double crossDimDist = -1.0;
        double dist = -1.0;
        double homeDist = -1.0;
        for (TileEntityDualVertical dv : dvs) {
            if (dv instanceof TileEntityShellConstructor) {
                TileEntityShellConstructor sc = (TileEntityShellConstructor)dv;
                if (Sync.config.getSessionInt("overrideDeathIfThereAreAvailableShells") == 1 || sc.constructionProgress < (float)Sync.config.getSessionInt("shellConstructionPowerRequirement")) continue;
            }
            double dvDist = player.func_70011_f((double)dv.field_145851_c + 0.5, (double)dv.field_145848_d, (double)dv.field_145849_e + 0.5);
            if (dv.func_145831_w().field_73011_w.field_76574_g == player.field_71093_bK) {
                if (dv.isHomeUnit && (homeDist == -1.0 || dvDist < homeDist)) {
                    nearestHome = dv;
                    homeDist = dvDist;
                }
                if (dist != -1.0 && !(dvDist < dist)) continue;
                nearestDv = dv;
                dist = dvDist;
                continue;
            }
            if (Sync.config.getSessionInt("allowCrossDimensional") != 1 || player.field_71093_bK == 1 && Sync.config.getSessionInt("allowCrossDimensional") != 2 || Sync.config.getSessionInt("crossDimensionalSyncingOnDeath") != 1) continue;
            if (dv.isHomeUnit && (crossDimHomeDist == -1.0 || dvDist < crossDimHomeDist)) {
                nearestCrossDimHome = dv;
                crossDimHomeDist = dvDist;
            }
            if (crossDimDist != -1.0 && !(dvDist < crossDimDist)) continue;
            nearestCrossDim = dv;
            crossDimDist = dvDist;
        }
        if (Sync.config.getInt("prioritizeHomeShellOnDeath") == 1) {
            if (nearestHome != null) {
                tpPosition = nearestHome;
            } else if (nearestCrossDimHome != null) {
                tpPosition = nearestCrossDimHome;
            }
        }
        if (tpPosition == null) {
            if (nearestDv != null) {
                tpPosition = nearestDv;
            } else if (nearestCrossDim != null) {
                tpPosition = nearestCrossDim;
            }
        }
        return tpPosition;
    }
}

