/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.nodebuffer;

import com.rwtema.extrautils.XUHelper;
import com.rwtema.extrautils.tileentity.transfernodes.InvHelper;
import com.rwtema.extrautils.tileentity.transfernodes.TNHelper;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INode;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBuffer
implements INodeBuffer {
    public INode node;
    public ItemStack item = null;

    @Override
    public boolean transfer(TileEntity tile, ForgeDirection side, IPipe insertingPipe, int x, int y, int z, ForgeDirection travelDir) {
        if (this.item != null && tile instanceof IInventory && side != ForgeDirection.UNKNOWN) {
            boolean nonSided = !(tile instanceof ISidedInventory);
            IInventory inv = TNHelper.getInventory(tile);
            int empty = -1;
            int filter = -1;
            int maxStack = Math.min(this.item.func_77976_d(), inv.func_70297_j_());
            if (insertingPipe != null) {
                filter = insertingPipe.limitTransfer(tile, side, this);
            }
            if (filter < 0) {
                filter = maxStack;
            } else if (filter == 0) {
                return true;
            }
            boolean flag = true;
            for (int i : InvHelper.getSlots(inv, side.ordinal())) {
                int l;
                if (inv.func_70301_a(i) == null) {
                    if (empty != -1 || !inv.func_94041_b(i, this.item) || !nonSided && !((ISidedInventory)inv).func_102007_a(i, this.item, side.ordinal())) continue;
                    empty = i;
                    continue;
                }
                if (!InvHelper.canStack(this.item, inv.func_70301_a(i)) || !inv.func_94041_b(i, this.item) || !nonSided && !((ISidedInventory)inv).func_102007_a(i, this.item, side.ordinal())) continue;
                ItemStack dest = inv.func_70301_a(i);
                if (maxStack - dest.field_77994_a <= 0 || filter <= 0 || (l = Math.min(Math.min(this.item.field_77994_a, maxStack - dest.field_77994_a), filter)) <= 0) continue;
                dest.field_77994_a += l;
                this.item.field_77994_a -= l;
                filter -= l;
                flag = true;
                if (this.item.field_77994_a <= 0) {
                    this.item = null;
                    break;
                }
                if (filter <= 0) break;
            }
            if (filter > 0 && this.item != null && empty != -1 && inv.func_94041_b(empty, this.item) && (nonSided || ((ISidedInventory)inv).func_102007_a(empty, this.item, side.ordinal()))) {
                if (filter < this.item.field_77994_a) {
                    inv.func_70299_a(empty, this.item.func_77979_a(filter));
                } else {
                    inv.func_70299_a(empty, this.item);
                    this.item = null;
                }
                flag = true;
            }
            if (flag) {
                inv.func_70296_d();
            }
        }
        return true;
    }

    public ItemStack getBuffer() {
        return this.item;
    }

    @Override
    public String getBufferType() {
        return "items";
    }

    @Override
    public void setBuffer(Object buffer) {
        if (buffer == null || buffer instanceof ItemStack) {
            this.item = (ItemStack)buffer;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tags) {
        this.item = tags.func_74764_b("bufferItem") ? ItemStack.func_77949_a((NBTTagCompound)tags.func_74775_l("bufferItem")) : null;
    }

    @Override
    public void writeToNBT(NBTTagCompound tags) {
        if (this.item != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            this.item.func_77955_b(nbttagcompound1);
            tags.func_74782_a("bufferItem", (NBTBase)nbttagcompound1);
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.item == null) {
            return true;
        }
        if (this.item.field_77994_a == 0) {
            this.item = null;
            return true;
        }
        return false;
    }

    @Override
    public void setNode(INode node) {
        this.node = node;
    }

    @Override
    public INode getNode() {
        return this.node;
    }

    @Override
    public boolean transferTo(INodeBuffer receptor, int no) {
        ItemStack newbuffer;
        if (this.item == null || this.item.field_77994_a == 0 || !this.getBufferType().equals(receptor.getBufferType())) {
            return false;
        }
        ItemStack buffer = (ItemStack)receptor.getBuffer();
        if (buffer == null) {
            newbuffer = this.item.func_77946_l();
            newbuffer.field_77994_a = 0;
        } else {
            newbuffer = buffer.func_77946_l();
        }
        if (receptor.getNode() instanceof IInventory && ((IInventory)receptor.getNode()).func_94041_b(0, this.item)) {
            return false;
        }
        if (XUHelper.canItemsStack(this.item, newbuffer)) {
            int m = newbuffer.func_77976_d() - newbuffer.field_77994_a;
            if (no < m) {
                m = no;
            }
            if (this.item.field_77994_a < m) {
                m = this.item.field_77994_a;
            }
            if (m <= 0) {
                return false;
            }
            newbuffer.field_77994_a += m;
            receptor.setBuffer(newbuffer);
            receptor.markDirty();
            this.item.field_77994_a -= m;
            if (this.item.field_77994_a == 0) {
                this.item = null;
            }
        }
        return true;
    }

    @Override
    public Object recieve(Object a) {
        if (!(a instanceof ItemStack)) {
            return a;
        }
        ItemStack i = (ItemStack)a;
        if (this.item == null) {
            this.item = i;
            return null;
        }
        if (XUHelper.canItemsStack(i, this.item)) {
            int n = this.item.func_77976_d() - this.item.field_77994_a;
        }
        return i;
    }

    @Override
    public void markDirty() {
        this.node.bufferChanged();
    }

    @Override
    public boolean shouldSearch() {
        return !this.isEmpty();
    }
}

