/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.extratic.metals;

import com.google.common.collect.HashBiMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glassmaker.extratic.common.BucketHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class MoltenMetalBucketItem
extends ItemBucket {
    private IIcon _filling = null;
    private Block _fluidBlock = null;
    private int _capacity = 1000;
    private HashBiMap<Integer, String> fluidNames = HashBiMap.create();
    private HashMap<Integer, String> textures = new HashMap();
    private HashMap<Integer, IIcon> icons = new HashMap();
    protected static final String pathToTextures = "ExtraTiC".toLowerCase(Locale.ENGLISH) + ":" + "bucket/";

    public MoltenMetalBucketItem(Block fluidBlock) {
        super(fluidBlock);
        this._fluidBlock = fluidBlock;
        this.func_77655_b("extratic.bucket");
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77642_a(Items.field_151133_ar);
        this.func_111206_d("minecraft:bucket_empty");
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int damage) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.func_111208_A());
        this._filling = register.func_94245_a(pathToTextures + "bucket_fill_fairy");
        for (Map.Entry<Integer, String> entry : this.textures.entrySet()) {
            IIcon filling = register.func_94245_a(pathToTextures + entry.getValue());
            this.icons.put(entry.getKey(), filling);
        }
    }

    public IIcon getIcon(ItemStack itemStack, int pass) {
        int index = itemStack.func_77960_j();
        if (pass == 0 || index <= 0) {
            return this.field_77791_bV;
        }
        IIcon icon = this.icons.get(index);
        if (icon != null) {
            return icon;
        }
        return this.field_77791_bV;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (itemStack == null || itemStack.func_77973_b() != this) {
            return itemStack;
        }
        int index = itemStack.func_77960_j();
        String fluidName = (String)this.fluidNames.get((Object)index);
        if (fluidName == null) {
            return itemStack;
        }
        Block block = BucketHandler.getBlock(itemStack);
        boolean isAir = block == null;
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, isAir);
        if (movingobjectposition == null) {
            return itemStack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int xCoord = movingobjectposition.field_72311_b;
            int yCoord = movingobjectposition.field_72312_c;
            int zCoord = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, xCoord, yCoord, zCoord)) {
                return itemStack;
            }
            if (block == Blocks.field_150350_a) {
                return new ItemStack(this.func_77668_q());
            }
            if (movingobjectposition.field_72310_e == 0) {
                --yCoord;
            }
            if (movingobjectposition.field_72310_e == 1) {
                ++yCoord;
            }
            if (movingobjectposition.field_72310_e == 2) {
                --zCoord;
            }
            if (movingobjectposition.field_72310_e == 3) {
                ++zCoord;
            }
            if (movingobjectposition.field_72310_e == 4) {
                --xCoord;
            }
            if (movingobjectposition.field_72310_e == 5) {
                ++xCoord;
            }
            if (!player.func_82247_a(xCoord, yCoord, zCoord, movingobjectposition.field_72310_e, itemStack)) {
                return itemStack;
            }
            Material material = world.func_147439_a(xCoord, yCoord, zCoord).func_149688_o();
            if (world.func_147437_c(xCoord, yCoord, zCoord) && !material.func_76220_a()) {
                if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
                    world.func_147480_a(xCoord, yCoord, zCoord, true);
                }
                world.func_147465_d(xCoord, yCoord, zCoord, block, 0, 3);
                if (!player.field_71075_bZ.field_75098_d) {
                    return new ItemStack(this.func_77668_q());
                }
            }
        }
        return itemStack;
    }

    public boolean func_77875_a(World world, int xCoord, int yCoord, int zCoord) {
        return false;
    }

    public void setCapcity(int capacity) {
        this._capacity = capacity;
    }

    public String func_77667_c(ItemStack itemStack) {
        if (itemStack == null) {
            return this.func_77658_a();
        }
        int index = itemStack.func_77960_j();
        String fluidName = (String)this.fluidNames.get((Object)index);
        if (fluidName == null) {
            return this.func_77658_a();
        }
        return "item.extratic.bucket.filled." + fluidName;
    }

    public void addTextureMaping(int id, String fluidName, String texture) {
        this.fluidNames.put((Object)id, (Object)fluidName);
        this.textures.put(id, texture);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List itemStackList) {
        if (!this.fluidNames.isEmpty()) {
            for (Map.Entry subItem : this.fluidNames.entrySet()) {
                int entryId = (Integer)subItem.getKey();
                ItemStack bucketStack = new ItemStack((Item)this, 1, entryId);
                itemStackList.add(bucketStack);
            }
        } else {
            itemStackList.add(new ItemStack((Item)this, 1, 0));
        }
    }
}

