/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.extratic.common;

import cpw.mods.fml.common.registry.GameRegistry;
import glassmaker.extratic.common.Debug;
import glassmaker.extratic.common.ModHandler;
import glassmaker.extratic.common.PartsHandler;
import glassmaker.extratic.integration.SteelworksIntegration;
import glassmaker.extratic.parts.Part;
import glassmaker.extratic.references.RefAlloy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.CastingRecipe;
import tconstruct.library.crafting.LiquidCasting;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.crafting.Smeltery;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.TinkerTools;
import tconstruct.util.config.PHConstruct;
import tconstruct.world.TinkerWorld;

public class RecipeHandler {
    private static LiquidCasting basinCasting = TConstructRegistry.getBasinCasting();
    private static LiquidCasting tableCasting = TConstructRegistry.getTableCasting();
    private static Item pattern = TConstructRegistry.getItem((String)"woodPattern");
    private static Item cast = TConstructRegistry.getItem((String)"metalPattern");
    private static final ItemStack toolRodPattern = TConstructRegistry.getItemStack((String)"toolRodPattern");
    private static final ItemStack pickaxeHeadPattern = TConstructRegistry.getItemStack((String)"pickaxeHeadPattern");
    private static final ItemStack shovelHeadPattern = TConstructRegistry.getItemStack((String)"shovelHeadPattern");
    private static final ItemStack hatchetHeadPattern = TConstructRegistry.getItemStack((String)"hatchetHeadPattern");
    private static final ItemStack swordBladePattern = TConstructRegistry.getItemStack((String)"swordBladePattern");
    private static final ItemStack wideGuardPattern = TConstructRegistry.getItemStack((String)"wideGuardPattern");
    private static final ItemStack handGuardPattern = TConstructRegistry.getItemStack((String)"handGuardPattern");
    private static final ItemStack crossbarPattern = TConstructRegistry.getItemStack((String)"crossbarPattern");
    private static final ItemStack bindingPattern = TConstructRegistry.getItemStack((String)"bindingPattern");
    private static final ItemStack frypanHeadPattern = TConstructRegistry.getItemStack((String)"frypanHeadPattern");
    private static final ItemStack signHeadPattern = TConstructRegistry.getItemStack((String)"signHeadPattern");
    private static final ItemStack knifeBladePattern = TConstructRegistry.getItemStack((String)"knifeBladePattern");
    private static final ItemStack chiselHeadPattern = TConstructRegistry.getItemStack((String)"chiselHeadPattern");
    private static final ItemStack toughRodPattern = TConstructRegistry.getItemStack((String)"toughRodPattern");
    private static final ItemStack toughBindingPattern = TConstructRegistry.getItemStack((String)"toughBindingPattern");
    private static final ItemStack largePlatePattern = TConstructRegistry.getItemStack((String)"largePlatePattern");
    private static final ItemStack broadAxeHeadPattern = TConstructRegistry.getItemStack((String)"broadAxeHeadPattern");
    private static final ItemStack scytheHeadPattern = TConstructRegistry.getItemStack((String)"scytheHeadPattern");
    private static final ItemStack excavatorHeadPattern = TConstructRegistry.getItemStack((String)"excavatorHeadPattern");
    private static final ItemStack largeBladePattern = TConstructRegistry.getItemStack((String)"largeBladePattern");
    private static final ItemStack hammerHeadPattern = TConstructRegistry.getItemStack((String)"hammerHeadPattern");
    private static final ItemStack fullGuardPattern = TConstructRegistry.getItemStack((String)"fullGuardPattern");
    private static final ItemStack arrowHeadPattern = new ItemStack(pattern, 1, 25);
    private static final ItemStack ingotCast = TConstructRegistry.getItemStack((String)"ingotCast");
    private static final ItemStack toolRodCast = TConstructRegistry.getItemStack((String)"toolRodCast");
    private static final ItemStack pickaxeHeadCast = TConstructRegistry.getItemStack((String)"pickaxeHeadCast");
    private static final ItemStack shovelHeadCast = TConstructRegistry.getItemStack((String)"shovelHeadCast");
    private static final ItemStack hatchetHeadCast = TConstructRegistry.getItemStack((String)"hatchetHeadCast");
    private static final ItemStack swordBladeCast = TConstructRegistry.getItemStack((String)"swordBladeCast");
    private static final ItemStack wideGuardCast = TConstructRegistry.getItemStack((String)"wideGuardCast");
    private static final ItemStack handGuardCast = TConstructRegistry.getItemStack((String)"handGuardCast");
    private static final ItemStack crossbarCast = TConstructRegistry.getItemStack((String)"crossbarCast");
    private static final ItemStack bindingCast = TConstructRegistry.getItemStack((String)"bindingCast");
    private static final ItemStack frypanHeadCast = TConstructRegistry.getItemStack((String)"frypanHeadCast");
    private static final ItemStack signHeadCast = TConstructRegistry.getItemStack((String)"signHeadCast");
    private static final ItemStack knifeBladeCast = TConstructRegistry.getItemStack((String)"knifeBladeCast");
    private static final ItemStack chiselHeadCast = TConstructRegistry.getItemStack((String)"chiselHeadCast");
    private static final ItemStack toughRodCast = TConstructRegistry.getItemStack((String)"toughRodCast");
    private static final ItemStack toughBindingCast = TConstructRegistry.getItemStack((String)"toughBindingCast");
    private static final ItemStack largePlateCast = TConstructRegistry.getItemStack((String)"largePlateCast");
    private static final ItemStack broadAxeHeadCast = TConstructRegistry.getItemStack((String)"broadAxeHeadCast");
    private static final ItemStack scytheHeadCast = TConstructRegistry.getItemStack((String)"scytheHeadCast");
    private static final ItemStack excavatorHeadCast = TConstructRegistry.getItemStack((String)"excavatorHeadCast");
    private static final ItemStack largeBladeCast = TConstructRegistry.getItemStack((String)"largeBladeCast");
    private static final ItemStack hammerHeadCast = TConstructRegistry.getItemStack((String)"hammerHeadCast");
    private static final ItemStack fullGuardCast = TConstructRegistry.getItemStack((String)"fullGuardCast");
    private static final ItemStack arrowHeadCast = new ItemStack(cast, 1, 25);
    private static final ItemStack tinkerMaterial = new ItemStack(TinkerTools.materials);
    private static final ItemStack tinkerOreSlag = new ItemStack(TinkerWorld.oreSlag);
    private static final ItemStack tinkerMetalBlock = new ItemStack(TinkerWorld.metalBlock);
    private static final int ingotLiquidValue = 144;
    private static final int ingotsPreOre = (int)PHConstruct.ingotsPerOre;
    private static Part _ARROWHEAD = PartsHandler.ARROWHEAD;
    private static Part _AXE_HEAD = PartsHandler.AXE_HEAD;
    private static Part _BATTLE_SIGN_HEAD = PartsHandler.BATTLE_SIGN_HEAD;
    private static Part _BINDING = PartsHandler.BINDING;
    private static Part _CHISEL_HEAD = PartsHandler.CHISEL_HEAD;
    private static Part _CHUNK = PartsHandler.CHUNK;
    private static Part _CROSSBAR = PartsHandler.CROSSBAR;
    private static Part _EXCAVATOR_HEAD = PartsHandler.EXCAVATOR_HEAD;
    private static Part _FRYPAN_HEAD = PartsHandler.FRYPAN_HEAD;
    private static Part _FULL_GUARD = PartsHandler.FULL_GUARD;
    private static Part _HAMMER_HEAD = PartsHandler.HAMMER_HEAD;
    private static Part _KNIFE_BLADE = PartsHandler.KNIFE_BLADE;
    private static Part _LARGE_GUARD = PartsHandler.LARGE_GUARD;
    private static Part _LARGE_SWORD_BLADE = PartsHandler.LARGE_SWORD_BLADE;
    private static Part _LARGEPLATE = PartsHandler.LARGEPLATE;
    private static Part _LUMBERAXE_HEAD = PartsHandler.LUMBERAXE_HEAD;
    private static Part _MEDIUM_GUARD = PartsHandler.MEDIUM_GUARD;
    private static Part _PICKAXE_HEAD = PartsHandler.PICKAXE_HEAD;
    private static Part _SCYTHE_HEAD = PartsHandler.SCYTHE_HEAD;
    private static Part _SHOVEL_HEAD = PartsHandler.SHOVEL_HEAD;
    private static Part _SWORD_BLADE = PartsHandler.SWORD_BLADE;
    private static Part _TOOLROD = PartsHandler.TOOLROD;
    private static Part _TOUGHBIND = PartsHandler.TOUGHBIND;
    private static Part _TOUGHROD = PartsHandler.TOUGHROD;
    private static boolean steelWorksSmeltery = false;

    public static void addRecipes() {
        RecipeHandler.addPartsRecipes();
        RecipeHandler.addToolsRecipes();
        RecipeHandler.addCraftingRecipies();
    }

    public static void addPartsRecipes() {
        ModHandler modHandler = ModHandler.getInstance();
        if (modHandler.isEnabled("TSteelworks")) {
            steelWorksSmeltery = true;
        }
        if (modHandler.isEnabled("Metallurgy")) {
            RecipeHandler._addM3BaseRecipes();
            RecipeHandler._addM3BaseAlloyMixing();
            RecipeHandler._addM3PreciousRecipes();
            RecipeHandler._addM3PreciousAlloyMixing();
            RecipeHandler._addM3NetherRecipes();
            RecipeHandler._addM3NetherAlloyMixing();
            RecipeHandler._addM3FantasyRecipes();
            RecipeHandler._addM3FantasyAlloyMixing();
            RecipeHandler._addM3EnderRecipes();
            RecipeHandler._addM3EnderAlloyMixing();
        }
        if (modHandler.isEnabled("Natura")) {
            RecipeHandler._addNaturaRecipes();
        }
        if (modHandler.isEnabled("Mekanism")) {
            RecipeHandler._addMekanismRecipes();
        }
        if (modHandler.isEnabled("FunStuff")) {
            RecipeHandler._addFunStuffRecipes();
            RecipeHandler._addFunStuffAlloyMixng();
        }
        if (modHandler.isEnabled("AE")) {
            RecipeHandler._addAERecipes();
        }
        if (modHandler.isEnabled("BOP")) {
            RecipeHandler._addBOPRecipes();
        }
    }

    public static void addToolsRecipes() {
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.arrow, (Item[])new Item[]{_ARROWHEAD, _TOOLROD, TinkerTools.fletching});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.battleaxe, (Item[])new Item[]{_LUMBERAXE_HEAD, _TOUGHROD, _LUMBERAXE_HEAD, _TOUGHBIND});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.battlesign, (Item[])new Item[]{_BATTLE_SIGN_HEAD, _TOOLROD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.broadsword, (Item[])new Item[]{_SWORD_BLADE, _TOOLROD, _LARGE_GUARD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.chisel, (Item[])new Item[]{_CHISEL_HEAD, _TOOLROD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.cleaver, (Item[])new Item[]{_LARGE_SWORD_BLADE, _TOUGHROD, _LARGEPLATE, _TOUGHROD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.cutlass, (Item[])new Item[]{_SWORD_BLADE, _TOOLROD, _FULL_GUARD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.dagger, (Item[])new Item[]{_KNIFE_BLADE, _TOOLROD, _CROSSBAR});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.excavator, (Item[])new Item[]{_EXCAVATOR_HEAD, _TOUGHROD, _LARGEPLATE, _TOUGHBIND});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.frypan, (Item[])new Item[]{_FRYPAN_HEAD, _TOOLROD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.hammer, (Item[])new Item[]{_HAMMER_HEAD, _TOUGHROD, _LARGEPLATE, _LARGEPLATE});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.hatchet, (Item[])new Item[]{_AXE_HEAD, _TOOLROD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.longsword, (Item[])new Item[]{_SWORD_BLADE, _TOOLROD, _MEDIUM_GUARD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.lumberaxe, (Item[])new Item[]{_LUMBERAXE_HEAD, _TOUGHROD, _LARGEPLATE, _TOUGHBIND});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.mattock, (Item[])new Item[]{_AXE_HEAD, _TOOLROD, _SHOVEL_HEAD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.pickaxe, (Item[])new Item[]{_PICKAXE_HEAD, _TOOLROD, _BINDING});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.rapier, (Item[])new Item[]{_SWORD_BLADE, _TOOLROD, _CROSSBAR});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.scythe, (Item[])new Item[]{_SCYTHE_HEAD, _TOUGHROD, _TOUGHBIND, _TOUGHROD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.shortbow, (Item[])new Item[]{_TOOLROD, TinkerTools.bowstring, _TOOLROD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.shortbow, (Item[])new Item[]{TinkerTools.toolRod, TinkerTools.bowstring, _TOOLROD});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.shortbow, (Item[])new Item[]{_TOOLROD, TinkerTools.bowstring, TinkerTools.toolRod});
        TConstructRegistry.addToolRecipe((ToolCore)TinkerTools.shovel, (Item[])new Item[]{_SHOVEL_HEAD, _TOOLROD});
    }

    public static void addCraftingRecipies() {
        RecipeHandler._AddFunStuffCraftingRecipes();
    }

    private static void _addMeltingOreRecipe(String oreName, String fluidName, int ingotValue, int meltingTemp) {
        ArrayList ores = OreDictionary.getOres((String)oreName);
        if (!ores.isEmpty()) {
            FluidStack fluid = new FluidStack(FluidRegistry.getFluid((String)fluidName), 144 * ingotValue);
            for (ItemStack ore : ores) {
                Block block = Block.func_149634_a((Item)ore.func_77973_b());
                if (block != Blocks.field_150350_a) {
                    Smeltery.addMelting((ItemStack)ore, (Block)block, (int)ore.func_77960_j(), (int)meltingTemp, (FluidStack)fluid);
                } else {
                    Smeltery.addMelting((ItemStack)ore, (Block)Blocks.field_150348_b, (int)0, (int)meltingTemp, (FluidStack)fluid);
                }
                if (!steelWorksSmeltery) continue;
                SteelworksIntegration.addMelting(ore, meltingTemp, fluid);
            }
        } else {
            Debug.warnning("Ore " + oreName + " Was not found, skipping adding melting recipe");
        }
    }

    public static void _addMeltingOreRecipe(String oreName, String fluidName, int ingotValue, int meltingTemp, ItemStack skipItemStack) {
        ArrayList ores = OreDictionary.getOres((String)oreName);
        if (!ores.isEmpty()) {
            FluidStack fluid = new FluidStack(FluidRegistry.getFluid((String)fluidName), 144 * ingotValue);
            for (ItemStack ore : ores) {
                if (ore.func_77973_b() == skipItemStack.func_77973_b()) continue;
                Block block = Block.func_149634_a((Item)ore.func_77973_b());
                if (block != Blocks.field_150350_a) {
                    Smeltery.addMelting((ItemStack)ore, (Block)block, (int)ore.func_77960_j(), (int)meltingTemp, (FluidStack)fluid);
                } else {
                    Smeltery.addMelting((ItemStack)ore, (Block)Blocks.field_150348_b, (int)0, (int)meltingTemp, (FluidStack)fluid);
                }
                if (!steelWorksSmeltery) continue;
                SteelworksIntegration.addMelting(ore, meltingTemp, fluid);
            }
        } else {
            Debug.warnning("Ore " + oreName + " Was not found, skipping adding melting recipe");
        }
    }

    private static void _addOreIngotCastRecipe(String oreName, String fluidName, int ingotValue, int hardeningDelay) {
        ArrayList ores = OreDictionary.getOres((String)oreName);
        if (!ores.isEmpty()) {
            FluidStack fluid = new FluidStack(FluidRegistry.getFluid((String)fluidName), 144 * ingotValue);
            ItemStack ingot = (ItemStack)ores.get(0);
            tableCasting.addCastingRecipe(ingot, fluid, ingotCast, hardeningDelay);
        } else {
            Debug.warnning("Ore " + oreName + " Was not found, skipping adding cast recipe");
        }
    }

    private static void _addOreBlockCastRecipe(String oreName, String fluidName, int ingotValue, int hardeningDelay) {
        ArrayList ores = OreDictionary.getOres((String)oreName);
        if (!ores.isEmpty()) {
            FluidStack fluid = new FluidStack(FluidRegistry.getFluid((String)fluidName), 144 * ingotValue);
            ItemStack block = (ItemStack)ores.get(0);
            basinCasting.addCastingRecipe(block, fluid, hardeningDelay);
        } else {
            Debug.warnning("Ore " + oreName + " Was not found, skipping adding cast recipe");
        }
    }

    private static void _addMeltingItemStackRecipe(ItemStack itemStack, String fluidName, double ingotValue, int meltingTemp) {
        int fluidValue = (int)Math.round(144.0 * ingotValue);
        FluidStack fluid = new FluidStack(FluidRegistry.getFluid((String)fluidName), fluidValue);
        Smeltery.addMelting((ItemStack)itemStack, (Block)Blocks.field_150348_b, (int)0, (int)meltingTemp, (FluidStack)fluid);
        if (steelWorksSmeltery) {
            SteelworksIntegration.addMelting(itemStack, meltingTemp, fluid);
        }
    }

    private static ItemStack _getItemStackfromCraftingManager(String itemName) {
        List list = CraftingManager.func_77594_a().func_77592_b();
        ItemStack itemStack = null;
        for (int i = 0; i < list.size(); ++i) {
            IRecipe recipe = (IRecipe)list.get(i);
            ItemStack currentItemStack = recipe.func_77571_b();
            if (currentItemStack == null) continue;
            Item item = currentItemStack.func_77973_b();
            if (item != null) {
                String foundItemName = currentItemStack.func_77977_a();
                if (!foundItemName.equals(itemName)) continue;
                itemStack = currentItemStack;
                break;
            }
            Debug.debugWarnning("Encountered invalid item with ID: " + item + ", Skipping...");
        }
        return itemStack;
    }

    private static void _addMeltingItemRecipe(String itemName, String fluidName, int ingotValue, int MeltingTemp) {
        ItemStack itemStack = RecipeHandler._getItemStackfromCraftingManager(itemName);
        if (itemStack != null) {
            RecipeHandler._addMeltingItemStackRecipe(itemStack, fluidName, ingotValue, MeltingTemp);
        } else {
            Debug.warnning("Item " + itemName + " was not found, skipping adding melting recipe");
        }
    }

    public void addBasinCastingRecipes() {
        LiquidCasting basinCasting = TConstructRegistry.getBasinCasting();
        basinCasting.addCastingRecipe(new ItemStack(Blocks.field_150432_aD), new FluidStack(FluidRegistry.getFluid((String)"water"), 144), 100);
    }

    private void _removeBasinCastingRecipe(String itemName) {
        LiquidCasting basinCasting = TConstructRegistry.getBasinCasting();
        ArrayList castingRecipes = basinCasting.getCastingRecipes();
        for (int i = 0; i < castingRecipes.size(); ++i) {
            if (!itemName.equals(((CastingRecipe)castingRecipes.get(i)).getResult().func_77977_a())) continue;
            castingRecipes.remove(i);
        }
    }

    private static void _addItemStackCasting(ItemStack output, ItemStack cast, String fluidName, double ingotValue, int hardeningDelay) {
        int fluidValue = (int)Math.round(144.0 * ingotValue);
        FluidStack fluid = new FluidStack(FluidRegistry.getFluid((String)fluidName), fluidValue);
        tableCasting.addCastingRecipe(output, fluid, cast, hardeningDelay);
    }

    private static void _addToolsCasting(int matiralID, String fluidname, int hardeningDelay) {
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_TOOLROD, 1, matiralID), toolRodCast, fluidname, 0.5, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_PICKAXE_HEAD, 1, matiralID), pickaxeHeadCast, fluidname, 1.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_SHOVEL_HEAD, 1, matiralID), shovelHeadCast, fluidname, 1.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_AXE_HEAD, 1, matiralID), hatchetHeadCast, fluidname, 1.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_SWORD_BLADE, 1, matiralID), swordBladeCast, fluidname, 1.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_LARGE_GUARD, 1, matiralID), wideGuardCast, fluidname, 0.5, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_MEDIUM_GUARD, 1, matiralID), handGuardCast, fluidname, 0.5, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_CROSSBAR, 1, matiralID), crossbarCast, fluidname, 0.5, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_BINDING, 1, matiralID), bindingCast, fluidname, 0.5, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_FRYPAN_HEAD, 1, matiralID), frypanHeadCast, fluidname, 1.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_BATTLE_SIGN_HEAD, 1, matiralID), signHeadCast, fluidname, 1.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_KNIFE_BLADE, 1, matiralID), knifeBladeCast, fluidname, 0.5, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_CHISEL_HEAD, 1, matiralID), chiselHeadCast, fluidname, 0.5, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_TOUGHROD, 1, matiralID), toughRodCast, fluidname, 3.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_TOUGHBIND, 1, matiralID), toughBindingCast, fluidname, 3.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_LARGEPLATE, 1, matiralID), largePlateCast, fluidname, 8.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_LUMBERAXE_HEAD, 1, matiralID), broadAxeHeadCast, fluidname, 8.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_SCYTHE_HEAD, 1, matiralID), scytheHeadCast, fluidname, 8.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_EXCAVATOR_HEAD, 1, matiralID), excavatorHeadCast, fluidname, 8.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_LARGE_SWORD_BLADE, 1, matiralID), largeBladeCast, fluidname, 8.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_HAMMER_HEAD, 1, matiralID), hammerHeadCast, fluidname, 8.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_FULL_GUARD, 1, matiralID), fullGuardCast, fluidname, 3.0, hardeningDelay);
        RecipeHandler._addItemStackCasting(new ItemStack((Item)_ARROWHEAD, 1, matiralID), arrowHeadCast, fluidname, 1.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_TOOLROD, 1, matiralID), fluidname, 0.5, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_PICKAXE_HEAD, 1, matiralID), fluidname, 1.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_SHOVEL_HEAD, 1, matiralID), fluidname, 1.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_AXE_HEAD, 1, matiralID), fluidname, 1.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_SWORD_BLADE, 1, matiralID), fluidname, 1.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_LARGE_GUARD, 1, matiralID), fluidname, 0.5, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_MEDIUM_GUARD, 1, matiralID), fluidname, 0.5, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_CROSSBAR, 1, matiralID), fluidname, 0.5, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_BINDING, 1, matiralID), fluidname, 0.5, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_FRYPAN_HEAD, 1, matiralID), fluidname, 1.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_BATTLE_SIGN_HEAD, 1, matiralID), fluidname, 1.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_KNIFE_BLADE, 1, matiralID), fluidname, 0.5, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_CHISEL_HEAD, 1, matiralID), fluidname, 0.5, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_TOUGHROD, 1, matiralID), fluidname, 3.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_TOUGHBIND, 1, matiralID), fluidname, 3.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_LARGEPLATE, 1, matiralID), fluidname, 8.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_LUMBERAXE_HEAD, 1, matiralID), fluidname, 8.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_SCYTHE_HEAD, 1, matiralID), fluidname, 8.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_EXCAVATOR_HEAD, 1, matiralID), fluidname, 8.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_LARGE_SWORD_BLADE, 1, matiralID), fluidname, 8.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_HAMMER_HEAD, 1, matiralID), fluidname, 8.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_FULL_GUARD, 1, matiralID), fluidname, 3.0, hardeningDelay);
        RecipeHandler._addMeltingItemStackRecipe(new ItemStack((Item)_ARROWHEAD, 1, matiralID), fluidname, 1.0, hardeningDelay);
    }

    private static void _addItemStackPartBuilding(ItemStack pattern, int materialID, ItemStack part) {
        TConstructRegistry.addPartMapping((Item)pattern.func_77973_b(), (int)pattern.func_77960_j(), (int)materialID, (ItemStack)part);
    }

    private static void _addPartBuilding(int materialID) {
        RecipeHandler._addItemStackPartBuilding(toolRodPattern, materialID, new ItemStack((Item)_TOOLROD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(pickaxeHeadPattern, materialID, new ItemStack((Item)_PICKAXE_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(shovelHeadPattern, materialID, new ItemStack((Item)_SHOVEL_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(hatchetHeadPattern, materialID, new ItemStack((Item)_AXE_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(swordBladePattern, materialID, new ItemStack((Item)_SWORD_BLADE, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(wideGuardPattern, materialID, new ItemStack((Item)_LARGE_GUARD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(handGuardPattern, materialID, new ItemStack((Item)_MEDIUM_GUARD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(crossbarPattern, materialID, new ItemStack((Item)_CROSSBAR, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(bindingPattern, materialID, new ItemStack((Item)_BINDING, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(frypanHeadPattern, materialID, new ItemStack((Item)_FRYPAN_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(signHeadPattern, materialID, new ItemStack((Item)_BATTLE_SIGN_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(knifeBladePattern, materialID, new ItemStack((Item)_KNIFE_BLADE, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(chiselHeadPattern, materialID, new ItemStack((Item)_CHISEL_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(toughRodPattern, materialID, new ItemStack((Item)_TOUGHROD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(toughBindingPattern, materialID, new ItemStack((Item)_TOUGHBIND, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(largePlatePattern, materialID, new ItemStack((Item)_LARGEPLATE, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(broadAxeHeadPattern, materialID, new ItemStack((Item)_LUMBERAXE_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(scytheHeadPattern, materialID, new ItemStack((Item)_SCYTHE_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(excavatorHeadPattern, materialID, new ItemStack((Item)_EXCAVATOR_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(largeBladePattern, materialID, new ItemStack((Item)_LARGE_SWORD_BLADE, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(hammerHeadPattern, materialID, new ItemStack((Item)_HAMMER_HEAD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(fullGuardPattern, materialID, new ItemStack((Item)_FULL_GUARD, 1, materialID));
        RecipeHandler._addItemStackPartBuilding(arrowHeadPattern, materialID, new ItemStack((Item)_ARROWHEAD, 1, materialID));
    }

    private static void _registerWithStations(String ingotName, String materialName, int materialID) {
        ArrayList ingots = OreDictionary.getOres((String)ingotName);
        if (!ingots.isEmpty()) {
            for (ItemStack ingot : ingots) {
                RecipeHandler._registerWithStations(ingot, materialName, materialID, new ItemStack((Item)_CHUNK, 1, materialID));
            }
        }
    }

    private static void _registerWithStations(ItemStack material, String materialName, int materialID, ItemStack chunk) {
        PatternBuilder.instance.registerFullMaterial(material, 2, materialName, chunk, new ItemStack((Item)_TOOLROD, 1, materialID), materialID);
    }

    private static void _unregisterMaterial(ItemStack material) {
        List materials = PatternBuilder.instance.materials;
        for (int i = 0; i < materials.size(); ++i) {
            PatternBuilder.ItemKey itemKey = (PatternBuilder.ItemKey)materials.get(i);
            if (itemKey.item != material.func_77973_b() || material.func_77960_j() != itemKey.damage) continue;
            materials.remove(i);
        }
    }

    private static void _addM3BaseRecipes() {
        String blockName;
        String dustName;
        String oreName;
        String blockName2;
        String dustName2;
        String ingotName;
        int MeltingTemp;
        String fluidName = null;
        fluidName = "angmallen.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 500;
            ingotName = "ingotAngmallen";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName2 = "dustAngmallen";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockAngmallen";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.angmallen.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.angmallen.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.angmallen.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.angmallen.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.angmallen.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.angmallen.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.angmallen.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.angmallen.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.angmallen.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(100, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Angmallen", 100);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "bronze.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotBronze";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, tinkerMaterial);
            dustName2 = "dustBronze";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockBronze";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp, tinkerMetalBlock);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.bronze.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.bronze.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.bronze.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.bronze.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.bronze.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.bronze.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.bronze.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.bronze.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.bronze.boots", fluidName, 4, MeltingTemp);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "copper.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotCopper";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, tinkerMaterial);
            oreName = "oreCopper";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp, tinkerOreSlag);
            dustName = "dustCopper";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockCopper";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp, tinkerMetalBlock);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.copper.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.copper.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.copper.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.copper.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.copper.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.copper.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.copper.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.copper.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.copper.boots", fluidName, 4, MeltingTemp);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "damascus.steel.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 700;
            ingotName = "ingotDamascusSteel";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName2 = "dustDamascusSteel";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockDamascusSteel";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.damascus.steel.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.damascus.steel.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.damascus.steel.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.damascus.steel.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.damascus.steel.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.damascus.steel.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.damascus.steel.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.damascus.steel.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.damascus.steel.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(101, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Damascus Steel", 101);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "hepatizon.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 700;
            ingotName = "ingotHepatizon";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName2 = "dustHepatizon";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockHepatizon";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.hepatizon.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.hepatizon.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.hepatizon.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.hepatizon.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.hepatizon.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.hepatizon.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.hepatizon.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.hepatizon.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.hepatizon.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(102, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Hepatizon", 102);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "manganese.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 700;
            ingotName = "ingotManganese";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreManganese";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustManganese";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockManganese";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "steel.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 700;
            ingotName = "ingotSteel";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, tinkerMaterial);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName2 = "dustSteel";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockSteel";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp, tinkerMetalBlock);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.steel.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.steel.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.steel.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.steel.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.steel.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.steel.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.steel.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.steel.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.steel.boots", fluidName, 4, MeltingTemp);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "tin.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 350;
            ingotName = "ingotTin";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, tinkerMaterial);
            oreName = "oreTin";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp, tinkerOreSlag);
            dustName = "dustTin";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockTin";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp, tinkerMetalBlock);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
    }

    private static void _addM3BaseAlloyMixing() {
        int ironAmount;
        if (FluidRegistry.isFluidRegistered((String)"angmallen.molten") && FluidRegistry.isFluidRegistered((String)"gold.molten") && FluidRegistry.isFluidRegistered((String)"iron.molten") && RefAlloy.ANGMALLEN_RATIO.length == 3) {
            int angamallenAmount = 144 * RefAlloy.ANGMALLEN_RATIO[2];
            int goldAmount = 144 * RefAlloy.ANGMALLEN_RATIO[0];
            int ironAmount2 = 144 * RefAlloy.ANGMALLEN_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"angmallen.molten"), angamallenAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"gold.molten"), goldAmount), new FluidStack(FluidRegistry.getFluid((String)"iron.molten"), ironAmount2)});
        }
        if (FluidRegistry.isFluidRegistered((String)"damascus.steel.molten") && FluidRegistry.isFluidRegistered((String)"iron.molten") && FluidRegistry.isFluidRegistered((String)"bronze.molten") && RefAlloy.DAMASCUS_STEEL_RATIO.length == 3) {
            int dSteelAmount = 144 * RefAlloy.DAMASCUS_STEEL_RATIO[2];
            ironAmount = 144 * RefAlloy.DAMASCUS_STEEL_RATIO[0];
            int bronzeAmount = 144 * RefAlloy.DAMASCUS_STEEL_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"damascus.steel.molten"), dSteelAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"iron.molten"), ironAmount), new FluidStack(FluidRegistry.getFluid((String)"bronze.molten"), bronzeAmount)});
        }
        if (FluidRegistry.isFluidRegistered((String)"bronze.molten") && FluidRegistry.isFluidRegistered((String)"gold.molten") && FluidRegistry.isFluidRegistered((String)"hepatizon.molten") && RefAlloy.HEPATIZON_RATIO.length == 3) {
            int hepatizonAmount = 144 * RefAlloy.HEPATIZON_RATIO[2];
            int bronzeAmount = 144 * RefAlloy.HEPATIZON_RATIO[0];
            int goldAmount = 144 * RefAlloy.HEPATIZON_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"hepatizon.molten"), hepatizonAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"bronze.molten"), bronzeAmount), new FluidStack(FluidRegistry.getFluid((String)"gold.molten"), goldAmount)});
        }
        if (FluidRegistry.isFluidRegistered((String)"steel.molten") && FluidRegistry.isFluidRegistered((String)"iron.molten") && FluidRegistry.isFluidRegistered((String)"manganese.molten") && RefAlloy.STEEL_RATIO.length == 3) {
            int steelAmount = 144 * RefAlloy.STEEL_RATIO[2];
            ironAmount = 144 * RefAlloy.STEEL_RATIO[0];
            int manganessAmount = 144 * RefAlloy.STEEL_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"steel.molten"), steelAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"iron.molten"), ironAmount), new FluidStack(FluidRegistry.getFluid((String)"manganese.molten"), manganessAmount)});
        }
    }

    private static void _addM3PreciousRecipes() {
        String blockName;
        String dustName;
        String oreName;
        String blockName2;
        String dustName2;
        String ingotName;
        int MeltingTemp;
        String fluidName = null;
        fluidName = "brass.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotBrass";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, tinkerMaterial);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName2 = "dustBrass";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockBrass";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp, tinkerMetalBlock);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.brass.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.brass.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.brass.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.brass.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.brass.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.brass.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.brass.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.brass.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.brass.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(103, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Brass", 103);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "electrum.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotElectrum";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, tinkerMaterial);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName2 = "dustElectrum";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockElectrum";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp, tinkerMetalBlock);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.electrum.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.electrum.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.electrum.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.electrum.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.electrum.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.electrum.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.electrum.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.electrum.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.electrum.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(104, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Electrum", 104);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "platinum.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotPlatinum";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, tinkerMaterial);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "orePlatinum";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp, tinkerOreSlag);
            dustName = "dustPlatinum";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockPlatinum";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp, tinkerMetalBlock);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.platinum.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.platinum.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.platinum.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.platinum.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.platinum.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.platinum.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.platinum.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.platinum.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.platinum.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(105, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Platinum", 105);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "silver.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotSilver";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, tinkerMaterial);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreSilver";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp, tinkerOreSlag);
            dustName = "dustSilver";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockSilver";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp, tinkerMetalBlock);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.silver.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.silver.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.silver.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.silver.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.silver.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.silver.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.silver.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.silver.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.silver.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(106, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Silver", 106);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "zinc.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotZinc";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, tinkerMaterial);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreZinc";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp, tinkerOreSlag);
            dustName = "dustZinc";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockZinc";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp, tinkerMetalBlock);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
    }

    private static void _addM3PreciousAlloyMixing() {
        if (FluidRegistry.isFluidRegistered((String)"brass.molten") && FluidRegistry.isFluidRegistered((String)"copper.molten") && FluidRegistry.isFluidRegistered((String)"zinc.molten") && RefAlloy.BRASS_RATIO.length == 3) {
            int brassAmount = 144 * RefAlloy.BRASS_RATIO[2];
            int copperAmount = 144 * RefAlloy.BRASS_RATIO[0];
            int zincAmount = 144 * RefAlloy.BRASS_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"brass.molten"), brassAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"copper.molten"), copperAmount), new FluidStack(FluidRegistry.getFluid((String)"zinc.molten"), zincAmount)});
        }
        if (FluidRegistry.isFluidRegistered((String)"electrum.molten") && FluidRegistry.isFluidRegistered((String)"gold.molten") && FluidRegistry.isFluidRegistered((String)"silver.molten") && RefAlloy.ELECTRUM_RATIO.length == 3) {
            int electrumAmount = 144 * RefAlloy.ELECTRUM_RATIO[2];
            int goldAmount = 144 * RefAlloy.ELECTRUM_RATIO[0];
            int silverAmount = 144 * RefAlloy.ELECTRUM_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"electrum.molten"), electrumAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"gold.molten"), goldAmount), new FluidStack(FluidRegistry.getFluid((String)"silver.molten"), silverAmount)});
        }
    }

    private static void _addM3NetherRecipes() {
        String blockName;
        String dustName;
        String oreName;
        String blockName2;
        String dustName2;
        String ingotName;
        int MeltingTemp;
        String fluidName = null;
        fluidName = "amordrine.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotAmordrine";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName2 = "dustAmordrine";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockAmordrine";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.amordrine.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.amordrine.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.amordrine.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.amordrine.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.amordrine.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.amordrine.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.amordrine.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.amordrine.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.amordrine.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(107, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Amordrine", 107);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "alduorite.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotAlduorite";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreAlduorite";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustAlduorite";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockAlduorite";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "ceruclase.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotCeruclase";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreCeruclase";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustCeruclase";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockCeruclase";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ceruclase.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ceruclase.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ceruclase.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ceruclase.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ceruclase.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ceruclase.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ceruclase.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ceruclase.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ceruclase.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(108, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Ceruclase", 108);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "ignatius.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotIgnatius";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp, new ItemStack(TinkerTools.materials));
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreIgnatius";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp, new ItemStack(TinkerWorld.oreSlag));
            dustName = "dustIgnatius";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockIgnatius";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp, new ItemStack(TinkerWorld.metalBlock));
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ignatius.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ignatius.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ignatius.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ignatius.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ignatius.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ignatius.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ignatius.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ignatius.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.ignatius.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(109, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Ignatius", 109);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "inolashite.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotInolashite";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName2 = "dustInolashite";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockInolashite";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.inolashite.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.inolashite.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.inolashite.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.inolashite.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.inolashite.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.inolashite.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.inolashite.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.inolashite.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.inolashite.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(110, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Inolashite", 110);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "kalendrite.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotKalendrite";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreKalendrite";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustKalendrite";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockKalendrite";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.kalendrite.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.kalendrite.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.kalendrite.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.kalendrite.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.kalendrite.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.kalendrite.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.kalendrite.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.kalendrite.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.kalendrite.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(111, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Kalendrite", 111);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "lemurite.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotLemurite";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreLemurite";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustLemurite";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockLemurite";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "midasium.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotMidasium";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreMidasium";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustMidasium";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockMidasium";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.midasium.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.midasium.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.midasium.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.midasium.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.midasium.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.midasium.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.midasium.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.midasium.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.midasium.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(112, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Midasium", 112);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "sanguinite.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotSanguinite";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreSanguinite";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustSanguinite";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockSanguinite";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.sanguinite.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.sanguinite.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.sanguinite.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.sanguinite.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.sanguinite.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.sanguinite.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.sanguinite.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.sanguinite.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.sanguinite.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(113, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Sanguinite", 113);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "shadow.iron.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotShadowIron";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreShadowIron";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustShadowIron";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockShadowIron";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.iron.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.iron.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.iron.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.iron.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.iron.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.iron.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.iron.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.iron.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.iron.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(114, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Shadow Iron", 114);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "shadow.steel.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotShadowSteel";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName2 = "dustShadowSteel";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockShadowSteel";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.steel.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.steel.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.steel.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.steel.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.steel.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.steel.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.steel.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.steel.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.shadow.steel.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(115, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Shadow Steel", 115);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "vulcanite.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotVulcanite";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreVulcanite";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustVulcanite";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockVulcanite";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vulcanite.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vulcanite.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vulcanite.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vulcanite.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vulcanite.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vulcanite.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vulcanite.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vulcanite.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vulcanite.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(116, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Vulcanite", 116);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "vyroxeres.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotVyroxeres";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreVyroxeres";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustVyroxeres";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockVyroxeres";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vyroxeres.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vyroxeres.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vyroxeres.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vyroxeres.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vyroxeres.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vyroxeres.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vyroxeres.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vyroxeres.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.vyroxeres.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(117, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Vyroxeres", 117);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
    }

    private static void _addM3NetherAlloyMixing() {
        if (FluidRegistry.isFluidRegistered((String)"amordrine.molten") && FluidRegistry.isFluidRegistered((String)"kalendrite.molten") && FluidRegistry.isFluidRegistered((String)"platinum.molten") && RefAlloy.AMORDRINE_RATIO.length == 3) {
            int amordrineAmount = 144 * RefAlloy.AMORDRINE_RATIO[2];
            int kalendriteAmount = 144 * RefAlloy.AMORDRINE_RATIO[0];
            int platinumAmount = 144 * RefAlloy.AMORDRINE_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"amordrine.molten"), amordrineAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"kalendrite.molten"), kalendriteAmount), new FluidStack(FluidRegistry.getFluid((String)"platinum.molten"), platinumAmount)});
        }
        if (FluidRegistry.isFluidRegistered((String)"inolashite.molten") && FluidRegistry.isFluidRegistered((String)"alduorite.molten") && FluidRegistry.isFluidRegistered((String)"ceruclase.molten") && RefAlloy.INOLASHITE_RATIO.length == 3) {
            int inolashiteAmount = 144 * RefAlloy.INOLASHITE_RATIO[2];
            int alduoriteAmount = 144 * RefAlloy.INOLASHITE_RATIO[0];
            int ceruclaseAmount = 144 * RefAlloy.INOLASHITE_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"inolashite.molten"), inolashiteAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"alduorite.molten"), alduoriteAmount), new FluidStack(FluidRegistry.getFluid((String)"ceruclase.molten"), ceruclaseAmount)});
        }
        if (FluidRegistry.isFluidRegistered((String)"shadow.steel.molten") && FluidRegistry.isFluidRegistered((String)"shadow.iron.molten") && FluidRegistry.isFluidRegistered((String)"lemurite.molten") && RefAlloy.SHADOW_STEEL_RATIO.length == 3) {
            int shadowSteelAmount = 144 * RefAlloy.SHADOW_STEEL_RATIO[2];
            int shadowIronAmount = 144 * RefAlloy.SHADOW_STEEL_RATIO[0];
            int lemuriteAmount = 144 * RefAlloy.SHADOW_STEEL_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"shadow.steel.molten"), shadowSteelAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"shadow.iron.molten"), shadowIronAmount), new FluidStack(FluidRegistry.getFluid((String)"lemurite.molten"), lemuriteAmount)});
        }
    }

    private static void _addM3FantasyRecipes() {
        String blockName;
        String dustName;
        String blockName2;
        String dustName2;
        String oreName;
        String ingotName;
        int MeltingTemp;
        String fluidName = null;
        fluidName = "adamantine.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotAdamantine";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreAdamantine";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustAdamantine";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockAdamantine";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.adamantine.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.adamantine.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.adamantine.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.adamantine.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.adamantine.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.adamantine.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.adamantine.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.adamantine.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.adamantine.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(118, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Adamantine", 118);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "astral.silver.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotAstralSilver";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreAstralSilver";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustAstralSilver";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockAstralSilver";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.astral.silver.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.astral.silver.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.astral.silver.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.astral.silver.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.astral.silver.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.astral.silver.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.astral.silver.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.astral.silver.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.astral.silver.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(119, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Astral Silver", 119);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "atlarus.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotAtlarus";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreAtlarus";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustAtlarus";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockAtlarus";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.atlarus.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.atlarus.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.atlarus.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.atlarus.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.atlarus.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.atlarus.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.atlarus.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.atlarus.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.atlarus.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(120, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Atlarus", 120);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "black.steel.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotBlackSteel";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName = "dustBlackSteel";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockBlackSteel";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.black.steel.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.black.steel.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.black.steel.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.black.steel.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.black.steel.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.black.steel.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.black.steel.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.black.steel.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.black.steel.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(121, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Black Steel", 121);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "carmot.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotCarmot";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreCarmot";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustCarmot";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockCarmot";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.carmot.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.carmot.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.carmot.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.carmot.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.carmot.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.carmot.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.carmot.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.carmot.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.carmot.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(122, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Carmot", 122);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "celenegil.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotCelenegil";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName = "dustCelenegil";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockCelenegil";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.celenegil.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.celenegil.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.celenegil.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.celenegil.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.celenegil.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.celenegil.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.celenegil.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.celenegil.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.celenegil.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(123, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Celenegil", 123);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "deep.iron.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotDeepIron";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreDeepIron";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustDeepIron";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockDeepIron";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.deep.iron.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.deep.iron.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.deep.iron.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.deep.iron.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.deep.iron.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.deep.iron.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.deep.iron.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.deep.iron.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.deep.iron.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(124, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Deep Iron", 124);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "haderoth.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotHaderoth";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName = "dustHaderoth";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockHaderoth";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.haderoth.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.haderoth.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.haderoth.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.haderoth.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.haderoth.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.haderoth.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.haderoth.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.haderoth.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.haderoth.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(125, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Haderoth", 125);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "infuscolium.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotInfuscolium";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreInfuscolium";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustInfuscolium";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockInfuscolium";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "mithril.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotMithril";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreMithril";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustMithril";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockMithril";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.mithril.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.mithril.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.mithril.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.mithril.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.mithril.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.mithril.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.mithril.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.mithril.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.mithril.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(126, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Mithril", 126);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "orichalcum.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotOrichalcum";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreOrichalcum";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustOrichalcum";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockOrichalcum";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.orichalcum.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.orichalcum.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.orichalcum.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.orichalcum.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.orichalcum.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.orichalcum.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.orichalcum.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.orichalcum.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.orichalcum.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(127, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Orichalcum", 127);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "oureclase.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotOureclase";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreOureclase";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustOureclase";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockOureclase";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.oureclase.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.oureclase.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.oureclase.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.oureclase.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.oureclase.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.oureclase.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.oureclase.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.oureclase.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.oureclase.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(128, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Oureclase", 128);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "prometheum.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotPrometheum";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "orePrometheum";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustPrometheum";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockPrometheum";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.prometheum.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.prometheum.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.prometheum.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.prometheum.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.prometheum.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.prometheum.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.prometheum.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.prometheum.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.prometheum.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(129, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Prometheum", 129);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "quicksilver.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotQuicksilver";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName = "dustQuicksilver";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockQuicksilver";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.quicksilver.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.quicksilver.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.quicksilver.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.quicksilver.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.quicksilver.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.quicksilver.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.quicksilver.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.quicksilver.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.quicksilver.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(130, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Quicksilver", 130);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "rubracium.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotRubracium";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreRubracium";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName2 = "dustRubracium";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            blockName2 = "blockRubracium";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "tartarite.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotTartarite";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            dustName = "dustTartarite";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockTartarite";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.tartarite.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.tartarite.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.tartarite.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.tartarite.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.tartarite.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.tartarite.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.tartarite.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.tartarite.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.tartarite.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(131, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Tartarite", 131);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
    }

    private static void _addM3FantasyAlloyMixing() {
        int mithrilAmount;
        if (FluidRegistry.isFluidRegistered((String)"black.steel.molten") && FluidRegistry.isFluidRegistered((String)"infuscolium.molten") && FluidRegistry.isFluidRegistered((String)"deep.iron.molten") && RefAlloy.BLACK_STEEL_RATIO.length == 3) {
            int blackSteelAmount = 144 * RefAlloy.BLACK_STEEL_RATIO[2];
            int infuscoliumAmount = 144 * RefAlloy.BLACK_STEEL_RATIO[0];
            int deepIronAmount = 144 * RefAlloy.BLACK_STEEL_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"black.steel.molten"), blackSteelAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"infuscolium.molten"), infuscoliumAmount), new FluidStack(FluidRegistry.getFluid((String)"deep.iron.molten"), deepIronAmount)});
        }
        if (FluidRegistry.isFluidRegistered((String)"celenegil.molten") && FluidRegistry.isFluidRegistered((String)"orichalcum.molten") && FluidRegistry.isFluidRegistered((String)"platinum.molten") && RefAlloy.CELENEGIL_RATIO.length == 3) {
            int celenegilAmount = 144 * RefAlloy.CELENEGIL_RATIO[2];
            int orichalcumAmount = 144 * RefAlloy.CELENEGIL_RATIO[0];
            int platiumAmount = 144 * RefAlloy.CELENEGIL_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"celenegil.molten"), celenegilAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"orichalcum.molten"), orichalcumAmount), new FluidStack(FluidRegistry.getFluid((String)"platinum.molten"), platiumAmount)});
        }
        if (FluidRegistry.isFluidRegistered((String)"haderoth.molten") && FluidRegistry.isFluidRegistered((String)"mithril.molten") && FluidRegistry.isFluidRegistered((String)"rubracium.molten") && RefAlloy.HADEROTH_RATIO.length == 3) {
            int haderothAmount = 144 * RefAlloy.HADEROTH_RATIO[2];
            mithrilAmount = 144 * RefAlloy.HADEROTH_RATIO[0];
            int rubraciumAmount = 144 * RefAlloy.HADEROTH_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"haderoth.molten"), haderothAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"mithril.molten"), mithrilAmount), new FluidStack(FluidRegistry.getFluid((String)"rubracium.molten"), rubraciumAmount)});
        }
        if (FluidRegistry.isFluidRegistered((String)"quicksilver.molten") && FluidRegistry.isFluidRegistered((String)"mithril.molten") && FluidRegistry.isFluidRegistered((String)"silver.molten") && RefAlloy.QUICKSILVER_RATIO.length == 3) {
            int quicksilverAmount = 144 * RefAlloy.QUICKSILVER_RATIO[2];
            mithrilAmount = 144 * RefAlloy.QUICKSILVER_RATIO[0];
            int silverAmount = 144 * RefAlloy.QUICKSILVER_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"quicksilver.molten"), quicksilverAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"mithril.molten"), mithrilAmount), new FluidStack(FluidRegistry.getFluid((String)"silver.molten"), silverAmount)});
        }
        if (FluidRegistry.isFluidRegistered((String)"tartarite.molten") && FluidRegistry.isFluidRegistered((String)"adamantine.molten") && FluidRegistry.isFluidRegistered((String)"atlarus.molten") && RefAlloy.TARTARITE_RATIO.length == 3) {
            int tartariteAmount = 144 * RefAlloy.TARTARITE_RATIO[2];
            int adamantineAmount = 144 * RefAlloy.TARTARITE_RATIO[0];
            int altarusAmount = 144 * RefAlloy.TARTARITE_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"tartarite.molten"), tartariteAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"adamantine.molten"), adamantineAmount), new FluidStack(FluidRegistry.getFluid((String)"atlarus.molten"), altarusAmount)});
        }
    }

    private static void _addM3EnderRecipes() {
        String blockName;
        String dustName;
        String oreName;
        String ingotName;
        int MeltingTemp;
        String fluidName = null;
        fluidName = "desichalkos.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotDesichalkos";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            String dustName2 = "dustDesichalkos";
            RecipeHandler._addMeltingOreRecipe(dustName2, fluidName, 1, MeltingTemp);
            String blockName2 = "blockDesichalkos";
            RecipeHandler._addMeltingOreRecipe(blockName2, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName2, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.desichalkos.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.desichalkos.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.desichalkos.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.desichalkos.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.desichalkos.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.desichalkos.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.desichalkos.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.desichalkos.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.desichalkos.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(132, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Desichalkos", 132);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "eximite.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotEximite";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreEximite";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustEximite";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockEximite";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.eximite.pickaxe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.eximite.shovel", fluidName, 1, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.eximite.axe", fluidName, 3, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.eximite.hoe", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.eximite.sword", fluidName, 2, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.eximite.helmet", fluidName, 5, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.eximite.chestplate", fluidName, 8, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.eximite.leggings", fluidName, 7, MeltingTemp);
            RecipeHandler._addMeltingItemRecipe("item.metallurgy.eximite.boots", fluidName, 4, MeltingTemp);
            RecipeHandler._addToolsCasting(133, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Eximite", 133);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "meutoite.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotMeutoite";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            oreName = "oreMeutoite";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            dustName = "dustMeutoite";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            blockName = "blockMeutoite";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
    }

    private static void _addM3EnderAlloyMixing() {
        if (FluidRegistry.isFluidRegistered((String)"desichalkos.molten") && FluidRegistry.isFluidRegistered((String)"eximite.molten") && FluidRegistry.isFluidRegistered((String)"meutoite.molten") && RefAlloy.DESICHALKOS_RATIO.length == 3) {
            int desichalkosAmount = 144 * RefAlloy.DESICHALKOS_RATIO[2];
            int eximiteAmount = 144 * RefAlloy.DESICHALKOS_RATIO[0];
            int meutoiteAmount = 144 * RefAlloy.DESICHALKOS_RATIO[1];
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"desichalkos.molten"), desichalkosAmount), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"eximite.molten"), eximiteAmount), new FluidStack(FluidRegistry.getFluid((String)"meutoite.molten"), meutoiteAmount)});
        }
    }

    private static void _addNaturaRecipes() {
        Item planks = GameRegistry.findItem((String)"Natura", (String)"planks");
        Item stick = GameRegistry.findItem((String)"Natura", (String)"natura.stick");
        if (planks != null && stick != null) {
            RecipeHandler._addPartBuilding(134);
            ItemStack bloodwoodPlank = new ItemStack(planks, 1, 4);
            ItemStack bloodwoodStick = new ItemStack(stick, 1, 4);
            RecipeHandler._unregisterMaterial(bloodwoodPlank);
            RecipeHandler._unregisterMaterial(bloodwoodStick);
            RecipeHandler._registerWithStations(bloodwoodPlank, "Bloodwood", 134, bloodwoodStick);
            RecipeHandler._addPartBuilding(135);
            ItemStack darkwoodPlank = new ItemStack(planks, 1, 11);
            ItemStack darkwoodStick = new ItemStack(stick, 1, 11);
            RecipeHandler._unregisterMaterial(darkwoodPlank);
            RecipeHandler._unregisterMaterial(darkwoodStick);
            RecipeHandler._registerWithStations(darkwoodPlank, "Darkwood", 135, darkwoodStick);
            RecipeHandler._addPartBuilding(136);
            ItemStack fusewoodPlank = new ItemStack(planks, 1, 12);
            ItemStack fusewoodStick = new ItemStack(stick, 1, 12);
            RecipeHandler._unregisterMaterial(fusewoodPlank);
            RecipeHandler._unregisterMaterial(fusewoodStick);
            RecipeHandler._registerWithStations(fusewoodPlank, "Fusewood", 136, fusewoodStick);
            RecipeHandler._addPartBuilding(137);
            ItemStack ghostwoodPlank = new ItemStack(planks, 1, 2);
            ItemStack ghostwoodStick = new ItemStack(stick, 1, 2);
            RecipeHandler._unregisterMaterial(ghostwoodPlank);
            RecipeHandler._unregisterMaterial(ghostwoodStick);
            RecipeHandler._registerWithStations(ghostwoodPlank, "Ghostwood", 137, ghostwoodStick);
            RecipeHandler._addPartBuilding(138);
            RecipeHandler._registerWithStations(new ItemStack(Items.field_151128_bU, 1), "Nether Quartz", 138, new ItemStack((Item)_CHUNK, 1, 138));
        }
    }

    private static void _addMekanismRecipes() {
        String ingotName;
        int MeltingTemp;
        String fluidName = null;
        fluidName = "refined.glowstone.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotRefinedGlowstone";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            String blockName = "blockRefinedGlowstone";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addToolsCasting(139, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Refined Glowstone", 139);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
        fluidName = "osmium.molten";
        if (FluidRegistry.isFluidRegistered((String)fluidName)) {
            MeltingTemp = 550;
            ingotName = "ingotOsmium";
            RecipeHandler._addMeltingOreRecipe(ingotName, fluidName, 1, MeltingTemp);
            RecipeHandler._addOreIngotCastRecipe(ingotName, fluidName, 1, 100);
            String oreName = "oreOsmium";
            RecipeHandler._addMeltingOreRecipe(oreName, fluidName, ingotsPreOre, MeltingTemp);
            String dustName = "dustOsmium";
            RecipeHandler._addMeltingOreRecipe(dustName, fluidName, 1, MeltingTemp);
            String blockName = "blockOsmium";
            RecipeHandler._addMeltingOreRecipe(blockName, fluidName, 9, MeltingTemp);
            RecipeHandler._addOreBlockCastRecipe(blockName, fluidName, 9, 100);
            RecipeHandler._addToolsCasting(140, fluidName, 80);
            RecipeHandler._registerWithStations(ingotName, "Osmium", 140);
        } else {
            Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
        }
    }

    private static void _addFunStuffRecipes() {
        Block funStuffBlock = GameRegistry.findBlock((String)"ExtraTiC", (String)"blockFunStuff");
        Item funStuffIngot = GameRegistry.findItem((String)"ExtraTiC", (String)"funStuffIngot");
        if (funStuffBlock != null && funStuffIngot != null) {
            int MeltingTemp;
            String fluidName = "";
            fluidName = "fairy.molten";
            if (FluidRegistry.isFluidRegistered((String)fluidName)) {
                MeltingTemp = 550;
                Smeltery.addMelting((ItemStack)new ItemStack(funStuffIngot, 1, 0), (Block)funStuffBlock, (int)0, (int)MeltingTemp, (FluidStack)FluidRegistry.getFluidStack((String)fluidName, (int)144));
                tableCasting.addCastingRecipe(new ItemStack(funStuffIngot, 1, 0), FluidRegistry.getFluidStack((String)fluidName, (int)144), ingotCast, 100);
                Smeltery.addMelting((Block)funStuffBlock, (int)0, (int)MeltingTemp, (FluidStack)FluidRegistry.getFluidStack((String)fluidName, (int)1296));
                basinCasting.addCastingRecipe(new ItemStack(funStuffBlock, 1, 0), FluidRegistry.getFluidStack((String)fluidName, (int)1296), 100);
                RecipeHandler._addToolsCasting(142, fluidName, 80);
                RecipeHandler._registerWithStations(new ItemStack(funStuffIngot, 1, 0), "Fairy", 142, new ItemStack((Item)_CHUNK, 1, 142));
            } else {
                Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
            }
            fluidName = "pokefennium.molten";
            if (FluidRegistry.isFluidRegistered((String)fluidName)) {
                MeltingTemp = 550;
                Smeltery.addMelting((ItemStack)new ItemStack(funStuffIngot, 1, 1), (Block)funStuffBlock, (int)1, (int)MeltingTemp, (FluidStack)FluidRegistry.getFluidStack((String)fluidName, (int)144));
                tableCasting.addCastingRecipe(new ItemStack(funStuffIngot, 1, 1), FluidRegistry.getFluidStack((String)fluidName, (int)144), ingotCast, 100);
                Smeltery.addMelting((Block)funStuffBlock, (int)1, (int)MeltingTemp, (FluidStack)FluidRegistry.getFluidStack((String)fluidName, (int)1296));
                basinCasting.addCastingRecipe(new ItemStack(funStuffBlock, 1, 1), FluidRegistry.getFluidStack((String)fluidName, (int)1296), 100);
                RecipeHandler._addToolsCasting(141, fluidName, 80);
                RecipeHandler._registerWithStations(new ItemStack(funStuffIngot, 1, 1), "Pokefennium", 141, new ItemStack((Item)_CHUNK, 1, 141));
            } else {
                Debug.warnning("Fluid " + fluidName + " is not registered, skipping");
            }
        }
    }

    private static void _addFunStuffAlloyMixng() {
        if (FluidRegistry.isFluidRegistered((String)"pokefennium.molten") && FluidRegistry.isFluidRegistered((String)"cobalt.molten") && FluidRegistry.isFluidRegistered((String)"iron.molten") && FluidRegistry.isFluidRegistered((String)"blood")) {
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"pokefennium.molten"), 16), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"cobalt.molten"), 8), new FluidStack(FluidRegistry.getFluid((String)"iron.molten"), 8), new FluidStack(FluidRegistry.getFluid((String)"blood"), 16)});
        }
        if (FluidRegistry.isFluidRegistered((String)"fairy.molten") && FluidRegistry.isFluidRegistered((String)"cobalt.molten") && FluidRegistry.isFluidRegistered((String)"iron.molten") && FluidRegistry.isFluidRegistered((String)"blood")) {
            Smeltery.addAlloyMixing((FluidStack)new FluidStack(FluidRegistry.getFluid((String)"fairy.molten"), 16), (FluidStack[])new FluidStack[]{new FluidStack(FluidRegistry.getFluid((String)"ardite.molten"), 8), new FluidStack(FluidRegistry.getFluid((String)"obsidian.molten"), 16), new FluidStack(FluidRegistry.getFluid((String)"blood"), 8)});
        }
    }

    private static void _AddFunStuffCraftingRecipes() {
        Block funStuffBlock = GameRegistry.findBlock((String)"ExtraTiC", (String)"blockFunStuff");
        Item funStuffIngot = GameRegistry.findItem((String)"ExtraTiC", (String)"funStuffIngot");
        ItemStack fairyBlock = new ItemStack(funStuffBlock, 1, 0);
        ItemStack fairyIngot = new ItemStack(funStuffIngot, 1, 0);
        GameRegistry.addRecipe((ItemStack)fairyBlock.func_77946_l(), (Object[])new Object[]{"iii", "iii", "iii", Character.valueOf('i'), fairyIngot});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(funStuffIngot, 9, 0), (Object[])new Object[]{fairyBlock.func_77946_l()});
        ItemStack PokefenniumBlock = new ItemStack(funStuffBlock, 1, 1);
        ItemStack PokefenniumIngot = new ItemStack(funStuffIngot, 1, 1);
        GameRegistry.addRecipe((ItemStack)PokefenniumBlock.func_77946_l(), (Object[])new Object[]{"iii", "iii", "iii", Character.valueOf('i'), PokefenniumIngot});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(funStuffIngot, 9, 1), (Object[])new Object[]{PokefenniumBlock.func_77946_l()});
    }

    private static void _addAERecipes() {
        ArrayList quartz = OreDictionary.getOres((String)"crystalCertusQuartz");
        if (!quartz.isEmpty()) {
            ItemStack certusQuartz = ((ItemStack)quartz.get(0)).func_77946_l();
            RecipeHandler._addPartBuilding(143);
            RecipeHandler._registerWithStations(certusQuartz, "Certus Quartz", 143, new ItemStack((Item)_CHUNK, 1, 143));
        } else {
            Debug.warnning("crystalCertusQuartz was not found, skipping recipe");
        }
    }

    private static void _addBOPRecipes() {
        Item amethyst = GameRegistry.findItem((String)"BiomesOPlenty", (String)"gems");
        if (amethyst != null) {
            RecipeHandler._addPartBuilding(144);
            RecipeHandler._registerWithStations(new ItemStack(amethyst, 1, 0), "Amethyst", 144, new ItemStack((Item)_CHUNK, 1, 144));
        } else {
            Debug.warnning("BiomesOPlenty:gems was not found, skipping recipe");
        }
    }
}

