/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.util;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tterrag.core.TTCore;
import tterrag.core.common.Handlers;

@Handlers.Handler(value={Handlers.Handler.HandlerType.FML}, getInstFrom=Handlers.Handler.Inst.METHOD)
public class Scheduler {
    private final List<Task> tasks = new ArrayList<Task>();

    public void schedule(int delay, Runnable task) {
        this.schedule(delay, task, Side.SERVER);
    }

    public void schedule(int delay, Runnable task, Side side) {
        this.tasks.add(new Task(delay, task, side));
    }

    public static Scheduler instance() {
        return TTCore.proxy.getScheduler();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.runTasks(Side.SERVER);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.runTasks(Side.CLIENT);
        }
    }

    private void runTasks(Side side) {
        Iterator<Task> iter = this.tasks.iterator();
        while (iter.hasNext()) {
            Task next = iter.next();
            if (next.side != side || !next.run()) continue;
            iter.remove();
        }
    }

    private static final class Task {
        private int delay;
        private Runnable toRun;
        private Side side;

        private boolean run() {
            if (this.delay <= 0) {
                this.toRun.run();
                return true;
            }
            --this.delay;
            return false;
        }

        @ConstructorProperties(value={"delay", "toRun", "side"})
        public Task(int delay, Runnable toRun, Side side) {
            this.delay = delay;
            this.toRun = toRun;
            this.side = side;
        }
    }
}

