/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.imc;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.List;
import tterrag.core.common.imc.handlers.IMCRightClickCrop;

public class IMCRegistry {
    public static final IMCRegistry INSTANCE = new IMCRegistry();
    private List<IIMC> handlers = Lists.newArrayList();

    private IMCRegistry() {
    }

    public void addIMCHandler(IIMC handler) {
        this.handlers.add(handler);
    }

    public void handleEvent(FMLInterModComms.IMCEvent event) {
        for (IIMC handler : this.handlers) {
            for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
                if (!msg.key.equals(handler.getKey())) continue;
                handler.act(msg);
            }
        }
    }

    public void init() {
        this.addIMCHandler(new IMCRightClickCrop());
    }

    public static abstract class IMCBase
    implements IIMC {
        private String key;

        public IMCBase(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    public static interface IIMC {
        public String getKey();

        public void act(FMLInterModComms.IMCMessage var1);
    }
}

