/*
 * Decompiled with CFR 0.152.
 */
package tterrag.core.common.config;

import java.io.File;
import tterrag.core.TTCore;
import tterrag.core.common.Handlers;
import tterrag.core.common.config.AbstractConfigHandler;
import tterrag.core.common.config.ConfigProcessor;
import tterrag.core.common.config.ITweakConfigHandler;
import tterrag.core.common.config.JsonConfigReader;
import tterrag.core.common.config.annot.Comment;
import tterrag.core.common.config.annot.Config;
import tterrag.core.common.config.annot.NoSync;
import tterrag.core.common.config.annot.Range;
import tterrag.core.common.config.annot.RestartReq;
import tterrag.core.common.handlers.RightClickCropHandler;
import tterrag.core.common.transform.TTCorePlugin;
import tterrag.core.common.tweaks.Tweak;
import tterrag.core.common.tweaks.Tweaks;

@Handlers.Handler(value={Handlers.Handler.HandlerType.FML}, getInstFrom=Handlers.Handler.Inst.METHOD)
public class ConfigHandler
extends AbstractConfigHandler
implements ITweakConfigHandler,
ConfigProcessor.IReloadCallback {
    private static final String sectionGeneral = "general";
    private static final String sectionEnchants = "enchants";
    @Config
    @Comment(value="Show oredictionary names of every item in its tooltip.")
    @NoSync
    public static boolean showOredictTooltips = false;
    @Config
    @Comment(value="Show item registry names and other things in debug mode (f3+h)")
    @NoSync
    public static boolean extraDebugStuff = true;
    @Config
    @Comment(value="Removes all void fog.\n0 = off\n1 = DEFAULT worldtype only\n2 = all world types")
    @NoSync
    @Range(min=0.0, max=2.0)
    public static int disableVoidFog = 1;
    @Config
    @Comment(value="The max amount of XP levels an anvil recipe can use.")
    public static int anvilMaxLevel = 40;
    @Config
    @Comment(value="The way the game should have been made (Yes this is the fireworks thing).")
    public static boolean betterAchievements = true;
    @Config
    @Comment(value="Disabling this option will prevent any crops added to the config json from being right clickable.")
    public static boolean allowCropRC = true;
    @Config
    @Comment(value="0 - Do nothing\n1 - Remove stacktraces, leave 1-line missing texture errors\n2 - Remove all missing texture errors completely. This option is not supported outside dev environments.")
    @NoSync
    @Range(min=0.0, max=2.0)
    public static int textureErrorRemover = 0;
    @Config
    @Comment(value="Controls the default sorting on the mod list GUI.\n\n0 - Default sort (load order)\n1 - A to Z sort\n2 - Z to A sort")
    @NoSync
    @Range(min=0.0, max=2.0)
    public static int defaultModSort = 1;
    @Config(value="enchants")
    @Comment(value="Enchant ID for the XP boost enchant.")
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    @Range(min=0.0, max=255.0)
    public static int enchantIDXPBoost = 43;
    @Config(value="enchants")
    @Comment(value="Allow the XP Boost enchant to be registered.")
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    public static boolean allowXPBoost = true;
    @Config(value="enchants")
    @Comment(value="Enchant ID for the Auto Smelt enchant.")
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    @Range(min=0.0, max=255.0)
    public static int enchantIDAutoSmelt = 44;
    @Config(value="enchants")
    @Comment(value="Allow the Auto Smelt enchant to be registered.")
    @RestartReq(value=AbstractConfigHandler.RestartReqs.REQUIRES_MC_RESTART)
    public static boolean allowAutoSmelt = true;
    @Config(value="enchants")
    @Comment(value="Allow the Auto Smelt enchant to work with Fortune.")
    public static boolean allowAutoSmeltWithFortune = true;
    private static ConfigHandler INSTANCE;
    public static File configFolder;
    public static File ttConfigFolder;
    public static File configFile;
    public static ConfigProcessor processor;

    public static ConfigHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigHandler();
        }
        return INSTANCE;
    }

    protected ConfigHandler() {
        super("ttCore");
    }

    @Override
    public void init() {
        this.addSection(sectionGeneral);
        this.addSection(sectionEnchants);
        this.addSection("tweaks");
        processor = new ConfigProcessor(this.getClass(), this, this);
        processor.process(true);
    }

    @Override
    protected void reloadIngameConfigs() {
    }

    @Override
    protected void reloadNonIngameConfigs() {
        Tweaks.loadNonIngameTweaks();
    }

    @Override
    public void callback(ConfigProcessor inst) {
        if (!TTCorePlugin.runtimeDeobfEnabled) {
            textureErrorRemover = Math.min(textureErrorRemover, 1);
        }
        Tweaks.loadIngameTweaks();
    }

    @Override
    public boolean addBooleanFor(Tweak tweak) {
        this.activateSection("tweaks");
        return this.getValue(tweak.getName(), tweak.getComment(), true);
    }

    public void loadRightClickCrops() {
        JsonConfigReader<RightClickCropHandler.PlantInfo> reader = new JsonConfigReader<RightClickCropHandler.PlantInfo>(new JsonConfigReader.ModToken(TTCore.class, "ttCore".toLowerCase() + "/config"), ttConfigFolder.getAbsolutePath() + "/cropConfig.json", RightClickCropHandler.PlantInfo.class);
        for (RightClickCropHandler.PlantInfo i : reader) {
            i.init();
            RightClickCropHandler.INSTANCE.addCrop(i);
        }
    }
}

