/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import tuhljin.automagy.gui.FilterContainer;
import tuhljin.automagy.gui.GUIGreedyChestConfig;
import tuhljin.automagy.gui.SlotRestrictedWithReporting;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.tiles.TileEntityGreedyChest;

public class ContainerGreedyChestConfig
extends FilterContainer {
    private TileEntityGreedyChest teGC;
    private GUIGreedyChestConfig attachedGUI = null;
    private static final int PERCENTAGE_ADJUSTMENT = 10000;
    private SlotRestrictedWithReporting filterSlot;
    private int oldModePilfer = -1;
    private float oldFractionWanted = -1.0f;
    private int oldAmountWanted = -1;
    private boolean[] oldDirections = new boolean[]{true, true, true, true, true, true};

    public ContainerGreedyChestConfig(InventoryPlayer inventoryPlayer, TileEntityGreedyChest te) {
        int i;
        this.teGC = te;
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 142));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, 9 + j + i * 9, 8 + j * 18, 84 + i * 18));
            }
        }
        this.filterSlot = new SlotRestrictedWithReporting(0, te.filterContainingInventory, 0, 98, 51);
        this.func_75146_a(this.filterSlot);
    }

    @SideOnly(value=Side.CLIENT)
    public void attachToGui(GUIGreedyChestConfig gui) {
        this.attachedGUI = gui;
        this.filterSlot.setParent(gui);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.teGC.func_70300_a(player);
    }

    public void func_75132_a(ICrafting player) {
        super.func_75132_a(player);
        for (int i = 0; i < 6; ++i) {
            player.func_71112_a((Container)this, i, this.teGC.directions[i] ? 1 : 0);
        }
        player.func_71112_a((Container)this, 6, this.teGC.modePilfer);
        player.func_71112_a((Container)this, 7, Math.round(this.teGC.fractionWanted * 10000.0f));
        player.func_71112_a((Container)this, 8, this.teGC.amountWanted);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        switch (id) {
            case 6: {
                this.teGC.modePilfer = data;
                break;
            }
            case 7: {
                this.teGC.fractionWanted = (float)data / 10000.0f;
                if (this.attachedGUI != null) {
                    String s = Integer.toString(data);
                    s = data < 10 ? "0.0" + s : new StringBuilder(s).insert(s.length() - 2, TjUtil.decimalSeparator).toString();
                    this.attachedGUI.updatePercentage(s);
                }
                return;
            }
            case 8: {
                this.teGC.amountWanted = data;
                break;
            }
            default: {
                if (id < 0 || id >= 6) break;
                boolean bl = this.teGC.directions[id] = data == 1;
            }
        }
        if (this.attachedGUI != null) {
            this.attachedGUI.updateButton(id, data);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (Object player : this.field_75149_d) {
            if (this.teGC.modePilfer != this.oldModePilfer) {
                ((ICrafting)player).func_71112_a((Container)this, 6, this.teGC.modePilfer);
            }
            if (!TjUtil.areFloatsAlmostEqual_lowprec(this.teGC.fractionWanted, this.oldFractionWanted)) {
                ((ICrafting)player).func_71112_a((Container)this, 7, Math.round(this.teGC.fractionWanted * 10000.0f));
            }
            if (this.teGC.amountWanted != this.oldAmountWanted) {
                ((ICrafting)player).func_71112_a((Container)this, 8, this.teGC.amountWanted);
            }
            for (int side = 0; side < 6; ++side) {
                if (this.teGC.directions[side] == this.oldDirections[side]) continue;
                ((ICrafting)player).func_71112_a((Container)this, side, this.teGC.directions[side] ? 1 : 0);
            }
        }
        this.oldModePilfer = this.teGC.modePilfer;
        this.oldFractionWanted = this.teGC.fractionWanted;
        this.oldAmountWanted = this.teGC.amountWanted;
        this.oldDirections = Arrays.copyOf(this.teGC.directions, this.teGC.directions.length);
    }

    public TileEntityGreedyChest getTileEntity() {
        return this.teGC;
    }
}

