/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tuhljin.automagy.blocks.BlockRedcrystalLarge;
import tuhljin.automagy.lib.RedstoneCalc;
import tuhljin.automagy.lib.struct.BlockWithPos;
import tuhljin.automagy.tiles.TileEntityRedcrystal;

public class BlockRedcrystalRes
extends BlockRedcrystalLarge {
    public static final int MAX_MINIMUM = 15;
    public static final int MIN_MINIMUM = 2;
    private static final int MAX_DISTANCE = 15;

    public BlockRedcrystalRes(String name) {
        super(name);
    }

    @Override
    protected RedstoneCalc.PowerResult calculateRedstonePowerAt(World world, int x, int y, int z, int orientation) {
        TileEntityRedcrystal te;
        int receivingStrength = 0;
        try {
            te = (TileEntityRedcrystal)world.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            return null;
        }
        if (te != null && (receivingStrength = Math.max(te.extraData - 1, 0)) >= 50) {
            return new RedstoneCalc.PowerResult(receivingStrength, ForgeDirection.UNKNOWN);
        }
        RedstoneCalc.PowerResult result = super.calculateRedstonePowerAt(world, x, y, z, orientation);
        if (result != null && result.strength > 0) {
            if (receivingStrength > result.strength) {
                return new RedstoneCalc.PowerResult(receivingStrength, ForgeDirection.UNKNOWN);
            }
            return result;
        }
        if (receivingStrength > 0) {
            return new RedstoneCalc.PowerResult(receivingStrength, ForgeDirection.UNKNOWN);
        }
        return null;
    }

    public BlockWithPos findSignalConnection(World world, int x, int y, int z, boolean reverse) {
        int orientation = this.getOrientation((IBlockAccess)world, x, y, z);
        ForgeDirection dir = ForgeDirection.getOrientation((int)orientation);
        if (dir != ForgeDirection.UNKNOWN) {
            int opp;
            if (reverse) {
                dir = dir.getOpposite();
                opp = dir.ordinal();
            } else {
                opp = dir.getOpposite().ordinal();
            }
            for (int distance = 1; distance <= 15; ++distance) {
                int x2 = x + dir.offsetX * distance;
                int y2 = y + dir.offsetY * distance;
                int z2 = z + dir.offsetZ * distance;
                Block target = world.func_147439_a(x2, y2, z2);
                if (!(target instanceof BlockRedcrystalRes)) continue;
                int o = ((BlockRedcrystalRes)target).getOrientation((IBlockAccess)world, x2, y2, z2);
                if (reverse) {
                    if (orientation == o) {
                        return new BlockWithPos(target, (IBlockAccess)world, x2, y2, z2);
                    }
                    if (opp == o) {
                        return null;
                    }
                } else {
                    if (orientation == o) {
                        return null;
                    }
                    if (opp == o) {
                        return new BlockWithPos(target, (IBlockAccess)world, x2, y2, z2);
                    }
                }
                if (opp == o) {
                    if (!reverse) continue;
                    return null;
                }
                if (orientation != o || !reverse) continue;
                return new BlockWithPos(target, (IBlockAccess)world, x2, y2, z2);
            }
        }
        return null;
    }

    public void receiveWirelessSignal(World world, int x, int y, int z, int strength) {
        TileEntityRedcrystal te;
        try {
            te = (TileEntityRedcrystal)world.func_147438_o(x, y, z);
        }
        catch (Exception ex) {
            return;
        }
        if (strength == -1) {
            strength = 0;
            BlockWithPos target = this.findSignalConnection(world, x, y, z, false);
            if (target != null) {
                BlockRedcrystalRes blockR = (BlockRedcrystalRes)target.block;
                blockR.receiveWirelessSignal(world, target.x, target.y, target.z, blockR.getRedstoneSignalStrength((IBlockAccess)world, x, y, z, true));
                strength = blockR.getRedstoneSignalStrength((IBlockAccess)world, target.x, target.y, target.z, true);
            }
        }
        if (te.extraData != strength) {
            te.extraData = strength;
            te.func_70296_d();
            this.updateAndPropagateChanges(world, x, y, z, true, false, false, false);
        }
    }

    @Override
    public void scheduleAreaUpdateNotification(World world, int x, int y, int z, boolean immediate) {
        BlockWithPos target;
        super.scheduleAreaUpdateNotification(world, x, y, z, immediate);
        if (!world.field_72995_K && (target = this.findSignalConnection(world, x, y, z, false)) != null) {
            BlockRedcrystalRes blockR = (BlockRedcrystalRes)target.block;
            blockR.receiveWirelessSignal(world, target.x, target.y, target.z, blockR.getRedstoneSignalStrength((IBlockAccess)world, x, y, z, true));
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int p_149749_6_) {
        BlockWithPos target = null;
        if (!world.field_72995_K) {
            target = this.findSignalConnection(world, x, y, z, false);
        }
        super.func_149749_a(world, x, y, z, block, p_149749_6_);
        if (target != null) {
            ((BlockRedcrystalRes)target.block).receiveWirelessSignal(world, target.x, target.y, target.z, -1);
        }
    }

    @Override
    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            BlockRedcrystalRes blockR;
            TileEntityRedcrystal te;
            try {
                te = (TileEntityRedcrystal)world.func_147438_o(x, y, z);
            }
            catch (Exception ex) {
                return;
            }
            BlockWithPos target = this.findSignalConnection(world, x, y, z, false);
            if (target != null) {
                blockR = (BlockRedcrystalRes)target.block;
                te.extraData = blockR.getRedstoneSignalStrength((IBlockAccess)world, target.x, target.y, target.z, true);
                te.func_70296_d();
            }
            if ((target = this.findSignalConnection(world, x, y, z, true)) != null) {
                blockR = (BlockRedcrystalRes)target.block;
                blockR.receiveWirelessSignal(world, target.x, target.y, target.z, 0);
            }
        }
        super.func_149726_b(world, x, y, z);
    }
}

