/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.blocks.BlockCosmeticSolid;
import thaumcraft.common.blocks.BlockCustomOreItem;
import tuhljin.automagy.blocks.ModBlockSpecialRender;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.lib.References;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.renderers.IBlockGlowOverlayWithRecolor;
import tuhljin.automagy.tiles.TileEntityMobLure;

public class BlockMobLure
extends ModBlockSpecialRender
implements IBlockGlowOverlayWithRecolor {
    private IIcon iconOverlay;
    public static int[] colors = BlockCustomOreItem.colors;
    public int colorTarget = 1;
    public int color = colors[0];
    private static final int FadeSteps = 750;
    int nextStep = 0;
    int prevColor = colors[0];
    public long nextNoise = 0L;

    public BlockMobLure(String name) {
        super(name, ModBlocks.materialNiceStone);
        this.setHarvestLevel("pickaxe", 2);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityMobLure();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        super.func_149651_a(ir);
        this.iconOverlay = ir.func_94245_a(this.field_149768_d + "Overlay");
    }

    public MapColor func_149728_f(int p_149728_1_) {
        return MapColor.field_151654_J;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntityMobLure teML;
        TileEntity te;
        if (!world.field_72995_K && block instanceof BlockCosmeticSolid && (te = world.func_147438_o(x, y, z)) instanceof TileEntityMobLure && !(teML = (TileEntityMobLure)te).calcVerticalLimits()) {
            teML.tryDisable();
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (ThaumcraftExtension.playerHasWandEquipped(player)) {
            if (!world.field_72995_K) {
                TileEntityMobLure te = null;
                try {
                    te = (TileEntityMobLure)world.func_147438_o(x, y, z);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (te != null) {
                    if (te.isEnabled()) {
                        te.tryDisable();
                    } else {
                        te.tryEnable();
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public IIcon getOverlayTexture(IBlockAccess world, int x, int y, int z, int side) {
        if (world.func_72805_g(x, y, z) == 0) {
            return null;
        }
        return this.iconOverlay;
    }

    @Override
    public IIcon getOverlayInvTexture(int side, int meta) {
        return this.iconOverlay;
    }

    @Override
    public Integer getOverlayColor(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            return null;
        }
        return this.getOverlayInvColor(meta);
    }

    @Override
    public Integer getOverlayInvColor(int meta) {
        this.color = this.fade(colors[this.colorTarget]);
        return this.color;
    }

    @Override
    public int func_149645_b() {
        return References.renderBlockMobLure;
    }

    private Color fade(Color oldColour, Color colour, int currentStep) {
        int dRed = colour.getRed() - oldColour.getRed();
        int dGreen = colour.getGreen() - oldColour.getGreen();
        int dBlue = colour.getBlue() - oldColour.getBlue();
        if (dRed != 0 || dGreen != 0 || dBlue != 0) {
            return new Color(oldColour.getRed() + dRed * currentStep / 750, oldColour.getGreen() + dGreen * currentStep / 750, oldColour.getBlue() + dBlue * currentStep / 750);
        }
        return colour;
    }

    private int fade(int colour) {
        if (this.nextStep > 750) {
            this.prevColor = colour;
            if (this.nextStep > 950) {
                this.nextStep = 0;
                ++this.colorTarget;
                if (this.colorTarget >= colors.length) {
                    this.colorTarget = 0;
                }
            } else {
                ++this.nextStep;
            }
            return colour;
        }
        Color c = this.fade(new Color(this.prevColor), new Color(colour), this.nextStep);
        ++this.nextStep;
        return c.getRGB();
    }

    public boolean canLureAffectEntity(IBlockAccess world, int x, int y, int z, EntityLivingBase entity, double rangeSquared) {
        TileEntityMobLure teML;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityMobLure && (teML = (TileEntityMobLure)te).isEnabled()) {
            return this.canActiveLureAffectEntity(teML, entity, rangeSquared);
        }
        return false;
    }

    public boolean canActiveLureAffectEntity(TileEntityMobLure te, EntityLivingBase entity, double rangeSquared) {
        double z2;
        double z1;
        double x2;
        double x1;
        double distanceXZ;
        return entity.field_70163_u >= (double)te.yBottom && entity.field_70163_u <= (double)te.yTop && (distanceXZ = ((x1 = (double)te.field_145851_c + 0.5) - (x2 = entity.field_70165_t)) * (x1 - x2) + ((z1 = (double)te.field_145849_e + 0.5) - (z2 = entity.field_70161_v)) * (z1 - z2)) <= rangeSquared;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        long currentTime;
        if (world.func_72805_g(x, y, z) != 0 && (currentTime = System.currentTimeMillis()) >= this.nextNoise) {
            this.nextNoise = currentTime + 15000L + (long)rand.nextInt(10000);
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:brain", 0.4f, world.field_73012_v.nextFloat() * 0.25f + 1.4f, false);
        }
    }
}

