/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mcjty.rftools.RFTools;
import mcjty.rftools.network.AbstractServerCommand;
import mcjty.rftools.network.Argument;
import mcjty.rftools.network.CommandHandler;
import mcjty.rftools.network.NetworkTools;
import mcjty.rftools.network.PacketIntegerFromServer;
import net.minecraft.tileentity.TileEntity;

public class PacketRequestIntegerFromServer
extends AbstractServerCommand
implements IMessageHandler<PacketRequestIntegerFromServer, PacketIntegerFromServer> {
    private String clientCommand;

    public PacketRequestIntegerFromServer() {
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.clientCommand = NetworkTools.readString(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NetworkTools.writeString(buf, this.clientCommand);
    }

    public PacketRequestIntegerFromServer(int x, int y, int z, String command, String clientCommand, Argument ... arguments) {
        super(x, y, z, command, arguments);
        this.clientCommand = clientCommand;
    }

    public PacketIntegerFromServer onMessage(PacketRequestIntegerFromServer message, MessageContext ctx) {
        TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(message.x, message.y, message.z);
        if (!(te instanceof CommandHandler)) {
            RFTools.log("createStartScanPacket: TileEntity is not a CommandHandler!");
            return null;
        }
        CommandHandler commandHandler = (CommandHandler)te;
        Integer result = commandHandler.executeWithResultInteger(message.command, message.args);
        if (result == null) {
            RFTools.log("Command " + message.command + " was not handled!");
            return null;
        }
        return new PacketIntegerFromServer(message.x, message.y, message.z, message.clientCommand, result);
    }
}

