/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.description.DimensionDescriptor;
import mcjty.rftools.items.teleportprobe.PacketAllReceiversReady;
import mcjty.varia.Coordinate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PacketGetAllReceivers
implements IMessage,
IMessageHandler<PacketGetAllReceivers, PacketAllReceiversReady> {
    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
    }

    public PacketAllReceiversReady onMessage(PacketGetAllReceivers message, MessageContext ctx) {
        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(player.field_70170_p);
        ArrayList<TeleportDestinationClientInfo> destinationList = new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(null));
        this.addDimensions(destinationList);
        this.addRfToolsDimensions(player.field_70170_p, destinationList);
        return new PacketAllReceiversReady(destinationList);
    }

    private void addDimensions(List<TeleportDestinationClientInfo> destinationList) {
        WorldServer[] worlds;
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            int id = world.field_73011_w.field_76574_g;
            TeleportDestination destination = new TeleportDestination(new Coordinate(0, 70, 0), id);
            destination.setName("Dimension: " + id);
            TeleportDestinationClientInfo teleportDestinationClientInfo = new TeleportDestinationClientInfo(destination);
            String dimName = world.field_73011_w.func_80007_l();
            teleportDestinationClientInfo.setDimensionName(dimName);
            destinationList.add(teleportDestinationClientInfo);
        }
    }

    private void addRfToolsDimensions(World world, List<TeleportDestinationClientInfo> destinationList) {
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        for (Map.Entry<Integer, DimensionDescriptor> me : dimensionManager.getDimensions().entrySet()) {
            int id = me.getKey();
            TeleportDestination destination = new TeleportDestination(new Coordinate(0, 70, 0), id);
            destination.setName("RfTools Dim: " + id);
            TeleportDestinationClientInfo teleportDestinationClientInfo = new TeleportDestinationClientInfo(destination);
            destinationList.add(teleportDestinationClientInfo);
        }
    }
}

