/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimlets;

import mcjty.rftools.items.dimlets.DimletType;

public class DimletKey {
    private final DimletType type;
    private final String name;

    public DimletKey(DimletType type, String name) {
        this.type = type;
        this.name = name;
    }

    public DimletType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimletKey dimletKey = (DimletKey)o;
        if (this.type != dimletKey.type) {
            return false;
        }
        return this.name.equals(dimletKey.name);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return this.type.dimletType.getOpcode() + this.name;
    }

    public static DimletKey parseKey(String skey) {
        String opcode = skey.substring(0, 1);
        String name = skey.substring(1);
        return new DimletKey(DimletType.getTypeByOpcode(opcode), name);
    }
}

