/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.dimensionmonitor;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;

public class PhasedFieldGeneratorItem
extends Item
implements IEnergyContainerItem {
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    private IIcon[] powerLevel = new IIcon[9];

    public PhasedFieldGeneratorItem() {
        this.func_77625_d(1);
        this.capacity = DimletConfiguration.PHASEDFIELD_MAXENERGY;
        this.maxReceive = DimletConfiguration.PHASEDFIELD_RECEIVEPERTICK;
        this.maxExtract = DimletConfiguration.PHASEDFIELD_CONSUMEPERTICK * 10;
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i <= 8; ++i) {
            this.powerLevel[i] = iconRegister.func_94245_a("rftools:phasedFieldGeneratorItemL" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        int level;
        NBTTagCompound tagCompound = stack.func_77978_p();
        int energy = 0;
        if (tagCompound != null) {
            energy = tagCompound.func_74762_e("Energy");
        }
        if ((level = 9 * energy / DimletConfiguration.PHASEDFIELD_MAXENERGY) < 0) {
            level = 0;
        } else if (level > 8) {
            level = 8;
        }
        return this.powerLevel[8 - level];
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            list.add(EnumChatFormatting.BLUE + "Energy: " + tagCompound.func_74762_e("Energy") + " RF");
        }
        list.add("This RF/charged module gives a temporary");
        list.add("protection while visiting an unpowered dimension.");
        list.add("Use at your own risk and don't let power run out!");
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacity;
    }
}

