/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world.terrain;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import mcjty.rftools.RFTools;
import mcjty.rftools.dimension.world.GenericChunkProvider;
import mcjty.rftools.dimension.world.terrain.BaseTerrainGenerator;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.dimension.world.types.TerrainType;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class NormalTerrainGenerator
implements BaseTerrainGenerator {
    private World world;
    protected GenericChunkProvider provider;
    private final double[] noiseField;
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] noiseData4;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorPerlin noiseGen4;
    private NoiseGeneratorOctaves noiseGen6;
    private final float[] parabolicField;
    private double[] stoneNoise = new double[256];

    public NormalTerrainGenerator() {
        this.noiseField = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    @Override
    public void setup(World world, GenericChunkProvider provider) {
        this.world = world;
        this.provider = provider;
        this.noiseGen1 = new NoiseGeneratorOctaves(provider.rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(provider.rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(provider.rand, 8);
        this.noiseGen4 = new NoiseGeneratorPerlin(provider.rand, 4);
        NoiseGeneratorOctaves noiseGen5 = new NoiseGeneratorOctaves(provider.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(provider.rand, 16);
        NoiseGeneratorOctaves mobSpawnerNoise = new NoiseGeneratorOctaves(provider.rand, 8);
        NoiseGenerator[] noiseGens = new NoiseGenerator[]{this.noiseGen1, this.noiseGen2, this.noiseGen3, this.noiseGen4, noiseGen5, this.noiseGen6, mobSpawnerNoise};
        noiseGens = TerrainGen.getModdedNoiseGenerators((World)world, (Random)provider.rand, (NoiseGenerator[])noiseGens);
        this.noiseGen1 = (NoiseGeneratorOctaves)noiseGens[0];
        this.noiseGen2 = (NoiseGeneratorOctaves)noiseGens[1];
        this.noiseGen3 = (NoiseGeneratorOctaves)noiseGens[2];
        this.noiseGen4 = (NoiseGeneratorPerlin)noiseGens[3];
        this.noiseGen6 = (NoiseGeneratorOctaves)noiseGens[5];
    }

    private void func_147423_a(int chunkX4, int chunkY4, int chunkZ4) {
        boolean donearlands;
        this.noiseData4 = this.noiseGen6.func_76305_a(this.noiseData4, chunkX4, chunkZ4, 5, 5, 200.0, 200.0, 0.5);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, chunkX4, chunkY4, chunkZ4, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, chunkX4, chunkY4, chunkZ4, 5, 33, 5, 684.412, 684.412, 684.412);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, chunkX4, chunkY4, chunkZ4, 5, 33, 5, 684.412, 684.412, 684.412);
        int l = 0;
        int i1 = 0;
        boolean domaze = false;
        boolean elevated = false;
        boolean bl = donearlands = this.provider.dimensionInformation.getTerrainType() == TerrainType.TERRAIN_NEARLANDS;
        if (donearlands) {
            elevated = true;
        }
        if (this.provider.dimensionInformation.hasFeatureType(FeatureType.FEATURE_MAZE)) {
            domaze = true;
            long s2 = ((long)(chunkX4 >> 2) + this.provider.seed + 13L) * 314L + (long)(chunkZ4 >> 2) * 17L;
            Random rand = new Random(s2);
            rand.nextFloat();
            boolean bl2 = elevated = (chunkX4 >> 2 & 1) == 0;
            if (rand.nextFloat() < 0.2f) {
                boolean bl3 = elevated = !elevated;
            }
        }
        if (donearlands) {
            int cx = chunkX4 >> 2;
            int cz = chunkZ4 >> 2;
            if (Math.abs(cx) < 5 && Math.abs(cz) < 5) {
                elevated = false;
            }
        }
        if (this.provider.biomesForGeneration == null) {
            RFTools.log("Dimension " + this.world.field_73011_w.field_76574_g + " has a problem! Ignoring for now.");
            return;
        }
        for (int j1 = 0; j1 < 5; ++j1) {
            for (int k1 = 0; k1 < 5; ++k1) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int b0 = 2;
                BiomeGenBase biomegenbase = this.provider.biomesForGeneration[j1 + 2 + (k1 + 2) * 10];
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        BiomeGenBase biomegenbase1 = this.provider.biomesForGeneration[j1 + l1 + 2 + (k1 + i2 + 2) * 10];
                        float f3 = biomegenbase1.field_76748_D;
                        float f4 = biomegenbase1.field_76749_E;
                        if (domaze || donearlands) {
                            if (f3 > 0.0f && elevated) {
                                if (this.provider.worldType == WorldType.field_151360_e) {
                                    f3 = 2.0f + f3 * 1.5f;
                                    f4 = 1.0f + f4 * 3.0f;
                                } else {
                                    f3 = 2.0f + f3;
                                    f4 = 0.5f + f4 * 1.5f;
                                }
                            } else if (this.provider.worldType == WorldType.field_151360_e && f3 > 0.0f) {
                                f3 = 0.5f + f3 * 1.5f;
                                f4 = 0.5f + f4 * 2.0f;
                            } else {
                                f4 *= 0.5f;
                            }
                        } else if (this.provider.worldType == WorldType.field_151360_e && f3 > 0.0f) {
                            f3 = 1.0f + f3 * 2.0f;
                            f4 = 1.0f + f4 * 4.0f;
                        }
                        float f5 = this.parabolicField[l1 + 2 + (i2 + 2) * 5] / (f3 + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            f5 /= 2.0f;
                        }
                        f += f4 * f5;
                        f1 += f3 * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = (f1 * 4.0f - 1.0f) / 8.0f;
                double d12 = this.noiseData4[i1] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++i1;
                double d13 = f1;
                double d14 = f;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.noiseData2[l] / 512.0;
                    double d8 = this.noiseData3[l] / 512.0;
                    double d9 = (this.noiseData1[l] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.noiseField[l] = d10;
                    ++l;
                }
            }
        }
    }

    @Override
    public void generate(int chunkX, int chunkZ, Block[] aBlock, byte[] meta) {
        Block baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain().getBlock();
        byte baseMeta = this.provider.dimensionInformation.getBaseBlockForTerrain().getMeta();
        Block baseLiquid = this.provider.dimensionInformation.getFluidForTerrain();
        this.func_147423_a(chunkX * 4, 0, chunkZ * 4);
        int waterLevel = 63;
        for (int x4 = 0; x4 < 4; ++x4) {
            int l = x4 * 5;
            int i1 = (x4 + 1) * 5;
            for (int z4 = 0; z4 < 4; ++z4) {
                int k1 = (l + z4) * 33;
                int l1 = (l + z4 + 1) * 33;
                int i2 = (i1 + z4) * 33;
                int j2 = (i1 + z4 + 1) * 33;
                for (int height32 = 0; height32 < 32; ++height32) {
                    double d0 = 0.125;
                    double d1 = this.noiseField[k1 + height32];
                    double d2 = this.noiseField[l1 + height32];
                    double d3 = this.noiseField[i2 + height32];
                    double d4 = this.noiseField[j2 + height32];
                    double d5 = (this.noiseField[k1 + height32 + 1] - d1) * d0;
                    double d6 = (this.noiseField[l1 + height32 + 1] - d2) * d0;
                    double d7 = (this.noiseField[i2 + height32 + 1] - d3) * d0;
                    double d8 = (this.noiseField[j2 + height32 + 1] - d4) * d0;
                    for (int h = 0; h < 8; ++h) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int x = 0; x < 4; ++x) {
                            int height = height32 * 8 + h;
                            int index = x + x4 * 4 << 12 | 0 + z4 * 4 << 8 | height;
                            int maxheight = 256;
                            index -= maxheight;
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int z = 0; z < 4; ++z) {
                                double d;
                                index += maxheight;
                                d15 += d16;
                                if (d > 0.0) {
                                    aBlock[index] = baseBlock;
                                    meta[index] = baseMeta;
                                    continue;
                                }
                                aBlock[index] = height < waterLevel ? baseLiquid : null;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    @Override
    public void replaceBlocksForBiome(int chunkX, int chunkZ, Block[] aBlock, byte[] abyte, BiomeGenBase[] biomeGenBases) {
        ChunkProviderEvent.ReplaceBiomeBlocks event = new ChunkProviderEvent.ReplaceBiomeBlocks((IChunkProvider)this.provider, chunkX, chunkZ, aBlock, abyte, biomeGenBases, this.world);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        double d0 = 0.03125;
        this.stoneNoise = this.noiseGen4.func_151599_a(this.stoneNoise, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                BiomeGenBase biomegenbase = biomeGenBases[l + k * 16];
                biomegenbase.func_150573_a(this.world, this.provider.rand, aBlock, abyte, chunkX * 16 + k, chunkZ * 16 + l, this.stoneNoise[l + k * 16]);
            }
        }
    }
}

