/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world.mapgen;

import java.util.Random;
import mcjty.rftools.dimension.world.GenericChunkProvider;
import mcjty.varia.BlockMeta;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class MapGenOrbs {
    private final GenericChunkProvider provider;
    private final boolean large;
    private final int r;

    public MapGenOrbs(GenericChunkProvider provider, boolean large) {
        this.provider = provider;
        this.large = large;
        this.r = large ? 2 : 1;
    }

    public void generate(World world, int chunkX, int chunkZ, Block[] ablock, byte[] ameta) {
        BlockMeta[] blocks = this.large ? this.provider.dimensionInformation.getHugeSphereBlocks() : this.provider.dimensionInformation.getSphereBlocks();
        for (int cx = -this.r; cx <= this.r; ++cx) {
            for (int cz = -this.r; cz <= this.r; ++cz) {
                Random random = new Random((world.func_72905_C() + (long)(chunkX + cx)) * 113L + (long)((chunkZ + cz) * 31) + 77L);
                random.nextFloat();
                if (!(random.nextFloat() < 0.05f)) continue;
                int x = cx * 16 + random.nextInt(16);
                int y = 40 + random.nextInt(40);
                int z = cz * 16 + random.nextInt(16);
                int radius = random.nextInt(this.large ? 20 : 6) + (this.large ? 10 : 4);
                BlockMeta block = BlockMeta.STONE;
                if (blocks.length > 1) {
                    block = blocks[random.nextInt(blocks.length)];
                } else if (blocks.length == 1) {
                    block = blocks[0];
                }
                this.fillSphere(ablock, ameta, x, y, z, radius, block);
            }
        }
    }

    private void fillSphere(Block[] ablock, byte[] ameta, int centerx, int centery, int centerz, int radius, BlockMeta blockMeta) {
        Block block = blockMeta.getBlock();
        byte meta = blockMeta.getMeta();
        double sqradius = radius * radius;
        for (int x = 0; x < 16; ++x) {
            double dxdx = (x - centerx) * (x - centerx);
            for (int z = 0; z < 16; ++z) {
                double dzdz = (z - centerz) * (z - centerz);
                int index = (x * 16 + z) * 256;
                for (int y = centery - radius; y <= centery + radius; ++y) {
                    double dydy = (y - centery) * (y - centery);
                    double sqdist = dxdx + dydy + dzdz;
                    if (!(sqdist <= sqradius)) continue;
                    ablock[index + y] = block;
                    ameta[index + y] = meta;
                }
            }
        }
    }
}

