/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.description.CelestialBodyDescriptor;
import mcjty.rftools.dimension.world.GenericWorldProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class SkyRenderer {
    private static final ResourceLocation locationEndSkyPng = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation locationPlasmaSkyPng = new ResourceLocation("rftools:textures/sky/plasmasky.png");
    private static final ResourceLocation locationMoonPhasesPng = new ResourceLocation("textures/environment/moon_phases.png");
    private static final ResourceLocation locationSunPng = new ResourceLocation("textures/environment/sun.png");
    private static final ResourceLocation locationPlanetPng = new ResourceLocation("rftools:textures/sky/planet1.png");
    private static boolean initialized = false;
    private static int starGLCallList;
    private static int glSkyList;
    private static int glSkyList2;
    private static UV[] faceDown;
    private static UV[] faceUp;
    private static UV[] faceNorth;
    private static UV[] faceSouth;
    private static UV[] faceWest;
    private static UV[] faceEast;

    private static void initialize() {
        if (!initialized) {
            int k;
            int j;
            initialized = true;
            starGLCallList = GLAllocation.func_74526_a((int)3);
            GL11.glPushMatrix();
            GL11.glNewList((int)starGLCallList, (int)4864);
            SkyRenderer.renderStars();
            GL11.glEndList();
            GL11.glPopMatrix();
            Tessellator tessellator = Tessellator.field_78398_a;
            glSkyList = starGLCallList + 1;
            GL11.glNewList((int)glSkyList, (int)4864);
            int b2 = 64;
            int i = 256 / b2 + 2;
            float f = 16.0f;
            for (j = -b2 * i; j <= b2 * i; j += b2) {
                for (k = -b2 * i; k <= b2 * i; k += b2) {
                    tessellator.func_78382_b();
                    tessellator.func_78377_a((double)(j + 0), (double)f, (double)(k + 0));
                    tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + 0));
                    tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + b2));
                    tessellator.func_78377_a((double)(j + 0), (double)f, (double)(k + b2));
                    tessellator.func_78381_a();
                }
            }
            GL11.glEndList();
            glSkyList2 = starGLCallList + 2;
            GL11.glNewList((int)glSkyList2, (int)4864);
            f = -16.0f;
            tessellator.func_78382_b();
            for (j = -b2 * i; j <= b2 * i; j += b2) {
                for (k = -b2 * i; k <= b2 * i; k += b2) {
                    tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + 0));
                    tessellator.func_78377_a((double)(j + 0), (double)f, (double)(k + 0));
                    tessellator.func_78377_a((double)(j + 0), (double)f, (double)(k + b2));
                    tessellator.func_78377_a((double)(j + b2), (double)f, (double)(k + b2));
                }
            }
            tessellator.func_78381_a();
            GL11.glEndList();
        }
    }

    public static void registerNoSky(GenericWorldProvider provider) {
        provider.setSkyRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        });
        provider.setCloudRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        });
    }

    public static void registerEnderSky(GenericWorldProvider provider) {
        provider.setSkyRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
                SkyRenderer.renderEnderSky();
            }
        });
        provider.setCloudRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        });
    }

    public static void registerPlasmaSky(GenericWorldProvider provider) {
        provider.setSkyRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
                SkyRenderer.renderPlasmaSky();
            }
        });
        provider.setCloudRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
            }
        });
    }

    public static void registerSky(GenericWorldProvider provider, final DimensionInformation information) {
        provider.setSkyRenderer(new IRenderHandler(){

            public void render(float partialTicks, WorldClient world, Minecraft mc) {
                SkyRenderer.renderSky(partialTicks, information);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderPlasmaSky() {
        TextureManager renderEngine = Minecraft.func_71410_x().func_110434_K();
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        GL11.glDepthMask((boolean)false);
        renderEngine.func_110577_a(locationPlasmaSkyPng);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < 6; ++i) {
            GL11.glPushMatrix();
            UV[] uv = faceDown;
            int col = 0xFFFFFF;
            if (i == 0) {
                col = 0;
            } else if (i == 1) {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                uv = faceNorth;
            } else if (i == 2) {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                uv = faceSouth;
            } else if (i == 3) {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                uv = faceUp;
                col = 0;
            } else if (i == 4) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                uv = faceEast;
            } else if (i == 5) {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                uv = faceWest;
            }
            tessellator.func_78382_b();
            tessellator.func_78378_d(col);
            tessellator.func_78374_a(-100.0, -100.0, -100.0, uv[0].u, uv[0].v);
            tessellator.func_78374_a(-100.0, -100.0, 100.0, uv[1].u, uv[1].v);
            tessellator.func_78374_a(100.0, -100.0, 100.0, uv[2].u, uv[2].v);
            tessellator.func_78374_a(100.0, -100.0, -100.0, uv[3].u, uv[3].v);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderEnderSky() {
        TextureManager renderEngine = Minecraft.func_71410_x().func_110434_K();
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        GL11.glDepthMask((boolean)false);
        renderEngine.func_110577_a(locationEndSkyPng);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < 6; ++i) {
            GL11.glPushMatrix();
            if (i == 1) {
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 2) {
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 3) {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (i == 4) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (i == 5) {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            tessellator.func_78382_b();
            tessellator.func_78378_d(0x282828);
            tessellator.func_78374_a(-100.0, -100.0, -100.0, 0.0, 0.0);
            tessellator.func_78374_a(-100.0, -100.0, 100.0, 0.0, 16.0);
            tessellator.func_78374_a(100.0, -100.0, 100.0, 16.0, 16.0);
            tessellator.func_78374_a(100.0, -100.0, -100.0, 16.0, 0.0);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
    }

    @SideOnly(value=Side.CLIENT)
    private static void renderSky(float partialTickTime, DimensionInformation information) {
        float f10;
        float f9;
        float f8;
        float f6;
        SkyRenderer.initialize();
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        TextureManager renderEngine = Minecraft.func_71410_x().func_110434_K();
        GL11.glDisable((int)3553);
        Vec3 vec3 = world.func_72833_a((Entity)player, partialTickTime);
        float skyRed = (float)vec3.field_72450_a;
        float skyGreen = (float)vec3.field_72448_b;
        float skyBlue = (float)vec3.field_72449_c;
        boolean anaglyph = Minecraft.func_71410_x().field_71474_y.field_74337_g;
        if (anaglyph) {
            float f4 = (skyRed * 30.0f + skyGreen * 59.0f + skyBlue * 11.0f) / 100.0f;
            float f5 = (skyRed * 30.0f + skyGreen * 70.0f) / 100.0f;
            f6 = (skyRed * 30.0f + skyBlue * 70.0f) / 100.0f;
            skyRed = f4;
            skyGreen = f5;
            skyBlue = f6;
        }
        GL11.glColor3f((float)skyRed, (float)skyGreen, (float)skyBlue);
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)skyRed, (float)skyGreen, (float)skyBlue);
        GL11.glCallList((int)glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74518_a();
        float[] sunsetColors = world.field_73011_w.func_76560_a(world.func_72826_c(partialTickTime), partialTickTime);
        if (sunsetColors != null) {
            float f11;
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)world.func_72929_e(partialTickTime)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            f6 = sunsetColors[0];
            float f7 = sunsetColors[1];
            f8 = sunsetColors[2];
            if (anaglyph) {
                f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
                f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
                f6 = f9;
                f7 = f10;
                f8 = f11;
            }
            tessellator.func_78371_b(6);
            tessellator.func_78369_a(f6, f7, f8, sunsetColors[3]);
            tessellator.func_78377_a(0.0, 100.0, 0.0);
            int b0 = 16;
            tessellator.func_78369_a(sunsetColors[0], sunsetColors[1], sunsetColors[2], 0.0f);
            for (int j = 0; j <= b0; ++j) {
                f11 = (float)j * (float)Math.PI * 2.0f / (float)b0;
                float f12 = MathHelper.func_76126_a((float)f11);
                float f13 = MathHelper.func_76134_b((float)f11);
                tessellator.func_78377_a((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * sunsetColors[3]));
            }
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glShadeModel((int)7424);
        }
        SkyRenderer.renderCelestialBodies(partialTickTime, information, world, renderEngine, tessellator);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = player.func_70666_h((float)partialTickTime).field_72448_b - world.func_72919_O();
        if (d0 < 0.0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)12.0f, (float)0.0f);
            GL11.glCallList((int)glSkyList2);
            GL11.glPopMatrix();
            f8 = 1.0f;
            f9 = -((float)(d0 + 65.0));
            f10 = -f8;
            tessellator.func_78382_b();
            tessellator.func_78384_a(0, 255);
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f9, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)(-f8));
            tessellator.func_78377_a((double)(-f8), (double)f10, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f10, (double)f8);
            tessellator.func_78377_a((double)f8, (double)f10, (double)(-f8));
            tessellator.func_78381_a();
        }
        if (world.field_73011_w.func_76561_g()) {
            GL11.glColor3f((float)(skyRed * 0.2f + 0.04f), (float)(skyGreen * 0.2f + 0.04f), (float)(skyBlue * 0.6f + 0.1f));
        } else {
            GL11.glColor3f((float)skyRed, (float)skyGreen, (float)skyBlue);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
        GL11.glCallList((int)glSkyList2);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    private static void renderCelestialBodies(float partialTickTime, DimensionInformation information, WorldClient world, TextureManager renderEngine, Tessellator tessellator) {
        List<CelestialBodyDescriptor> celestialBodies = information.getCelestialBodyDescriptors();
        GL11.glEnable((int)3553);
        OpenGlHelper.func_148821_a((int)770, (int)1, (int)1, (int)0);
        GL11.glPushMatrix();
        float f6 = 1.0f - world.func_72867_j(partialTickTime);
        if (celestialBodies.isEmpty()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(world.func_72826_c(partialTickTime) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            float f10 = 30.0f;
            renderEngine.func_110577_a(locationSunPng);
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(-f10), 100.0, (double)(-f10), 0.0, 0.0);
            tessellator.func_78374_a((double)f10, 100.0, (double)(-f10), 1.0, 0.0);
            tessellator.func_78374_a((double)f10, 100.0, (double)f10, 1.0, 1.0);
            tessellator.func_78374_a((double)(-f10), 100.0, (double)f10, 0.0, 1.0);
            tessellator.func_78381_a();
            f10 = 20.0f;
            renderEngine.func_110577_a(locationMoonPhasesPng);
            int k = world.func_72853_d();
            int l = k % 4;
            int i1 = k / 4 % 2;
            float f14 = (float)(l + 0) / 4.0f;
            float f15 = (float)(i1 + 0) / 2.0f;
            float f16 = (float)(l + 1) / 4.0f;
            float f17 = (float)(i1 + 1) / 2.0f;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(-f10), -100.0, (double)f10, (double)f16, (double)f17);
            tessellator.func_78374_a((double)f10, -100.0, (double)f10, (double)f14, (double)f17);
            tessellator.func_78374_a((double)f10, -100.0, (double)(-f10), (double)f14, (double)f15);
            tessellator.func_78374_a((double)(-f10), -100.0, (double)(-f10), (double)f16, (double)f15);
            tessellator.func_78381_a();
        } else {
            Random random = new Random(world.func_72905_C());
            for (CelestialBodyDescriptor body : celestialBodies) {
                float offset = 0.0f;
                float factor = 1.0f;
                float yangle = -90.0f;
                if (!body.isMain()) {
                    offset = random.nextFloat() * 200.0f;
                    factor = random.nextFloat() * 3.0f;
                    yangle = random.nextFloat() * 180.0f;
                }
                switch (body.getType()) {
                    case BODY_NONE: {
                        break;
                    }
                    case BODY_SUN: {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderSun(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 30.0f);
                        break;
                    }
                    case BODY_LARGESUN: {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderSun(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 80.0f);
                        break;
                    }
                    case BODY_SMALLSUN: {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderSun(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 10.0f);
                        break;
                    }
                    case BODY_REDSUN: {
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)f6);
                        SkyRenderer.renderSun(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 30.0f);
                        break;
                    }
                    case BODY_MOON: {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderMoon(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 20.0f);
                        break;
                    }
                    case BODY_LARGEMOON: {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderMoon(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 60.0f);
                        break;
                    }
                    case BODY_SMALLMOON: {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderMoon(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 10.0f);
                        break;
                    }
                    case BODY_REDMOON: {
                        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)f6);
                        SkyRenderer.renderMoon(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 20.0f);
                        break;
                    }
                    case BODY_PLANET: {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderPlanet(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 10.0f);
                        break;
                    }
                    case BODY_LARGEPLANET: {
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f6);
                        SkyRenderer.renderPlanet(partialTickTime, world, renderEngine, tessellator, offset, factor, yangle, 30.0f);
                    }
                }
            }
        }
        GL11.glDisable((int)3553);
        float f18 = world.func_72880_h(partialTickTime) * f6;
        if (f18 > 0.0f) {
            GL11.glColor4f((float)f18, (float)f18, (float)f18, (float)f18);
            GL11.glCallList((int)starGLCallList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
    }

    private static void renderMoon(float partialTickTime, WorldClient world, TextureManager renderEngine, Tessellator tessellator, float offset, float factor, float yangle, float size) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yangle, (float)0.0f, (float)1.0f, (float)0.0f);
        float angle = world.field_73011_w.func_76563_a(world.func_72912_H().func_76073_f(), partialTickTime);
        angle = angle * factor + offset;
        GL11.glRotatef((float)(angle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        renderEngine.func_110577_a(locationMoonPhasesPng);
        int k = world.func_72853_d();
        int l = k % 4;
        int i1 = k / 4 % 2;
        float f14 = (float)(l + 0) / 4.0f;
        float f15 = (float)(i1 + 0) / 2.0f;
        float f16 = (float)(l + 1) / 4.0f;
        float f17 = (float)(i1 + 1) / 2.0f;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-size), -100.0, (double)size, (double)f16, (double)f17);
        tessellator.func_78374_a((double)size, -100.0, (double)size, (double)f14, (double)f17);
        tessellator.func_78374_a((double)size, -100.0, (double)(-size), (double)f14, (double)f15);
        tessellator.func_78374_a((double)(-size), -100.0, (double)(-size), (double)f16, (double)f15);
        tessellator.func_78381_a();
    }

    private static void renderSun(float partialTickTime, WorldClient world, TextureManager renderEngine, Tessellator tessellator, float offset, float factor, float yangle, float size) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yangle, (float)0.0f, (float)1.0f, (float)0.0f);
        float angle = world.field_73011_w.func_76563_a(world.func_72912_H().func_76073_f(), partialTickTime);
        angle = angle * factor + offset;
        GL11.glRotatef((float)(angle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        renderEngine.func_110577_a(locationSunPng);
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-size), 100.0, (double)(-size), 0.0, 0.0);
        tessellator.func_78374_a((double)size, 100.0, (double)(-size), 1.0, 0.0);
        tessellator.func_78374_a((double)size, 100.0, (double)size, 1.0, 1.0);
        tessellator.func_78374_a((double)(-size), 100.0, (double)size, 0.0, 1.0);
        tessellator.func_78381_a();
    }

    private static void renderPlanet(float partialTickTime, WorldClient world, TextureManager renderEngine, Tessellator tessellator, float offset, float factor, float yangle, float size) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)yangle, (float)0.0f, (float)1.0f, (float)0.0f);
        float angle = world.field_73011_w.func_76563_a(world.func_72912_H().func_76073_f(), partialTickTime);
        angle = angle * factor + offset;
        GL11.glRotatef((float)(angle * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        renderEngine.func_110577_a(locationPlanetPng);
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-size), 100.0, (double)(-size), 0.0, 0.0);
        tessellator.func_78374_a((double)size, 100.0, (double)(-size), 1.0, 0.0);
        tessellator.func_78374_a((double)size, 100.0, (double)size, 1.0, 1.0);
        tessellator.func_78374_a((double)(-size), 100.0, (double)size, 0.0, 1.0);
        tessellator.func_78381_a();
    }

    private static void renderStars() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = d18 * d16 - d19 * d15;
                double d21 = d19 * d16 + d18 * d15;
                double d22 = d20 * d12 + d17 * d13;
                double d23 = d17 * d12 - d20 * d13;
                double d24 = d23 * d9 - d21 * d10;
                double d25 = d21 * d9 + d23 * d10;
                tessellator.func_78377_a(d5 + d24, d6 + d22, d7 + d25);
            }
        }
        tessellator.func_78381_a();
    }

    static {
        faceDown = new UV[]{UV.uv(0.0, 1.0), UV.uv(0.0, 0.0), UV.uv(1.0, 0.0), UV.uv(1.0, 1.0)};
        faceUp = new UV[]{UV.uv(0.0, 1.0), UV.uv(0.0, 0.0), UV.uv(1.0, 0.0), UV.uv(1.0, 1.0)};
        faceNorth = new UV[]{UV.uv(0.0, 0.0), UV.uv(0.0, 1.0), UV.uv(1.0, 1.0), UV.uv(1.0, 0.0)};
        faceSouth = new UV[]{UV.uv(1.0, 1.0), UV.uv(1.0, 0.0), UV.uv(0.0, 0.0), UV.uv(0.0, 1.0)};
        faceWest = new UV[]{UV.uv(1.0, 0.0), UV.uv(0.0, 0.0), UV.uv(0.0, 1.0), UV.uv(1.0, 1.0)};
        faceEast = new UV[]{UV.uv(0.0, 1.0), UV.uv(1.0, 1.0), UV.uv(1.0, 0.0), UV.uv(0.0, 0.0)};
    }

    private static class UV {
        private final double u;
        private final double v;

        private UV(double u, double v) {
            this.u = u;
            this.v = v;
        }

        public static UV uv(double u, double v) {
            return new UV(u, v);
        }
    }
}

