/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.dimlets.DimletSetup;
import mcjty.rftools.blocks.shards.AbstractDirectionalBlock;
import mcjty.rftools.blocks.special.SpecialSetup;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleporterSetup;
import mcjty.rftools.dimension.DimensionInformation;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.rftools.dimension.world.WorldGenerationTools;
import mcjty.rftools.dimension.world.types.FeatureType;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletRandomizer;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import mcjty.varia.BlockMeta;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import mcjty.varia.WeightedRandomSelector;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class GenericWorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int starty4;
        int starty3;
        int starty2;
        int midz;
        int midx;
        int starty1;
        int starty;
        RfToolsDimensionManager manager = RfToolsDimensionManager.getDimensionManager(world);
        if (manager.getDimensionDescriptor(world.field_73011_w.field_76574_g) == null) {
            return;
        }
        DimensionInformation information = manager.getDimensionInformation(world.field_73011_w.field_76574_g);
        BlockMeta baseBlock = information.getBaseBlockForTerrain();
        if (information.hasFeatureType(FeatureType.FEATURE_OREGEN)) {
            for (BlockMeta block : information.getExtraOregen()) {
                this.addOreSpawn(block.getBlock(), block.getMeta(), baseBlock.getBlock(), world, random, chunkX * 16, chunkZ * 16, 7, 10, 12, 2, 60);
            }
        }
        this.addOreSpawn(DimletSetup.dimensionalShardBlock, (byte)0, Blocks.field_150348_b, world, random, chunkX * 16, chunkZ * 16, 5, 8, 3, 2, 40);
        if (chunkX == 0 && chunkZ == 0) {
            this.generateSpawnPlatform(world);
        } else if (Math.abs(chunkX) > 6 && Math.abs(chunkZ) > 6 && random.nextInt(DimletConfiguration.dungeonChance) == 1 && (starty = ((starty1 = WorldGenerationTools.findSuitableEmptySpot(world, (midx = chunkX * 16 + 8) - 3, (midz = chunkZ * 16 + 8) - 3)) + (starty2 = WorldGenerationTools.findSuitableEmptySpot(world, midx + 3, midz - 3)) + (starty3 = WorldGenerationTools.findSuitableEmptySpot(world, midx - 3, midz + 3)) + (starty4 = WorldGenerationTools.findSuitableEmptySpot(world, midx + 3, midz + 3))) / 4) > 1 && starty < world.func_72800_K() - 20) {
            this.generateDungeon(world, random, midx, starty, midz);
        }
        if (Math.abs(chunkX) >= 3 && Math.abs(chunkZ) >= 3 && information.hasFeatureType(FeatureType.FEATURE_VOLCANOES) && random.nextInt(DimletConfiguration.volcanoChance) == 1) {
            int x = chunkX * 16 + random.nextInt(16);
            int z = chunkZ * 16 + random.nextInt(16);
            int cntsolid = 0;
            for (int y = world.func_72825_h(x, z); y > 3; --y) {
                if (WorldGenerationTools.isSolid(world, x, y, z)) {
                    if (++cntsolid <= 5) continue;
                    world.func_147465_d(x, y, z, (Block)SpecialSetup.volcanicCoreBlock, 0, 3);
                    RFTools.log("Spawned volcano block at " + x + "," + y + "," + z);
                    break;
                }
                cntsolid = 0;
            }
        }
    }

    private void generateSpawnPlatform(World world) {
        int z;
        int x;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        DimensionInformation information = dimensionManager.getDimensionInformation(world.field_73011_w.field_76574_g);
        int midx = 8;
        int midz = 8;
        int starty = WorldGenerationTools.findSuitableEmptySpot(world, midx, midz);
        starty = starty == -1 ? 64 : ++starty;
        boolean shelter = information.isShelter();
        int bounds = 3;
        if (shelter) {
            bounds = 4;
        }
        for (x = -bounds; x <= bounds; ++x) {
            for (z = -bounds; z <= bounds; ++z) {
                if (x == 0 && z == 0) {
                    world.func_147465_d(x + midx, starty, z + midz, (Block)TeleporterSetup.matterReceiverBlock, 0, 2);
                    MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)world.func_147438_o(x + midx, starty, z + midz);
                    matterReceiverTileEntity.modifyEnergyStored(TeleportConfiguration.RECEIVER_MAXENERGY);
                    matterReceiverTileEntity.setName(information.getName());
                    matterReceiverTileEntity.func_70296_d();
                } else if (x == 0 && (z == 2 || z == -2)) {
                    world.func_147465_d(x + midx, starty, z + midz, Blocks.field_150426_aN, 0, 2);
                } else {
                    world.func_147465_d(x + midx, starty, z + midz, Blocks.field_150406_ce, 3, 2);
                }
                for (int y = 1; y <= 3; ++y) {
                    world.func_147468_f(x + midx, starty + y, z + midz);
                }
                if (world.func_147437_c(x + midx, starty + 4, z + midz)) continue;
                world.func_147465_d(x + midx, starty + 4, z + midz, Blocks.field_150406_ce, 3, 2);
            }
        }
        if (shelter) {
            for (int y = 1; y <= 3; ++y) {
                for (int x2 = -bounds; x2 <= bounds; ++x2) {
                    for (int z2 = -bounds; z2 <= bounds; ++z2) {
                        if (x2 != -bounds && x2 != bounds && z2 != -bounds && z2 != bounds) continue;
                        if (z2 == 0 && y >= 2 && y <= 3 || x2 == 0 && y >= 2 && y <= 3 && z2 == bounds) {
                            world.func_147465_d(x2 + midx, starty + y, z2 + midz, Blocks.field_150410_aZ, 0, 2);
                            continue;
                        }
                        if (x2 == 0 && y == 1 && z2 == -bounds) {
                            world.func_147465_d(x2 + midx, starty + y, z2 + midz, Blocks.field_150454_av, 1, 2);
                            continue;
                        }
                        if (x2 == 0 && y == 2 && z2 == -bounds) {
                            world.func_147465_d(x2 + midx, starty + y, z2 + midz, Blocks.field_150454_av, 8, 2);
                            continue;
                        }
                        world.func_147465_d(x2 + midx, starty + y, z2 + midz, Blocks.field_150406_ce, 9, 2);
                    }
                }
            }
            for (x = -bounds; x <= bounds; ++x) {
                for (z = -bounds; z <= bounds; ++z) {
                    world.func_147465_d(x + midx, starty + 4, z + midz, Blocks.field_150406_ce, 9, 2);
                }
            }
            world.func_147465_d(midx - 1, starty + 2, midz - bounds - 1, Blocks.field_150430_aB, 4, 2);
            world.func_147465_d(midx + 1, starty + 2, midz - bounds + 1, Blocks.field_150430_aB, 3, 2);
            world.func_147465_d(midx + 1, starty, midz - bounds - 1, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx, starty, midz - bounds - 1, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx - 1, starty, midz - bounds - 1, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx + 1, starty, midz - bounds - 2, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx, starty, midz - bounds - 2, Blocks.field_150406_ce, 3, 2);
            world.func_147465_d(midx - 1, starty, midz - bounds - 2, Blocks.field_150406_ce, 3, 2);
        }
        TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
        Coordinate spawnPoint = new Coordinate(midx, starty, midz);
        GlobalCoordinate gc = new GlobalCoordinate(spawnPoint, world.field_73011_w.field_76574_g);
        TeleportDestination destination = destinations.addDestination(gc);
        destination.setName(information.getName());
        destinations.save(world);
        information.setSpawnPoint(spawnPoint);
        dimensionManager.save(world);
    }

    private void generateDungeon(World world, Random random, int midx, int starty, int midz) {
        int x;
        AbstractDirectionalBlock cornerBlock;
        boolean doSmallAntenna = random.nextInt(4) == 0;
        boolean doExtraFeature = random.nextInt(4) == 0;
        switch (random.nextInt(3)) {
            case 0: {
                cornerBlock = DimletSetup.dimensionalCrossBlock;
                break;
            }
            case 1: {
                cornerBlock = DimletSetup.dimensionalPattern1Block;
                break;
            }
            case 2: {
                cornerBlock = DimletSetup.dimensionalPattern2Block;
                break;
            }
            default: {
                cornerBlock = DimletSetup.dimensionalCross2Block;
            }
        }
        Block buildingBlock = Blocks.field_150406_ce;
        int color = random.nextInt(5);
        if (color == 0) {
            color = 3;
        } else if (color == 1) {
            color = 9;
        } else if (color == 2) {
            color = 11;
        } else {
            color = 0;
            buildingBlock = DimletSetup.dimensionalBlankBlock;
        }
        for (x = midx - 3; x <= midx + 3; ++x) {
            for (int z = midz - 3; z <= midz + 3; ++z) {
                boolean corner = !(x != midx - 3 && x != midx + 3 || z != midz - 3 && z != midz + 3);
                boolean xside = x == midx - 3 || x == midx + 3;
                boolean zside = z == midz - 3 || z == midz + 3;
                boolean antenna = x == midx - 2 && z == midz - 2;
                boolean smallAntenna = doSmallAntenna && x == midx + 2 && z == midz + 2;
                world.func_147465_d(x, starty, z, (Block)Blocks.field_150334_T, 0, 2);
                if (corner) {
                    world.func_147465_d(x, starty + 1, z, (Block)cornerBlock, 1, 2);
                    world.func_147465_d(x, starty + 2, z, (Block)cornerBlock, 1, 2);
                    world.func_147465_d(x, starty + 3, z, (Block)cornerBlock, 1, 2);
                } else if (xside) {
                    world.func_147465_d(x, starty + 1, z, buildingBlock, color, 2);
                    if (z >= midz - 1 && z <= midz + 1) {
                        world.func_147465_d(x, starty + 2, z, Blocks.field_150410_aZ, 0, 2);
                    } else {
                        world.func_147465_d(x, starty + 2, z, buildingBlock, color, 2);
                    }
                    world.func_147465_d(x, starty + 3, z, buildingBlock, color, 2);
                } else if (zside) {
                    world.func_147465_d(x, starty + 1, z, buildingBlock, color, 2);
                    world.func_147465_d(x, starty + 2, z, buildingBlock, color, 2);
                    world.func_147465_d(x, starty + 3, z, buildingBlock, color, 2);
                } else {
                    world.func_147468_f(x, starty + 1, z);
                    world.func_147468_f(x, starty + 2, z);
                    world.func_147468_f(x, starty + 3, z);
                }
                if (antenna) {
                    world.func_147465_d(x, starty + 4, z, (Block)Blocks.field_150334_T, 0, 2);
                    world.func_147465_d(x, starty + 5, z, Blocks.field_150411_aY, 0, 2);
                    world.func_147465_d(x, starty + 6, z, Blocks.field_150411_aY, 0, 2);
                    world.func_147465_d(x, starty + 7, z, Blocks.field_150411_aY, 0, 2);
                    world.func_147465_d(x, starty + 8, z, Blocks.field_150426_aN, 0, 2);
                } else if (smallAntenna) {
                    world.func_147465_d(x, starty + 4, z, (Block)Blocks.field_150334_T, 0, 2);
                    world.func_147465_d(x, starty + 5, z, Blocks.field_150411_aY, 0, 2);
                    world.func_147468_f(x, starty + 6, z);
                    world.func_147468_f(x, starty + 7, z);
                    world.func_147468_f(x, starty + 8, z);
                } else {
                    world.func_147465_d(x, starty + 4, z, (Block)Blocks.field_150333_U, 0, 2);
                    world.func_147468_f(x, starty + 5, z);
                    world.func_147468_f(x, starty + 6, z);
                    world.func_147468_f(x, starty + 7, z);
                    world.func_147468_f(x, starty + 8, z);
                }
                WorldGenerationTools.fillEmptyWithStone(world, x, starty - 1, z);
            }
        }
        if (doExtraFeature) {
            if (!WorldGenerationTools.isSolid(world, midx + 4, starty, midz - 3)) {
                world.func_147465_d(midx + 4, starty, midz - 3, Blocks.field_150411_aY, 0, 2);
            }
            world.func_147465_d(midx + 4, starty + 1, midz - 3, Blocks.field_150411_aY, 0, 2);
            world.func_147465_d(midx + 4, starty + 2, midz - 3, Blocks.field_150411_aY, 0, 2);
            if (!WorldGenerationTools.isSolid(world, midx + 5, starty, midz - 3)) {
                world.func_147465_d(midx + 5, starty, midz - 3, buildingBlock, color, 2);
            }
            world.func_147465_d(midx + 5, starty + 1, midz - 3, buildingBlock, color, 2);
            world.func_147465_d(midx + 5, starty + 2, midz - 3, buildingBlock, color, 2);
            WorldGenerationTools.fillEmptyWithStone(world, midx + 4, starty - 1, midz - 3);
            WorldGenerationTools.fillEmptyWithStone(world, midx + 5, starty - 1, midz - 3);
        }
        for (x = midx - 3; x <= midx + 3; ++x) {
            for (int y = starty + 1; y <= starty + 3; ++y) {
                world.func_147468_f(x, y, midz - 4);
            }
        }
        world.func_147465_d(midx - 1, starty, midz - 4, (Block)Blocks.field_150334_T, 0, 2);
        world.func_147465_d(midx, starty, midz - 4, (Block)Blocks.field_150334_T, 0, 2);
        world.func_147465_d(midx + 1, starty, midz - 4, (Block)Blocks.field_150334_T, 0, 2);
        world.func_147465_d(midx, starty + 1, midz - 3, Blocks.field_150454_av, 1, 2);
        world.func_147465_d(midx, starty + 2, midz - 3, Blocks.field_150454_av, 8, 2);
        world.func_147465_d(midx - 1, starty + 2, midz - 4, Blocks.field_150430_aB, 4, 2);
        world.func_147465_d(midx + 1, starty + 2, midz - 2, Blocks.field_150430_aB, 3, 2);
        world.func_147465_d(midx, starty + 3, midz + 3, Blocks.field_150379_bu, 0, 2);
        world.func_147465_d(midx, starty + 3, midz + 2, Blocks.field_150442_at, 4, 2);
        world.func_147465_d(midx + 2, starty + 1, midz - 2, (Block)Blocks.field_150486_ae, 0, 2);
        TileEntityChest chest = (TileEntityChest)world.func_147438_o(midx + 2, starty + 1, midz - 2);
        for (int i = 0; i < random.nextInt(2) + 2; ++i) {
            chest.func_70299_a(random.nextInt(chest.func_70302_i_()), new ItemStack((Item)ModItems.unknownDimlet, random.nextInt(6) + 3));
        }
        WeightedRandomSelector.Distribution<Integer> goodDistribution = DimletRandomizer.randomDimlets.createDistribution(0.01f);
        for (int i = 0; i < random.nextInt(2) + 1; ++i) {
            DimletKey randomDimlet = DimletRandomizer.getRandomDimlet(goodDistribution, random);
            chest.func_70299_a(random.nextInt(chest.func_70302_i_()), KnownDimletConfiguration.makeKnownDimlet(randomDimlet, world));
        }
        WeightedRandomSelector.Distribution<Integer> bestDistribution = DimletRandomizer.randomDimlets.createDistribution(0.15f);
        EntityItemFrame frame1 = this.spawnItemFrame(world, midx - 1, starty + 2, midz + 2);
        DimletKey rd1 = DimletRandomizer.getRandomDimlet(bestDistribution, random);
        frame1.func_82334_a(KnownDimletConfiguration.makeKnownDimlet(rd1, world));
        EntityItemFrame frame2 = this.spawnItemFrame(world, midx, starty + 2, midz + 2);
        DimletKey rd2 = DimletRandomizer.getRandomDimlet(bestDistribution, random);
        frame2.func_82334_a(KnownDimletConfiguration.makeKnownDimlet(rd2, world));
        EntityItemFrame frame3 = this.spawnItemFrame(world, midx + 1, starty + 2, midz + 2);
        DimletKey rd3 = DimletRandomizer.getRandomDimlet(bestDistribution, random);
        frame3.func_82334_a(KnownDimletConfiguration.makeKnownDimlet(rd3, world));
    }

    private EntityItemFrame spawnItemFrame(World world, int x, int y, int z) {
        EntityItemFrame frame = new EntityItemFrame(world, x, y, z + 1, 2);
        world.func_72838_d((Entity)frame);
        frame.func_70107_b((double)x, (double)y, (double)z);
        frame.field_146063_b = x;
        frame.field_146064_c = y;
        frame.field_146062_d = z + 1;
        frame.func_82328_a(frame.field_82332_a);
        return frame;
    }

    public void addOreSpawn(Block block, byte blockMeta, Block targetBlock, World world, Random random, int blockXPos, int blockZPos, int minVeinSize, int maxVeinSize, int chancesToSpawn, int minY, int maxY) {
        WorldGenMinable minable = new WorldGenMinable(block, (int)blockMeta, minVeinSize - random.nextInt(maxVeinSize - minVeinSize), targetBlock);
        for (int i = 0; i < chancesToSpawn; ++i) {
            int posX = blockXPos + random.nextInt(16);
            int posY = minY + random.nextInt(maxY - minY);
            int posZ = blockZPos + random.nextInt(16);
            minable.func_76484_a(world, random, posX, posY, posZ);
        }
    }
}

