/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.description;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.items.dimlets.DimletCosts;
import mcjty.rftools.items.dimlets.DimletEntry;
import mcjty.rftools.items.dimlets.DimletKey;
import mcjty.rftools.items.dimlets.DimletMapping;
import mcjty.rftools.items.dimlets.DimletType;
import mcjty.rftools.items.dimlets.KnownDimletConfiguration;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionDescriptor {
    private final String descriptionString;
    private final int rfCreateCost;
    private final int rfMaintainCost;
    private final int tickCost;
    private final long forcedSeed;

    public DimensionDescriptor(List<DimletKey> descriptors, long forcedSeed) {
        this.forcedSeed = forcedSeed;
        StringBuilder s = new StringBuilder();
        ArrayList<Pair<DimletKey, List<DimletKey>>> dimlets = new ArrayList<Pair<DimletKey, List<DimletKey>>>();
        ArrayList<DimletKey> currentModifiers = new ArrayList<DimletKey>();
        this.groupDimletsAndModifiers(descriptors, dimlets, currentModifiers);
        this.constructDescriptionStringNew(s, dimlets, currentModifiers);
        this.descriptionString = s.toString();
        this.tickCost = this.calculateTickCost(dimlets);
        this.rfCreateCost = this.calculateCreationRfCost(dimlets, currentModifiers, this.tickCost);
        this.rfMaintainCost = this.calculateMaintenanceRfCost(dimlets);
    }

    private void constructDescriptionStringNew(StringBuilder s, List<Pair<DimletKey, List<DimletKey>>> dimlets, List<DimletKey> currentModifiers) {
        s.append('@');
        boolean first = true;
        for (Pair<DimletKey, List<DimletKey>> dimletWithModifiers : dimlets) {
            DimletKey key = (DimletKey)dimletWithModifiers.getLeft();
            List mods = (List)dimletWithModifiers.getRight();
            if (mods != null) {
                for (DimletKey modifier : mods) {
                    if (!first) {
                        s.append(',');
                    }
                    first = false;
                    s.append('#').append(modifier);
                }
            }
            if (!first) {
                s.append(',');
            }
            first = false;
            s.append(key);
        }
        for (DimletKey modifier : currentModifiers) {
            if (s.length() > 0) {
                s.append(',');
            }
            s.append('?').append(modifier);
        }
    }

    private void groupDimletsAndModifiers(List<DimletKey> descriptors, List<Pair<DimletKey, List<DimletKey>>> dimlets, List<DimletKey> currentModifiers) {
        for (DimletKey key : descriptors) {
            DimletType type = key.getType();
            if (type.dimletType.isModifier()) {
                currentModifiers.add(key);
                continue;
            }
            ArrayList<DimletKey> modifiers = new ArrayList<DimletKey>();
            if (!currentModifiers.isEmpty()) {
                ArrayList<DimletKey> copy = new ArrayList<DimletKey>(currentModifiers);
                for (DimletKey modifier : copy) {
                    if (!type.dimletType.isModifiedBy(modifier.getType())) continue;
                    modifiers.add(modifier);
                    currentModifiers.remove(modifier);
                }
            }
            dimlets.add((Pair<DimletKey, List<DimletKey>>)Pair.of((Object)key, modifiers));
        }
    }

    public DimensionDescriptor(NBTTagCompound tagCompound) {
        String ds = tagCompound.func_74779_i("descriptionString");
        if (ds.startsWith("@")) {
            this.descriptionString = ds;
        } else {
            List<DimletKey> dimletDescriptors = DimensionDescriptor.parseOldDescriptionString(ds);
            ArrayList<Pair<DimletKey, List<DimletKey>>> dimlets = new ArrayList<Pair<DimletKey, List<DimletKey>>>();
            ArrayList<DimletKey> currentModifiers = new ArrayList<DimletKey>();
            this.groupDimletsAndModifiers(dimletDescriptors, dimlets, currentModifiers);
            StringBuilder s = new StringBuilder();
            this.constructDescriptionStringNew(s, dimlets, currentModifiers);
            RFTools.log("Converting dimension descriptor from: " + ds + " to: " + s);
            this.descriptionString = s.toString();
        }
        this.rfCreateCost = tagCompound.func_74762_e("rfCreateCost");
        this.rfMaintainCost = tagCompound.func_74762_e("rfMaintainCost");
        this.tickCost = tagCompound.func_74762_e("tickCost");
        this.forcedSeed = tagCompound.func_74763_f("forcedSeed");
    }

    public List<Pair<DimletKey, List<DimletKey>>> getDimletsWithModifiers() {
        ArrayList<Pair<DimletKey, List<DimletKey>>> result = new ArrayList<Pair<DimletKey, List<DimletKey>>>();
        String ds = this.descriptionString;
        if (ds.startsWith("@")) {
            ds = ds.substring(1);
        }
        if (!ds.isEmpty()) {
            String[] opcodes;
            ArrayList<DimletKey> modifiers = new ArrayList<DimletKey>();
            for (String oc : opcodes = StringUtils.split((String)ds, (String)",")) {
                DimletKey key;
                if (oc.startsWith("#")) {
                    key = DimletKey.parseKey(oc.substring(1));
                    modifiers.add(key);
                    continue;
                }
                if (oc.startsWith("?")) continue;
                key = DimletKey.parseKey(oc);
                result.add((Pair<DimletKey, List<DimletKey>>)Pair.of((Object)key, modifiers));
                modifiers = new ArrayList();
            }
        }
        return result;
    }

    public static List<DimletKey> parseDescriptionString(String descriptionString) {
        if (descriptionString.startsWith("@")) {
            return DimensionDescriptor.parseNewDescriptionString(descriptionString);
        }
        return DimensionDescriptor.parseOldDescriptionString(descriptionString);
    }

    private static List<DimletKey> parseNewDescriptionString(String descriptionString) {
        ArrayList<DimletKey> result = new ArrayList<DimletKey>();
        String ds = descriptionString.substring(1);
        if (!ds.isEmpty()) {
            String[] opcodes;
            for (String oc : opcodes = StringUtils.split((String)ds, (String)",")) {
                DimletKey key = oc.startsWith("#") ? DimletKey.parseKey(oc.substring(1)) : (oc.startsWith("?") ? DimletKey.parseKey(oc.substring(1)) : DimletKey.parseKey(oc));
                result.add(key);
            }
        }
        return result;
    }

    public static List<DimletKey> parseOldDescriptionString(String descriptionString) {
        DimletMapping mapping = DimletMapping.getInstance();
        ArrayList<DimletKey> result = new ArrayList<DimletKey>();
        if (!descriptionString.isEmpty()) {
            String[] opcodes;
            for (String oc : opcodes = StringUtils.split((String)descriptionString, (String)",")) {
                Integer id = oc.startsWith("#") ? Integer.valueOf(Integer.parseInt(oc.substring(2))) : (oc.startsWith("?") ? Integer.valueOf(Integer.parseInt(oc.substring(2))) : Integer.valueOf(Integer.parseInt(oc.substring(1))));
                result.add(mapping.getKey(id));
            }
        }
        return result;
    }

    public long calculateSeed(long seed) {
        DimletMapping mapping = DimletMapping.getInstance();
        List<DimletKey> dimletDescriptors = DimensionDescriptor.parseDescriptionString(this.descriptionString);
        for (DimletKey key : dimletDescriptors) {
            seed = 31L * seed + (long)mapping.getId(key).intValue();
        }
        return seed;
    }

    public String getDescriptionString() {
        return this.descriptionString;
    }

    public int getRfCreateCost() {
        return this.rfCreateCost;
    }

    public int getRfMaintainCost() {
        return this.rfMaintainCost;
    }

    public int getTickCost() {
        return this.tickCost;
    }

    public long getForcedSeed() {
        return this.forcedSeed;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("descriptionString", this.descriptionString);
        tagCompound.func_74768_a("rfCreateCost", this.rfCreateCost);
        tagCompound.func_74768_a("rfMaintainCost", this.rfMaintainCost);
        tagCompound.func_74768_a("tickCost", this.tickCost);
        tagCompound.func_74768_a("ticksLeft", this.tickCost);
        tagCompound.func_74772_a("forcedSeed", this.forcedSeed);
    }

    private int getModifierMultiplier(Map<Pair<DimletType, DimletType>, Integer> modifierMap, DimletType type1, DimletType type2) {
        Integer multiplier = modifierMap.get(Pair.of((Object)((Object)type1), (Object)((Object)type2)));
        if (multiplier == null) {
            return 1;
        }
        return multiplier;
    }

    private int getCreationCost(DimletType type, DimletKey key) {
        int cost = 0;
        DimletEntry entry = KnownDimletConfiguration.getEntry(key);
        if (entry != null && (cost = entry.getRfCreateCost()) == -1) {
            cost = type.dimletType.getCreationCost();
        }
        return cost;
    }

    private int calculateCreationRfCost(List<Pair<DimletKey, List<DimletKey>>> dimlets, List<DimletKey> unusedModifiers, int tickCost) {
        int rf = DimletCosts.baseDimensionCreationCost;
        for (Pair<DimletKey, List<DimletKey>> dimletWithModifier : dimlets) {
            DimletKey key = (DimletKey)dimletWithModifier.getLeft();
            DimletType type = key.getType();
            List list = (List)dimletWithModifier.getRight();
            if (list != null) {
                for (DimletKey modifier : list) {
                    float mult = type.dimletType.getModifierCreateCostFactor(modifier.getType(), key);
                    rf += (int)((float)this.getCreationCost(modifier.getType(), modifier) * mult);
                }
            }
            rf += this.getCreationCost(type, key);
        }
        for (DimletKey modifier : unusedModifiers) {
            rf += this.getCreationCost(modifier.getType(), modifier);
        }
        return rf += TeleportConfiguration.RECEIVER_MAXENERGY / tickCost;
    }

    private int getMaintenanceCost(DimletType type, DimletKey key) {
        int cost = 0;
        DimletEntry entry = KnownDimletConfiguration.getEntry(key);
        if (entry != null && (cost = entry.getRfMaintainCost()) == -1) {
            cost = type.dimletType.getMaintenanceCost();
        }
        return cost;
    }

    private int calculateMaintenanceRfCost(List<Pair<DimletKey, List<DimletKey>>> dimlets) {
        int rf = DimletCosts.baseDimensionMaintenanceCost;
        int rfGain = 0;
        for (Pair<DimletKey, List<DimletKey>> dimletWithModifier : dimlets) {
            int c;
            DimletKey key = (DimletKey)dimletWithModifier.getLeft();
            DimletType type = key.getType();
            List list = (List)dimletWithModifier.getRight();
            if (list != null) {
                for (DimletKey modifier : list) {
                    float mult = type.dimletType.getModifierMaintainCostFactor(modifier.getType(), key);
                    rf += (int)((float)this.getMaintenanceCost(modifier.getType(), modifier) * mult);
                }
            }
            if ((c = this.getMaintenanceCost(type, key)) < 0) {
                rfGain -= c;
                continue;
            }
            rf += c;
        }
        if (rfGain > 0 && (rf -= rf * rfGain / 100) < 10) {
            rf = 10;
        }
        return rf;
    }

    private int getTickCost(DimletType type, DimletKey key) {
        int cost = 0;
        DimletEntry entry = KnownDimletConfiguration.getEntry(key);
        if (entry != null && (cost = entry.getTickCost()) == -1) {
            cost = type.dimletType.getTickCost();
        }
        return cost;
    }

    private int calculateTickCost(List<Pair<DimletKey, List<DimletKey>>> dimlets) {
        int ticks = DimletCosts.baseDimensionTickCost;
        for (Pair<DimletKey, List<DimletKey>> dimletWithModifier : dimlets) {
            DimletKey key = (DimletKey)dimletWithModifier.getLeft();
            DimletType type = key.getType();
            List list = (List)dimletWithModifier.getRight();
            if (list != null) {
                for (DimletKey modifier : list) {
                    float mult = type.dimletType.getModifierTickCostFactor(modifier.getType(), key);
                    ticks += (int)((float)this.getTickCost(modifier.getType(), modifier) * mult);
                }
            }
            ticks += this.getTickCost(type, key);
        }
        return ticks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionDescriptor that = (DimensionDescriptor)o;
        return this.descriptionString.equals(that.descriptionString);
    }

    public int hashCode() {
        return this.descriptionString.hashCode();
    }
}

