/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class DimensionStorage
extends WorldSavedData {
    public static final String DIMSTORAGE_NAME = "RFToolsDimensionStorage";
    private static DimensionStorage instance = null;
    private final Map<Integer, Integer> energy = new HashMap<Integer, Integer>();

    public static void clearInstance() {
        if (instance != null) {
            DimensionStorage.instance.energy.clear();
            instance = null;
        }
    }

    public DimensionStorage(String identifier) {
        super(identifier);
    }

    public void save(World world) {
        world.field_72988_C.func_75745_a(DIMSTORAGE_NAME, (WorldSavedData)this);
        this.func_76185_a();
    }

    public static DimensionStorage getDimensionStorage(World world) {
        if (instance != null) {
            return instance;
        }
        instance = (DimensionStorage)world.field_72988_C.func_75742_a(DimensionStorage.class, DIMSTORAGE_NAME);
        if (instance == null) {
            instance = new DimensionStorage(DIMSTORAGE_NAME);
        }
        return instance;
    }

    public int getEnergyLevel(int id) {
        if (this.energy.containsKey(id)) {
            return this.energy.get(id);
        }
        return 0;
    }

    public void setEnergyLevel(int id, int energyLevel) {
        WorldServer world;
        int old = this.getEnergyLevel(id);
        this.energy.put(id, energyLevel);
        if (DimletConfiguration.freezeUnpowered && (world = DimensionManager.getWorld((int)id)) != null) {
            if (old == 0 && energyLevel > 0) {
                RfToolsDimensionManager.unfreezeDimension((World)world);
            } else if (energyLevel == 0) {
                RfToolsDimensionManager.freezeDimension((World)world);
            }
        }
    }

    public void removeDimension(int id) {
        this.energy.remove(id);
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.energy.clear();
        NBTTagList lst = tagCompound.func_150295_c("dimensions", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            int id = tc.func_74762_e("id");
            int rf = tc.func_74762_e("energy");
            this.energy.put(id, rf);
        }
    }

    public void func_76187_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<Integer, Integer> me : this.energy.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("id", me.getKey().intValue());
            tc.func_74768_a("energy", me.getValue().intValue());
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("dimensions", (NBTBase)lst);
    }
}

