/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import mcjty.rftools.commands.AbstractRfToolsCommand;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class CmdReclaim
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<dimension>";
    }

    @Override
    public String getCommand() {
        return "reclaim";
    }

    @Override
    public int getPermissionLevel() {
        return 3;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The dimension parameters is missing!"));
            return;
        }
        if (args.length > 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Too many parameters!"));
            return;
        }
        int dim = this.fetchInt(sender, args, 1, 0);
        World world = sender.func_130014_f_();
        if (DimensionManager.isDimensionRegistered((int)dim)) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "This dimension is still in use! You can't reclaim the id!"));
            return;
        }
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        dimensionManager.reclaimId(dim);
        dimensionManager.save(world);
        sender.func_145747_a((IChatComponent)new ChatComponentText("Dimension id " + dim + " reclaimed for future use."));
    }
}

