/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import mcjty.rftools.Achievements;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.teleporter.DialingDeviceTileEntity;
import mcjty.rftools.blocks.teleporter.MatterReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.RfToolsTeleporter;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class TeleportationTools {
    public static final int STATUS_OK = 0;
    public static final int STATUS_WARN = 1;
    public static final int STATUS_UNKNOWN = 2;

    public static void applyEffectForSeverity(EntityPlayer player, int severity, boolean boostNeeded) {
        switch (severity) {
            case 1: {
                if (!boostNeeded) break;
                player.func_70690_d(new PotionEffect(Potion.field_76431_k.func_76396_c(), 100));
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 5));
                break;
            }
            case 2: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 100));
                break;
            }
            case 3: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 100));
                player.func_70097_a(DamageSource.field_76377_j, 0.5f);
                break;
            }
            case 4: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 200));
                player.func_70097_a(DamageSource.field_76377_j, 0.5f);
                break;
            }
            case 5: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 200));
                player.func_70097_a(DamageSource.field_76377_j, 1.0f);
                break;
            }
            case 6: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 300));
                player.func_70097_a(DamageSource.field_76377_j, 1.0f);
                break;
            }
            case 7: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 300));
                player.func_70690_d(new PotionEffect(Potion.field_82731_v.func_76396_c(), 200));
                player.func_70097_a(DamageSource.field_76377_j, 2.0f);
                break;
            }
            case 8: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 400));
                player.func_70690_d(new PotionEffect(Potion.field_82731_v.func_76396_c(), 300));
                player.func_70097_a(DamageSource.field_76377_j, 2.0f);
                break;
            }
            case 9: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 400));
                player.func_70690_d(new PotionEffect(Potion.field_82731_v.func_76396_c(), 400));
                player.func_70097_a(DamageSource.field_76377_j, 3.0f);
                break;
            }
            case 10: {
                player.func_70690_d(new PotionEffect(Potion.field_76433_i.func_76396_c(), 500));
                player.func_70690_d(new PotionEffect(Potion.field_82731_v.func_76396_c(), 500));
                player.func_70097_a(DamageSource.field_76377_j, 3.0f);
            }
        }
    }

    public static int calculateRFCost(World world, Coordinate c1, TeleportDestination teleportDestination) {
        if (world.field_73011_w.field_76574_g != teleportDestination.getDimension()) {
            return TeleportConfiguration.rfStartTeleportBaseDim;
        }
        Coordinate c2 = teleportDestination.getCoordinate();
        double dist = Vec3.func_72443_a((double)c1.getX(), (double)c1.getY(), (double)c1.getZ()).func_72438_d(Vec3.func_72443_a((double)c2.getX(), (double)c2.getY(), (double)c2.getZ()));
        int rf = TeleportConfiguration.rfStartTeleportBaseLocal + (int)((double)TeleportConfiguration.rfStartTeleportDist * dist);
        if (rf > TeleportConfiguration.rfStartTeleportBaseDim) {
            rf = TeleportConfiguration.rfStartTeleportBaseDim;
        }
        return rf;
    }

    public static int calculateTime(World world, Coordinate c1, TeleportDestination teleportDestination) {
        if (world.field_73011_w.field_76574_g != teleportDestination.getDimension()) {
            return TeleportConfiguration.timeTeleportBaseDim;
        }
        Coordinate c2 = teleportDestination.getCoordinate();
        double dist = Vec3.func_72443_a((double)c1.getX(), (double)c1.getY(), (double)c1.getZ()).func_72438_d(Vec3.func_72443_a((double)c2.getX(), (double)c2.getY(), (double)c2.getZ()));
        int time = TeleportConfiguration.timeTeleportBaseLocal + (int)((double)TeleportConfiguration.timeTeleportDist * dist / 1000.0);
        if (time > TeleportConfiguration.timeTeleportBaseDim) {
            time = TeleportConfiguration.timeTeleportBaseDim;
        }
        return time;
    }

    public static boolean performTeleport(EntityPlayer player, TeleportDestination dest, int bad, int good, boolean boosted) {
        Coordinate c = dest.getCoordinate();
        int currentId = player.field_70170_p.field_73011_w.field_76574_g;
        if (currentId != dest.getDimension()) {
            TeleportationTools.teleportToDimension(player, dest.getDimension(), (double)c.getX() + 0.5, (double)c.getY() + 1.5, (double)c.getZ() + 0.5);
        } else {
            player.func_70634_a((double)c.getX() + 0.5, (double)(c.getY() + 1), (double)c.getZ() + 0.5);
        }
        RFTools.message(player, "Whoosh!");
        Achievements.trigger(player, Achievements.firstTeleport);
        boolean boostNeeded = false;
        int severity = TeleportationTools.consumeReceiverEnergy(player, dest.getCoordinate(), dest.getDimension());
        if (severity > 0 && boosted) {
            boostNeeded = true;
            severity = 1;
        }
        if (!TeleportationTools.applyBadEffectIfNeeded(player, severity, bad, good, boostNeeded) && (double)TeleportConfiguration.teleportVolume >= 0.01) {
            ((EntityPlayerMP)player).field_70170_p.func_72956_a((Entity)player, "rftools:teleport_whoosh", TeleportConfiguration.teleportVolume, 1.0f);
        }
        return boostNeeded;
    }

    public static int dial(World worldObj, DialingDeviceTileEntity dialingDeviceTileEntity, String player, Coordinate transmitter, int transDim, Coordinate coordinate, int dimension, boolean once) {
        RfToolsDimensionManager.getDimensionManager(worldObj);
        World transWorld = RfToolsDimensionManager.getWorldForDimension(transDim);
        if (transWorld == null) {
            return 256;
        }
        MatterTransmitterTileEntity transmitterTileEntity = (MatterTransmitterTileEntity)transWorld.func_147438_o(transmitter.getX(), transmitter.getY(), transmitter.getZ());
        if (player != null && !transmitterTileEntity.checkAccess(player)) {
            return 32;
        }
        if (coordinate == null) {
            transmitterTileEntity.setTeleportDestination(null, false);
            return 128;
        }
        TeleportDestination teleportDestination = TeleportationTools.findDestination(worldObj, coordinate, dimension);
        if (teleportDestination == null) {
            return 4;
        }
        Coordinate c = teleportDestination.getCoordinate();
        World recWorld = RfToolsDimensionManager.getWorldForDimension(teleportDestination.getDimension());
        if (recWorld == null && (recWorld = MinecraftServer.func_71276_C().func_71218_a(teleportDestination.getDimension())) == null) {
            return 4;
        }
        TileEntity tileEntity = recWorld.func_147438_o(c.getX(), c.getY(), c.getZ());
        if (!(tileEntity instanceof MatterReceiverTileEntity)) {
            return 4;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)tileEntity;
        matterReceiverTileEntity.updateDestination();
        if (player != null && !matterReceiverTileEntity.checkAccess(player)) {
            return 64;
        }
        if (!TeleportationTools.checkBeam(transmitter, transWorld, 1, 4, 2)) {
            return 2;
        }
        if (dialingDeviceTileEntity != null) {
            int cost = TeleportConfiguration.rfPerDial;
            cost = (int)((float)cost * (2.0f - dialingDeviceTileEntity.getInfusedFactor()) / 2.0f);
            if (dialingDeviceTileEntity.getEnergyStored(ForgeDirection.DOWN) < cost) {
                return 8;
            }
            dialingDeviceTileEntity.consumeEnergy(cost);
        }
        transmitterTileEntity.setTeleportDestination(teleportDestination, once);
        return 0;
    }

    private static int consumeReceiverEnergy(EntityPlayer player, Coordinate c, int dimension) {
        WorldServer world = DimensionManager.getWorld((int)dimension);
        TileEntity te = world.func_147438_o(c.getX(), c.getY(), c.getZ());
        if (!(te instanceof MatterReceiverTileEntity)) {
            RFTools.warn(player, "Something went wrong with the destination!");
            return 0;
        }
        MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
        int rf = TeleportConfiguration.rfPerTeleportReceiver;
        int extracted = rf = (int)((float)rf * (2.0f - matterReceiverTileEntity.getInfusedFactor()) / 2.0f);
        if (rf > matterReceiverTileEntity.getEnergyStored(ForgeDirection.DOWN)) {
            extracted = matterReceiverTileEntity.getEnergyStored(ForgeDirection.DOWN);
        }
        matterReceiverTileEntity.consumeEnergy(rf);
        int remainingRf = matterReceiverTileEntity.getEnergyStored(ForgeDirection.DOWN);
        if (remainingRf <= 1) {
            RFTools.warn(player, "The matter receiver has run out of power!");
        } else if (remainingRf < TeleportConfiguration.RECEIVER_MAXENERGY / 10) {
            RFTools.warn(player, "The matter receiver is getting very low on power!");
        } else if (remainingRf < TeleportConfiguration.RECEIVER_MAXENERGY / 5) {
            RFTools.warn(player, "The matter receiver is getting low on power!");
        }
        return 10 - extracted * 10 / rf;
    }

    public static int calculateSeverity(int bad, int total) {
        int severity = bad * 10 / total;
        if (TeleportationTools.mustInterrupt(bad, total)) {
            severity += 2;
        }
        if (severity > 10) {
            severity = 10;
        }
        return severity;
    }

    public static boolean applyBadEffectIfNeeded(EntityPlayer player, int severity, int bad, int total, boolean boostNeeded) {
        if ((severity += TeleportationTools.calculateSeverity(bad, total)) > 10) {
            severity = 10;
        }
        if (severity <= 0) {
            return false;
        }
        if ((double)TeleportConfiguration.teleportErrorVolume >= 0.01) {
            player.field_70170_p.func_72956_a((Entity)player, "rftools:teleport_error", TeleportConfiguration.teleportErrorVolume, 1.0f);
        }
        TeleportationTools.applyEffectForSeverity(player, severity, boostNeeded);
        return true;
    }

    public static boolean mustInterrupt(int bad, int total) {
        return bad > total / 2;
    }

    public static void teleportToDimension(EntityPlayer player, int dimension, double x, double y, double z) {
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
        WorldServer worldServer = MinecraftServer.func_71276_C().func_71218_a(dimension);
        player.func_82242_a(0);
        MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension(entityPlayerMP, dimension, (Teleporter)new RfToolsTeleporter(worldServer, x, y, z));
    }

    public static TeleportDestination findDestination(World worldObj, Coordinate coordinate, int dimension) {
        TeleportDestinations destinations = TeleportDestinations.getDestinations(worldObj);
        return destinations.getDestination(coordinate, dimension);
    }

    public static boolean checkBeam(Coordinate c, World world, int dy1, int dy2, int errory) {
        for (int dy = dy1; dy <= dy2; ++dy) {
            Block b = world.func_147439_a(c.getX(), c.getY() + dy, c.getZ());
            if (b.isAir((IBlockAccess)world, c.getX(), c.getY() + dy, c.getZ())) continue;
            if (dy > errory) break;
            return false;
        }
        return true;
    }
}

