/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.blocks.teleporter.GuiMatterReceiver;
import mcjty.rftools.blocks.teleporter.PlayerName;
import mcjty.rftools.blocks.teleporter.TeleportConfiguration;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.network.Argument;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class MatterReceiverTileEntity
extends GenericEnergyReceiverTileEntity {
    public static final String CMD_SETNAME = "setName";
    public static final String CMD_ADDPLAYER = "addPlayer";
    public static final String CMD_DELPLAYER = "delPlayer";
    public static final String CMD_SETPRIVATE = "setAccess";
    private String name = null;
    private boolean privateAccess = false;
    private Set<String> allowedPlayers = new HashSet<String>();
    private int id = -1;
    private int cachedX;
    private int cachedY;
    private int cachedZ;

    public MatterReceiverTileEntity() {
        super(TeleportConfiguration.RECEIVER_MAXENERGY, TeleportConfiguration.RECEIVER_RECEIVEPERTICK);
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public int getOrCalculateID() {
        if (this.id == -1) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
            GlobalCoordinate gc = new GlobalCoordinate(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g);
            this.id = destinations.getNewId(gc);
            destinations.save(this.field_145850_b);
            this.setId(this.id);
        }
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    public void setName(String name) {
        this.name = name;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
        TeleportDestination destination = destinations.getDestination(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g);
        if (destination != null) {
            destination.setName(name);
            destinations.save(this.field_145850_b);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @Override
    protected void checkStateServer() {
        if (this.cachedX != this.field_145851_c || this.cachedY != this.field_145848_d || this.cachedZ != this.field_145849_e) {
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
            destinations.removeDestination(new Coordinate(this.cachedX, this.cachedY, this.cachedZ), this.field_145850_b.field_73011_w.field_76574_g);
            this.cachedX = this.field_145851_c;
            this.cachedY = this.field_145848_d;
            this.cachedZ = this.field_145849_e;
            GlobalCoordinate gc = new GlobalCoordinate(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g);
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.addDestination(gc);
            destinations.save(this.field_145850_b);
            this.func_70296_d();
        }
    }

    public void updateDestination() {
        GlobalCoordinate gc;
        TeleportDestinations destinations = TeleportDestinations.getDestinations(this.field_145850_b);
        TeleportDestination destination = destinations.getDestination((gc = new GlobalCoordinate(new Coordinate(this.field_145851_c, this.field_145848_d, this.field_145849_e), this.field_145850_b.field_73011_w.field_76574_g)).getCoordinate(), gc.getDimension());
        if (destination != null) {
            destination.setName(this.name);
            if (this.id == -1) {
                this.id = destinations.getNewId(gc);
                this.func_70296_d();
            } else {
                destinations.assignId(gc, this.id);
            }
            destinations.save(this.field_145850_b);
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean checkAccess(String player) {
        if (!this.privateAccess) {
            return true;
        }
        return this.allowedPlayers.contains(player);
    }

    public List<PlayerName> getAllowedPlayers() {
        ArrayList<PlayerName> p = new ArrayList<PlayerName>();
        for (String player : this.allowedPlayers) {
            p.add(new PlayerName(player));
        }
        return p;
    }

    public void addPlayer(String player) {
        if (!this.allowedPlayers.contains(player)) {
            this.allowedPlayers.add(player);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void delPlayer(String player) {
        if (this.allowedPlayers.contains(player)) {
            this.allowedPlayers.remove(player);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int checkStatus() {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
        if (!block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
            return 1;
        }
        block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e);
        if (!block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 2, this.field_145849_e)) {
            return 1;
        }
        if (this.getEnergyStored(ForgeDirection.DOWN) < TeleportConfiguration.rfPerTeleportReceiver) {
            return 16;
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.cachedX = tagCompound.func_74762_e("cachedX");
        this.cachedY = tagCompound.func_74762_e("cachedY");
        this.cachedZ = tagCompound.func_74762_e("cachedZ");
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.name = tagCompound.func_74779_i("tpName");
        this.privateAccess = tagCompound.func_74767_n("private");
        this.allowedPlayers.clear();
        NBTTagList playerList = tagCompound.func_150295_c("players", 8);
        if (playerList != null) {
            for (int i = 0; i < playerList.func_74745_c(); ++i) {
                String player = playerList.func_150307_f(i);
                this.allowedPlayers.add(player);
            }
        }
        this.id = tagCompound.func_74764_b("destinationId") ? tagCompound.func_74762_e("destinationId") : -1;
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("cachedX", this.cachedX);
        tagCompound.func_74768_a("cachedY", this.cachedY);
        tagCompound.func_74768_a("cachedZ", this.cachedZ);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.name != null && !this.name.isEmpty()) {
            tagCompound.func_74778_a("tpName", this.name);
        }
        tagCompound.func_74757_a("private", this.privateAccess);
        NBTTagList playerTagList = new NBTTagList();
        for (String player : this.allowedPlayers) {
            playerTagList.func_74742_a((NBTBase)new NBTTagString(player));
        }
        tagCompound.func_74782_a("players", (NBTBase)playerTagList);
        tagCompound.func_74768_a("destinationId", this.id);
    }

    @Override
    public boolean execute(String command, Map<String, Argument> args) {
        boolean rc = super.execute(command, args);
        if (rc) {
            return true;
        }
        if (CMD_SETNAME.equals(command)) {
            this.setName(args.get("name").getString());
            return true;
        }
        if (CMD_SETPRIVATE.equals(command)) {
            this.setPrivateAccess(args.get("private").getBoolean());
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer(args.get("player").getString());
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer(args.get("player").getString());
            return true;
        }
        return false;
    }

    @Override
    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return this.getAllowedPlayers();
        }
        return null;
    }

    @Override
    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            GuiMatterReceiver.storeAllowedPlayersForClient(list);
            return true;
        }
        return false;
    }
}

