/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.container.EmptyContainer;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.DefaultSelectionEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.ImageLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.Widget;
import mcjty.gui.widgets.WidgetList;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storagemonitor.StorageScannerConfiguration;
import mcjty.rftools.blocks.teleporter.DialingDeviceTileEntity;
import mcjty.rftools.blocks.teleporter.PacketGetReceivers;
import mcjty.rftools.blocks.teleporter.PacketGetTransmitters;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.blocks.teleporter.TransmitterInfo;
import mcjty.rftools.network.Argument;
import mcjty.rftools.network.PacketHandler;
import mcjty.rftools.network.PacketRequestIntegerFromServer;
import mcjty.varia.Coordinate;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;

public class GuiDialingDevice
extends GenericGuiContainer<DialingDeviceTileEntity> {
    public static final int DIALER_WIDTH = 256;
    public static final int DIALER_HEIGHT = 224;
    private static final ResourceLocation guielements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private EnergyBar energyBar;
    private WidgetList transmitterList;
    private WidgetList receiverList;
    private Button dialButton;
    private Button dialOnceButton;
    private Button interruptButton;
    private ImageChoiceLabel favoriteButton;
    private Button statusButton;
    private Label statusLabel;
    private boolean analyzerAvailable = false;
    private boolean lastDialedTransmitter = false;
    private boolean lastCheckedReceiver = false;
    public static int fromServer_receiverStatus = -1;
    public static int fromServer_dialResult = -1;
    public static List<TeleportDestinationClientInfo> fromServer_receivers = null;
    public static List<TransmitterInfo> fromServer_transmitters = null;
    private List<TeleportDestinationClientInfo> receivers = null;
    private boolean receiversFiltered = false;
    private List<TransmitterInfo> transmitters = null;
    private int listDirty = 0;

    public GuiDialingDevice(DialingDeviceTileEntity dialingDeviceTileEntity, EmptyContainer container) {
        super(dialingDeviceTileEntity, container);
        DialingDeviceTileEntity.setCurrentRF(dialingDeviceTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int k = (this.field_146294_l - 256) / 2;
        int l = (this.field_146295_m - 224) / 2;
        int maxEnergyStored = ((DialingDeviceTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)((EnergyBar)((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setFilledRectThickness(1)).setHorizontal().setDesiredWidth(80)).setDesiredHeight(12)).setMaxValue(maxEnergyStored).setShowText(true);
        DialingDeviceTileEntity cfr_ignored_0 = (DialingDeviceTileEntity)this.tileEntity;
        this.energyBar.setValue(DialingDeviceTileEntity.getCurrentRF());
        Panel transmitterPanel = this.setupTransmitterPanel();
        Panel receiverPanel = this.setupReceiverPanel();
        this.dialButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Dial")).setTooltips(new String[]{"Start a connection between", "the selected transmitter", "and the selected receiver"})).setDesiredHeight(14)).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiDialingDevice.this.dial(false);
            }
        });
        this.dialOnceButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Dial Once")).setTooltips(new String[]{"Dial a connection for a", "single teleport"})).setDesiredHeight(14)).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiDialingDevice.this.dial(true);
            }
        });
        this.interruptButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Interrupt")).setTooltips(new String[]{"Interrupt a connection", "for the selected transmitter"})).setDesiredHeight(14)).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiDialingDevice.this.interruptDial();
            }
        });
        this.favoriteButton = (ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiDialingDevice.this.changeShowFavorite();
            }
        }).setDesiredWidth(10)).setDesiredHeight(10);
        this.favoriteButton.addChoice("No", "Unfavorited receiver", guielements, 131, 19);
        this.favoriteButton.addChoice("Yes", "Favorited receiver", guielements, 115, 19);
        this.favoriteButton.setCurrentChoice(((DialingDeviceTileEntity)this.tileEntity).isShowOnlyFavorites() ? 1 : 0);
        this.analyzerAvailable = DialingDeviceTileEntity.isDestinationAnalyzerAvailable((World)this.field_146297_k.field_71441_e, ((DialingDeviceTileEntity)this.tileEntity).field_145851_c, ((DialingDeviceTileEntity)this.tileEntity).field_145848_d, ((DialingDeviceTileEntity)this.tileEntity).field_145849_e);
        this.statusButton = ((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Check")).setDesiredHeight(14)).setEnabled(this.analyzerAvailable)).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiDialingDevice.this.checkStatus();
            }
        });
        if (this.analyzerAvailable) {
            this.statusButton.setTooltips(new String[]{"Check the status of", "the selected receiver"});
        } else {
            this.statusButton.setTooltips(new String[]{"Check the status of", "the selected receiver", "(needs an adjacent analyzer!)"});
        }
        Panel buttonPanel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.dialButton)).addChild(this.dialOnceButton)).addChild(this.interruptButton)).addChild(this.favoriteButton)).addChild(this.statusButton)).setDesiredHeight(16);
        this.statusLabel = new Label(this.field_146297_k, (Gui)this);
        ((AbstractWidget)((AbstractWidget)this.statusLabel.setDesiredWidth(180)).setDesiredHeight(14)).setFilledRectThickness(1);
        Panel statusPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Status"))).addChild(this.statusLabel)).setDesiredHeight(16);
        Object toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout(new VerticalLayout()).addChild(this.energyBar)).addChild(transmitterPanel)).addChild(receiverPanel)).addChild(buttonPanel)).addChild(statusPanel);
        toplevel.setBounds(new Rectangle(k, l, 256, 224));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
        this.listDirty = 0;
        this.clearSelectedStatus();
        this.requestReceivers();
        this.requestTransmitters();
        ((DialingDeviceTileEntity)this.tileEntity).requestRfFromServer();
    }

    private Panel setupReceiverPanel() {
        this.receiverList = ((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setRowheight(14).setFilledRectThickness(1)).setPropagateEventsToChildren(true).addSelectionEvent(new DefaultSelectionEvent(){

            @Override
            public void select(Widget parent, int index) {
                GuiDialingDevice.this.clearSelectedStatus();
            }

            @Override
            public void doubleClick(Widget parent, int index) {
                GuiDialingDevice.this.hilightSelectedReceiver(index);
            }
        });
        Slider receiverSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(13)).setVertical().setScrollable(this.receiverList);
        return (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.receiverList)).addChild(receiverSlider);
    }

    private Panel setupTransmitterPanel() {
        this.transmitterList = ((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setRowheight(18).setFilledRectThickness(1)).setDesiredHeight(76)).addSelectionEvent(new DefaultSelectionEvent(){

            @Override
            public void select(Widget parent, int index) {
                GuiDialingDevice.this.clearSelectedStatus();
                GuiDialingDevice.this.selectReceiverFromTransmitter();
            }

            @Override
            public void doubleClick(Widget parent, int index) {
                GuiDialingDevice.this.hilightSelectedTransmitter(index);
            }
        });
        Slider transmitterSlider = ((Slider)new Slider(this.field_146297_k, (Gui)this).setDesiredWidth(13)).setVertical().setScrollable(this.transmitterList);
        return (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.transmitterList)).addChild(transmitterSlider);
    }

    private void clearSelectedStatus() {
        this.lastDialedTransmitter = false;
        this.lastCheckedReceiver = false;
    }

    private void hilightSelectedTransmitter(int index) {
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(index);
        if (transmitterInfo == null) {
            return;
        }
        Coordinate c = transmitterInfo.getCoordinate();
        RFTools.instance.clientInfo.hilightBlock(c, System.currentTimeMillis() + (long)(1000 * StorageScannerConfiguration.hilightTime));
        GuiDialingDevice guiDialingDevice = this;
        guiDialingDevice.field_146297_k.func_71410_x().field_71439_g.func_71053_j();
    }

    private void hilightSelectedReceiver(int index) {
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(index);
        if (destination == null) {
            return;
        }
        Coordinate c = destination.getCoordinate();
        double distance = Vec3.func_72443_a((double)c.getX(), (double)c.getY(), (double)c.getZ()).func_72438_d(this.field_146297_k.field_71439_g.func_70666_h(1.0f));
        if (destination.getDimension() != this.field_146297_k.field_71441_e.field_73011_w.field_76574_g || distance > 150.0) {
            RFTools.warn((EntityPlayer)this.field_146297_k.field_71439_g, "Receiver is too far to hilight!");
            GuiDialingDevice guiDialingDevice = this;
            guiDialingDevice.field_146297_k.func_71410_x().field_71439_g.func_71053_j();
            return;
        }
        RFTools.instance.clientInfo.hilightBlock(c, System.currentTimeMillis() + (long)(1000 * StorageScannerConfiguration.hilightTime));
        RFTools.message((EntityPlayer)this.field_146297_k.field_71439_g, "The receiver is now highlighted");
        GuiDialingDevice guiDialingDevice = this;
        guiDialingDevice.field_146297_k.func_71410_x().field_71439_g.func_71053_j();
    }

    private void setStatusError(String message) {
        this.statusLabel.setText(message);
        this.statusLabel.setColor(-65536);
    }

    private void setStatusMessage(String message) {
        this.statusLabel.setText(message);
        this.statusLabel.setColor(-16777216);
    }

    private void checkStatus() {
        int receiverSelected = this.receiverList.getSelected();
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(receiverSelected);
        if (destination == null) {
            return;
        }
        Coordinate c = destination.getCoordinate();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer(((DialingDeviceTileEntity)this.tileEntity).field_145851_c, ((DialingDeviceTileEntity)this.tileEntity).field_145848_d, ((DialingDeviceTileEntity)this.tileEntity).field_145849_e, "checkStatus", "status", new Argument("c", c), new Argument("dim", destination.getDimension())));
        this.lastCheckedReceiver = true;
        this.listDirty = 0;
    }

    private void showStatus(int dialResult) {
        if ((dialResult & 8) != 0) {
            this.setStatusError("Dialing device power low!");
            return;
        }
        if ((dialResult & 0x10) != 0) {
            this.setStatusError("Matter receiver power low!");
            return;
        }
        if ((dialResult & 0x200) != 0) {
            this.setStatusError("Destination dimension power low!");
            return;
        }
        if ((dialResult & 0x20) != 0) {
            this.setStatusError("No access to transmitter!");
            return;
        }
        if ((dialResult & 0x40) != 0) {
            this.setStatusError("No access to receiver!");
            return;
        }
        if ((dialResult & 4) != 0) {
            this.setStatusError("Invalid destination!");
            return;
        }
        if ((dialResult & 0x100) != 0) {
            this.setStatusError("Invalid source!");
            return;
        }
        if ((dialResult & 1) != 0) {
            this.setStatusError("Receiver blocked!");
            return;
        }
        if ((dialResult & 2) != 0) {
            this.setStatusError("Transmitter blocked!");
            return;
        }
        if ((dialResult & 0x80) != 0) {
            this.setStatusMessage("Interrupted!");
            return;
        }
        this.setStatusMessage("Dial ok!");
    }

    private void selectReceiverFromTransmitter() {
        this.receiverList.setSelected(-1);
        TeleportDestination destination = this.getSelectedTransmitterDestination();
        if (destination == null) {
            return;
        }
        int i = 0;
        for (TeleportDestinationClientInfo receiver : this.receivers) {
            if (receiver.getDimension() == destination.getDimension() && receiver.getCoordinate().equals(destination.getCoordinate())) {
                this.receiverList.setSelected(i);
                return;
            }
            ++i;
        }
    }

    private void dial(boolean once) {
        int transmitterSelected = this.transmitterList.getSelected();
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return;
        }
        int receiverSelected = this.receiverList.getSelected();
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(receiverSelected);
        if (destination == null) {
            return;
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer(((DialingDeviceTileEntity)this.tileEntity).field_145851_c, ((DialingDeviceTileEntity)this.tileEntity).field_145848_d, ((DialingDeviceTileEntity)this.tileEntity).field_145849_e, once ? "dialOnce" : "dial", "dialResult", new Argument("player", this.field_146297_k.field_71439_g.getDisplayName()), new Argument("trans", transmitterInfo.getCoordinate()), new Argument("transDim", this.field_146297_k.field_71441_e.field_73011_w.field_76574_g), new Argument("c", destination.getCoordinate()), new Argument("dim", destination.getDimension())));
        this.lastDialedTransmitter = true;
        this.listDirty = 0;
    }

    private TeleportDestinationClientInfo getSelectedReceiver(int receiverSelected) {
        if (receiverSelected == -1) {
            return null;
        }
        if (receiverSelected >= this.receivers.size()) {
            return null;
        }
        return this.receivers.get(receiverSelected);
    }

    private void interruptDial() {
        int transmitterSelected = this.transmitterList.getSelected();
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return;
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketRequestIntegerFromServer(((DialingDeviceTileEntity)this.tileEntity).field_145851_c, ((DialingDeviceTileEntity)this.tileEntity).field_145848_d, ((DialingDeviceTileEntity)this.tileEntity).field_145849_e, "dial", "dialResult", new Argument("player", this.field_146297_k.field_71439_g.getDisplayName()), new Argument("trans", transmitterInfo.getCoordinate()), new Argument("transDim", this.field_146297_k.field_71441_e.field_73011_w.field_76574_g), new Argument("c", (Coordinate)null), new Argument("dim", 0)));
        this.lastDialedTransmitter = true;
        this.listDirty = 0;
    }

    private void requestReceivers() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetReceivers(((DialingDeviceTileEntity)this.tileEntity).field_145851_c, ((DialingDeviceTileEntity)this.tileEntity).field_145848_d, ((DialingDeviceTileEntity)this.tileEntity).field_145849_e, this.field_146297_k.field_71439_g.getDisplayName()));
    }

    private void requestTransmitters() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetTransmitters(((DialingDeviceTileEntity)this.tileEntity).field_145851_c, ((DialingDeviceTileEntity)this.tileEntity).field_145848_d, ((DialingDeviceTileEntity)this.tileEntity).field_145849_e));
    }

    private void changeShowFavorite() {
        boolean fav = this.favoriteButton.getCurrentChoice() == 1;
        this.sendServerCommand("showFavorite", new Argument("favorite", fav));
        this.listDirty = 0;
        this.transmitterList.setSelected(-1);
        this.receiverList.setSelected(-1);
    }

    private void changeFavorite() {
        int receiverSelected = this.receiverList.getSelected();
        TeleportDestinationClientInfo destination = this.getSelectedReceiver(receiverSelected);
        if (destination == null) {
            return;
        }
        boolean favorite = destination.isFavorite();
        destination.setFavorite(!favorite);
        this.sendServerCommand("favorite", new Argument("player", this.field_146297_k.field_71439_g.getDisplayName()), new Argument("receiver", destination.getCoordinate()), new Argument("dimension", destination.getDimension()), new Argument("favorite", !favorite));
        this.listDirty = 0;
    }

    private void populateReceivers() {
        boolean newReceiversFiltered;
        List<TeleportDestinationClientInfo> newReceivers = fromServer_receivers;
        if (newReceivers == null) {
            return;
        }
        boolean bl = newReceiversFiltered = this.favoriteButton.getCurrentChoice() == 1;
        if (((Object)newReceivers).equals(this.receivers) && newReceiversFiltered == this.receiversFiltered) {
            return;
        }
        this.receiversFiltered = newReceiversFiltered;
        if (this.receiversFiltered) {
            this.receivers = new ArrayList<TeleportDestinationClientInfo>();
            for (TeleportDestinationClientInfo receiver : newReceivers) {
                if (!receiver.isFavorite()) continue;
                this.receivers.add(receiver);
            }
        } else {
            this.receivers = new ArrayList<TeleportDestinationClientInfo>(newReceivers);
        }
        this.receiverList.removeChildren();
        for (TeleportDestinationClientInfo destination : this.receivers) {
            Coordinate coordinate = destination.getCoordinate();
            String dimName = destination.getDimensionName();
            if (dimName == null || dimName.trim().isEmpty()) {
                dimName = "Id " + destination.getDimension();
            }
            boolean favorite = destination.isFavorite();
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout());
            panel.addChild(((AbstractWidget)((Label)new Label(this.field_146297_k, (Gui)this).setText(destination.getName())).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setDesiredWidth(60));
            panel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setDynamic(true)).setText(coordinate.toString()));
            panel.addChild(((AbstractWidget)((Label)new Label(this.field_146297_k, (Gui)this).setText(dimName)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setDesiredWidth(50));
            ImageChoiceLabel choiceLabel = (ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

                @Override
                public void choiceChanged(Widget parent, String newChoice) {
                    GuiDialingDevice.this.changeFavorite();
                }
            }).setDesiredWidth(10);
            choiceLabel.addChoice("No", "Not favorited", guielements, 131, 19);
            choiceLabel.addChoice("Yes", "Favorited", guielements, 115, 19);
            choiceLabel.setCurrentChoice(favorite ? 1 : 0);
            panel.addChild(choiceLabel);
            this.receiverList.addChild(panel);
        }
    }

    private TeleportDestination getSelectedTransmitterDestination() {
        int transmitterSelected = this.transmitterList.getSelected();
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return null;
        }
        TeleportDestination destination = transmitterInfo.getTeleportDestination();
        if (destination.isValid()) {
            return destination;
        }
        return null;
    }

    private void populateTransmitters() {
        List<TransmitterInfo> newTransmitters = fromServer_transmitters;
        if (newTransmitters == null) {
            return;
        }
        if (((Object)newTransmitters).equals(this.transmitters)) {
            return;
        }
        this.transmitters = new ArrayList<TransmitterInfo>(newTransmitters);
        this.transmitterList.removeChildren();
        for (TransmitterInfo transmitterInfo : this.transmitters) {
            Coordinate coordinate = transmitterInfo.getCoordinate();
            TeleportDestination destination = transmitterInfo.getTeleportDestination();
            Panel panel = new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout());
            panel.addChild(((AbstractWidget)((Label)new Label(this.field_146297_k, (Gui)this).setText(transmitterInfo.getName())).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setDesiredWidth(90));
            panel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setDynamic(true)).setText(coordinate.toString()));
            panel.addChild(((AbstractWidget)new ImageLabel(this.field_146297_k, (Gui)this).setImage(guielements, destination.isValid() ? 80 : 96, 0)).setDesiredWidth(16));
            this.transmitterList.addChild(panel);
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.requestListsIfNeeded();
        this.populateReceivers();
        this.populateTransmitters();
        if (this.lastDialedTransmitter) {
            this.showStatus(fromServer_dialResult);
        } else if (this.lastCheckedReceiver) {
            this.showStatus(fromServer_receiverStatus);
        } else {
            this.statusLabel.setText("");
        }
        this.enableButtons();
        this.window.draw();
        DialingDeviceTileEntity cfr_ignored_0 = (DialingDeviceTileEntity)this.tileEntity;
        int currentRF = DialingDeviceTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((DialingDeviceTileEntity)this.tileEntity).requestRfFromServer();
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestReceivers();
            this.requestTransmitters();
            this.listDirty = 20;
        }
    }

    private String calculateDistance(int transmitterSelected, int receiverSelected) {
        TransmitterInfo transmitterInfo = this.getSelectedTransmitter(transmitterSelected);
        if (transmitterInfo == null) {
            return "?";
        }
        TeleportDestinationClientInfo teleportDestination = this.getSelectedReceiver(receiverSelected);
        if (teleportDestination == null) {
            return "?";
        }
        return DialingDeviceTileEntity.calculateDistance((World)this.field_146297_k.field_71441_e, transmitterInfo, teleportDestination);
    }

    private TransmitterInfo getSelectedTransmitter(int transmitterSelected) {
        if (transmitterSelected == -1) {
            return null;
        }
        if (transmitterSelected >= this.transmitters.size()) {
            return null;
        }
        return this.transmitters.get(transmitterSelected);
    }

    private void enableButtons() {
        int transmitterSelected = this.transmitterList.getSelected();
        if (this.transmitters == null || transmitterSelected >= this.transmitters.size()) {
            transmitterSelected = -1;
            this.transmitterList.setSelected(-1);
        }
        int receiverSelected = this.receiverList.getSelected();
        if (this.receivers == null || receiverSelected >= this.receivers.size()) {
            receiverSelected = -1;
            this.receiverList.setSelected(-1);
        }
        if (transmitterSelected != -1 && receiverSelected != -1) {
            this.dialButton.setEnabled(true);
            this.dialOnceButton.setEnabled(true);
            String distance = this.calculateDistance(transmitterSelected, receiverSelected);
            this.dialButton.setTooltips(new String[]{"Start a connection between", "the selected transmitter", "and the selected receiver.", "Distance: " + distance});
            this.dialOnceButton.setTooltips(new String[]{"Dial a connection for a", "single teleport.", "Distance: " + distance});
        } else {
            this.dialButton.setEnabled(false);
            this.dialOnceButton.setEnabled(false);
            this.dialButton.setTooltips(new String[]{"Start a connection between", "the selected transmitter", "and the selected receiver"});
            this.dialOnceButton.setTooltips(new String[]{"Dial a connection for a", "single teleport"});
        }
        if (transmitterSelected != -1) {
            TeleportDestination destination = this.getSelectedTransmitterDestination();
            this.interruptButton.setEnabled(destination != null);
        } else {
            this.interruptButton.setEnabled(false);
        }
        if (receiverSelected != -1) {
            this.statusButton.setEnabled(this.analyzerAvailable);
        } else {
            this.statusButton.setEnabled(false);
        }
    }
}

