/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;

public class PacketInventoryReady
implements IMessage,
IMessageHandler<PacketInventoryReady, IMessage> {
    private int x;
    private int y;
    private int z;
    private List<ItemStack> items;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        int size = buf.readInt();
        PacketBuffer buffer = new PacketBuffer(buf);
        this.items = new ArrayList<ItemStack>();
        for (int i = 0; i < size; ++i) {
            try {
                this.items.add(buffer.func_150791_c());
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.items.size());
        PacketBuffer buffer = new PacketBuffer(buf);
        for (ItemStack itemStack : this.items) {
            try {
                buffer.func_150788_a(itemStack);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public PacketInventoryReady() {
    }

    public PacketInventoryReady(int x, int y, int z, List<ItemStack> items) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.items = new ArrayList<ItemStack>();
        this.items.addAll(items);
    }

    public IMessage onMessage(PacketInventoryReady message, MessageContext ctx) {
        TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (!(te instanceof StorageScannerTileEntity)) {
            System.out.println("createInventoryReadyPacket: TileEntity is not a StorageScannerTileEntity!");
            return null;
        }
        StorageScannerTileEntity storageScannerTileEntity = (StorageScannerTileEntity)te;
        storageScannerTileEntity.storeItemsForClient(message.items);
        return null;
    }
}

