/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import java.awt.Rectangle;
import java.util.List;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.BlockRender;
import mcjty.gui.widgets.EnergyBar;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.blocks.spawner.SpawnerConfiguration;
import mcjty.rftools.blocks.spawner.SpawnerContainer;
import mcjty.rftools.blocks.spawner.SpawnerTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiSpawner
extends GenericGuiContainer<SpawnerTileEntity> {
    public static final int SPAWNER_WIDTH = 180;
    public static final int SPAWNER_HEIGHT = 152;
    private EnergyBar energyBar;
    private BlockRender[] blocks = new BlockRender[3];
    private Label[] labels = new Label[3];
    private Label name;
    private Label rfTick;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/spawner.png");

    public GuiSpawner(SpawnerTileEntity spawnerTileEntity, SpawnerContainer container) {
        super(spawnerTileEntity, container);
        SpawnerTileEntity.setCurrentRF(spawnerTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((SpawnerTileEntity)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint(new PositionalLayout.PositionalHint(10, 7, 8, 54))).setShowText(false);
        SpawnerTileEntity cfr_ignored_0 = (SpawnerTileEntity)this.tileEntity;
        this.energyBar.setValue(SpawnerTileEntity.getCurrentRF());
        this.blocks[0] = (BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setLayoutHint(new PositionalLayout.PositionalHint(110, 5, 18, 18));
        this.blocks[1] = (BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setLayoutHint(new PositionalLayout.PositionalHint(110, 25, 18, 18));
        this.blocks[2] = (BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setLayoutHint(new PositionalLayout.PositionalHint(110, 45, 18, 18));
        this.labels[0] = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.labels[0].setLayoutHint(new PositionalLayout.PositionalHint(130, 5, 40, 18));
        this.labels[1] = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.labels[1].setLayoutHint(new PositionalLayout.PositionalHint(130, 25, 40, 18));
        this.labels[2] = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.labels[2].setLayoutHint(new PositionalLayout.PositionalHint(130, 45, 40, 18));
        this.name = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.name.setLayoutHint(new PositionalLayout.PositionalHint(28, 31, 78, 16));
        this.rfTick = new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.rfTick.setLayoutHint(new PositionalLayout.PositionalHint(28, 47, 78, 16));
        Object toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout(new PositionalLayout()).addChild(this.energyBar)).addChild(this.blocks[0])).addChild(this.labels[0])).addChild(this.blocks[1])).addChild(this.labels[1])).addChild(this.blocks[2])).addChild(this.labels[2])).addChild(this.rfTick)).addChild(this.name);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((SpawnerTileEntity)this.tileEntity).requestRfFromServer();
    }

    private void showSyringeInfo() {
        String mob;
        for (int i = 0; i < 3; ++i) {
            this.blocks[i].setRenderItem(null);
            this.labels[i].setText("");
        }
        this.name.setText("");
        this.rfTick.setText("");
        ItemStack stack = ((SpawnerTileEntity)this.tileEntity).func_70301_a(0);
        if (stack == null || stack.field_77994_a == 0) {
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && (mob = tagCompound.func_74779_i("mobName")) != null && !mob.isEmpty()) {
            this.name.setText(mob);
            this.rfTick.setText(SpawnerConfiguration.mobSpawnRf.get(mob) + "RF");
            int i = 0;
            List<SpawnerConfiguration.MobSpawnAmount> list = SpawnerConfiguration.mobSpawnAmounts.get(mob);
            for (SpawnerConfiguration.MobSpawnAmount spawnAmount : list) {
                ItemStack b = spawnAmount.getObject();
                float amount = spawnAmount.getAmount();
                if (b == null) {
                    this.blocks[i].setRenderItem(new ItemStack((Block)Blocks.field_150362_t, 1, 0));
                } else {
                    this.blocks[i].setRenderItem(b);
                }
                this.labels[i].setText(Float.toString(amount));
                ++i;
            }
        }
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.showSyringeInfo();
        this.window.draw();
        SpawnerTileEntity cfr_ignored_0 = (SpawnerTileEntity)this.tileEntity;
        int currentRF = SpawnerTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((SpawnerTileEntity)this.tileEntity).requestRfFromServer();
    }
}

