/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import java.util.HashMap;
import java.util.Map;

public enum ShieldRenderingMode {
    MODE_INVISIBLE("Invisible"),
    MODE_SHIELD("Shield"),
    MODE_SOLID("Solid");

    private static final Map<String, ShieldRenderingMode> modeToMode;
    private final String description;

    private ShieldRenderingMode(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static ShieldRenderingMode getMode(String mode) {
        return modeToMode.get(mode);
    }

    static {
        modeToMode = new HashMap<String, ShieldRenderingMode>();
        for (ShieldRenderingMode mode : ShieldRenderingMode.values()) {
            modeToMode.put(mode.description, mode);
        }
    }
}

