/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.blocks.screens.modules.ScreenDataType;

public class PacketReturnScreenData
implements IMessage {
    int x;
    int y;
    int z;
    Map<Integer, Object[]> screenData;

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        int size = buf.readInt();
        this.screenData = new HashMap<Integer, Object[]>(size);
        for (int i = 0; i < size; ++i) {
            int key = buf.readInt();
            int arsize = buf.readInt();
            Object[] ar = new Object[arsize];
            for (int j = 0; j < arsize; ++j) {
                byte type = buf.readByte();
                ScreenDataType dataType = ScreenDataType.values()[type];
                ar[j] = dataType.readObject(buf);
            }
            this.screenData.put(key, ar);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.screenData.size());
        for (Map.Entry<Integer, Object[]> me : this.screenData.entrySet()) {
            buf.writeInt(me.getKey().intValue());
            Object[] c = me.getValue();
            buf.writeInt(c.length);
            for (Object o : c) {
                ScreenDataType.writeObject(buf, o);
            }
        }
    }

    public PacketReturnScreenData() {
    }

    public PacketReturnScreenData(int x, int y, int z, Map<Integer, Object[]> screenData) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.screenData = screenData;
    }
}

