/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import java.util.HashMap;
import mcjty.api.MachineInformation;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.ColorChoiceEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.BlockRender;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.ColorChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.blocks.screens.ModuleGuiChanged;
import mcjty.rftools.blocks.screens.modulesclient.ClientScreenModule;
import mcjty.varia.Coordinate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class MachineInformationClientScreenModule
implements ClientScreenModule {
    private String line = "";
    private int labcolor = 0xFFFFFF;
    private int txtcolor = 0xFFFFFF;
    protected int dim = 0;
    protected Coordinate coordinate = Coordinate.INVALID;

    @Override
    public ClientScreenModule.TransformMode getTransformMode() {
        return ClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public void render(FontRenderer fontRenderer, int currenty, Object[] screenData, float factor) {
        int xoffset;
        GL11.glDisable((int)2896);
        if (!this.line.isEmpty()) {
            fontRenderer.func_78276_b(this.line, 7, currenty, this.labcolor);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (this.coordinate.isValid() && screenData != null && screenData.length >= 1) {
            fontRenderer.func_78276_b((String)screenData[0], xoffset, currenty, this.txtcolor);
        } else {
            fontRenderer.func_78276_b("<invalid>", xoffset, currenty, 0xFF0000);
        }
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public Panel createGui(Minecraft mc, Gui gui, final NBTTagCompound currentData, final ModuleGuiChanged moduleGuiChanged) {
        Panel panel = new Panel(mc, gui).setLayout(new VerticalLayout());
        TextField textField = ((TextField)((TextField)new TextField(mc, gui).setDesiredHeight(16)).setTooltips(new String[]{"Text to use as label"})).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                currentData.func_74778_a("text", newText);
                moduleGuiChanged.updateData();
            }
        });
        panel.addChild(textField);
        this.addColorPanel(mc, gui, currentData, moduleGuiChanged, panel);
        this.addOptionPanel(mc, gui, currentData, moduleGuiChanged, panel);
        this.addMonitorPanel(mc, gui, currentData, panel);
        if (currentData != null) {
            textField.setText(currentData.func_74779_i("text"));
        }
        return panel;
    }

    private void addOptionPanel(Minecraft mc, Gui gui, final NBTTagCompound currentData, final ModuleGuiChanged moduleGuiChanged, Panel panel) {
        Panel optionPanel = (Panel)new Panel(mc, gui).setLayout(new HorizontalLayout()).setDesiredHeight(16);
        final HashMap<String, Integer> choiceToIndex = new HashMap<String, Integer>();
        final ChoiceLabel tagButton = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredHeight(16)).setDesiredWidth(80);
        optionPanel.addChild(tagButton);
        int x = currentData.func_74762_e("monitorx");
        int y = currentData.func_74762_e("monitory");
        int z = currentData.func_74762_e("monitorz");
        TileEntity tileEntity = mc.field_71441_e.func_147438_o(x, y, z);
        if (tileEntity instanceof MachineInformation) {
            int current = currentData.func_74762_e("monitorTag");
            MachineInformation information = (MachineInformation)tileEntity;
            String currentTag = null;
            for (int i = 0; i < information.getTagCount(); ++i) {
                String tag = information.getTagName(i);
                choiceToIndex.put(tag, i);
                tagButton.addChoices(tag);
                tagButton.setChoiceTooltip(tag, information.getTagDescription(i));
                if (current != i) continue;
                currentTag = tag;
            }
            if (currentTag != null) {
                tagButton.setChoice(currentTag);
            }
        }
        tagButton.addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                String choice = tagButton.getCurrentChoice();
                Integer index = (Integer)choiceToIndex.get(choice);
                if (index != null) {
                    currentData.func_74768_a("monitorTag", index.intValue());
                }
                moduleGuiChanged.updateData();
            }
        });
        panel.addChild(optionPanel);
    }

    private void addMonitorPanel(Minecraft mc, Gui gui, NBTTagCompound currentData, Panel panel) {
        String monitoring;
        Panel monitorPanel = (Panel)new Panel(mc, gui).setLayout(new HorizontalLayout()).setDesiredHeight(16);
        if (currentData.func_74764_b("monitorx")) {
            int dim = currentData.func_74762_e("dim");
            World world = mc.field_71439_g.field_70170_p;
            if (dim == world.field_73011_w.field_76574_g) {
                int x = currentData.func_74762_e("monitorx");
                int y = currentData.func_74762_e("monitory");
                int z = currentData.func_74762_e("monitorz");
                monitoring = currentData.func_74779_i("monitorname");
                Block block = world.func_147439_a(x, y, z);
                ((Panel)monitorPanel.addChild(new BlockRender(mc, gui).setRenderItem(block))).setDesiredWidth(20);
                monitorPanel.addChild(((AbstractWidget)((Label)new Label(mc, gui).setText(x + "," + y + "," + z)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setDesiredWidth(150));
            } else {
                monitoring = "<unreachable>";
            }
        } else {
            monitoring = "<not set>";
        }
        panel.addChild(monitorPanel);
        panel.addChild((Widget)new Label(mc, gui).setText(monitoring));
    }

    private void addColorPanel(Minecraft mc, Gui gui, NBTTagCompound currentData, ModuleGuiChanged moduleGuiChanged, Panel panel) {
        ColorChoiceLabel labelColorSelector = (ColorChoiceLabel)this.addColorSelector(mc, gui, currentData, moduleGuiChanged, "color").setTooltips(new String[]{"Color for the label"});
        ColorChoiceLabel txtColorSelector = (ColorChoiceLabel)this.addColorSelector(mc, gui, currentData, moduleGuiChanged, "txtcolor").setTooltips(new String[]{"Color for the text"});
        Panel colorPanel = (Panel)((Panel)((Panel)((Panel)((Panel)new Panel(mc, gui).setLayout(new HorizontalLayout()).addChild((Widget)new Label(mc, gui).setText("L:"))).addChild(labelColorSelector)).addChild((Widget)new Label(mc, gui).setText("Txt:"))).addChild(txtColorSelector)).setDesiredHeight(12);
        panel.addChild(colorPanel);
    }

    private ColorChoiceLabel addColorSelector(Minecraft mc, Gui gui, final NBTTagCompound currentData, final ModuleGuiChanged moduleGuiChanged, final String tagName) {
        int currentColor;
        ColorChoiceLabel colorChoiceLabel = ((ColorChoiceLabel)((ColorChoiceLabel)new ColorChoiceLabel(mc, gui).addColors(0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535).setDesiredWidth(26)).setDesiredHeight(14)).addChoiceEvent(new ColorChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, Integer newColor) {
                currentData.func_74768_a(tagName, newColor.intValue());
                moduleGuiChanged.updateData();
            }
        });
        if (currentData != null && (currentColor = currentData.func_74762_e(tagName)) != 0) {
            colorChoiceLabel.setCurrentColor(currentColor);
        }
        return colorChoiceLabel;
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, int x, int y, int z) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.labcolor = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.txtcolor = tagCompound.func_74764_b("txtcolor") ? tagCompound.func_74762_e("txtcolor") : 0xFFFFFF;
            this.setupCoordinateFromNBT(tagCompound, dim, x, y, z);
        }
    }

    protected void setupCoordinateFromNBT(NBTTagCompound tagCompound, int dim, int x, int y, int z) {
        this.coordinate = Coordinate.INVALID;
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = tagCompound.func_74762_e("dim");
            if (dim == this.dim) {
                Coordinate c = new Coordinate(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                int dx = Math.abs(c.getX() - x);
                int dy = Math.abs(c.getY() - y);
                int dz = Math.abs(c.getZ() - z);
                if (dx <= 64 && dy <= 64 && dz <= 64) {
                    this.coordinate = c;
                }
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

