/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.container.GenericContainerBlock;
import mcjty.container.WrenchUsage;
import mcjty.rftools.Achievements;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.screens.GuiScreen;
import mcjty.rftools.blocks.screens.ScreenContainer;
import mcjty.rftools.blocks.screens.ScreenHitTileEntity;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.screens.ScreenTileEntity;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ScreenBlock
extends GenericContainerBlock {
    public ScreenBlock(String blockName, Class<? extends ScreenTileEntity> clazz) {
        super(Material.field_151573_f, clazz);
        float width = 0.5f;
        float height = 1.0f;
        this.func_149676_a(0.5f - width, 0.0f, 0.5f - width, 0.5f + width, height, 0.5f + width);
        this.func_149663_c(blockName);
        this.func_149647_a(RFTools.tabRfTools);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tagCompound = accessor.getNBTData();
        if (tagCompound != null) {
            boolean power;
            boolean connected = tagCompound.func_74767_n("connected");
            if (connected) {
                currenttip.add(EnumChatFormatting.YELLOW + "[CONNECTED]");
            }
            if (power = tagCompound.func_74767_n("powerOn")) {
                currenttip.add(EnumChatFormatting.YELLOW + "[POWER]");
            }
            int rfPerTick = ((ScreenTileEntity)accessor.getTileEntity()).getTotalRfPerTick();
            currenttip.add(EnumChatFormatting.GREEN + (power ? "Consuming " : "Needs ") + rfPerTick + " RF/tick");
        }
        return currenttip;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            MovingObjectPosition mouseOver = Minecraft.func_71410_x().field_71476_x;
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_147438_o(x, y, z);
            screenTileEntity.hitScreenClient(mouseOver.field_72307_f.field_72450_a - (double)x, mouseOver.field_72307_f.field_72448_b - (double)y, mouseOver.field_72307_f.field_72449_c - (double)z, mouseOver.field_72310_e);
        }
    }

    private void setInvisibleBlockSafe(World world, int x, int y, int z, int dx, int dy, int dz, int meta) {
        int yy = y + dy;
        if (yy < 0 || yy >= world.func_72800_K()) {
            return;
        }
        int xx = x + dx;
        int zz = z + dz;
        if (world.func_147437_c(xx, yy, zz)) {
            world.func_147465_d(xx, yy, zz, (Block)ScreenSetup.screenHitBlock, meta, 3);
            ScreenHitTileEntity screenHitTileEntity = (ScreenHitTileEntity)world.func_147438_o(xx, yy, zz);
            screenHitTileEntity.setRelativeLocation(-dx, -dy, -dz);
        }
    }

    private void setInvisibleBlocks(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2) {
            this.setInvisibleBlockSafe(world, x, y, z, -1, 0, 0, meta);
            this.setInvisibleBlockSafe(world, x, y, z, 0, -1, 0, meta);
            this.setInvisibleBlockSafe(world, x, y, z, -1, -1, 0, meta);
        }
        if (meta == 3) {
            this.setInvisibleBlockSafe(world, x, y, z, 1, 0, 0, meta);
            this.setInvisibleBlockSafe(world, x, y, z, 0, -1, 0, meta);
            this.setInvisibleBlockSafe(world, x, y, z, 1, -1, 0, meta);
        }
        if (meta == 4) {
            this.setInvisibleBlockSafe(world, x, y, z, 0, 0, 1, meta);
            this.setInvisibleBlockSafe(world, x, y, z, 0, -1, 0, meta);
            this.setInvisibleBlockSafe(world, x, y, z, 0, -1, 1, meta);
        }
        if (meta == 5) {
            this.setInvisibleBlockSafe(world, x, y, z, 0, 0, -1, meta);
            this.setInvisibleBlockSafe(world, x, y, z, 0, -1, 0, meta);
            this.setInvisibleBlockSafe(world, x, y, z, 0, -1, -1, meta);
        }
    }

    private void clearInvisibleBlockSafe(World world, int x, int y, int z) {
        if (y < 0 || y >= world.func_72800_K()) {
            return;
        }
        if (world.func_147439_a(x, y, z) == ScreenSetup.screenHitBlock) {
            world.func_147468_f(x, y, z);
        }
    }

    private void clearInvisibleBlocks(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2) {
            this.clearInvisibleBlockSafe(world, x - 1, y, z);
            this.clearInvisibleBlockSafe(world, x, y - 1, z);
            this.clearInvisibleBlockSafe(world, x - 1, y - 1, z);
        }
        if (meta == 3) {
            this.clearInvisibleBlockSafe(world, x + 1, y, z);
            this.clearInvisibleBlockSafe(world, x, y - 1, z);
            this.clearInvisibleBlockSafe(world, x + 1, y - 1, z);
        }
        if (meta == 4) {
            this.clearInvisibleBlockSafe(world, x, y, z + 1);
            this.clearInvisibleBlockSafe(world, x, y - 1, z);
            this.clearInvisibleBlockSafe(world, x, y - 1, z + 1);
        }
        if (meta == 5) {
            this.clearInvisibleBlockSafe(world, x, y, z - 1);
            this.clearInvisibleBlockSafe(world, x, y - 1, z);
            this.clearInvisibleBlockSafe(world, x, y - 1, z - 1);
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float sx, float sy, float sz) {
        WrenchUsage wrenchUsed = this.testWrenchUsage(x, y, z, player);
        if (wrenchUsed == WrenchUsage.NORMAL) {
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_147438_o(x, y, z);
            if (screenTileEntity.isTransparent() && screenTileEntity.isLarge()) {
                screenTileEntity.setTransparent(false);
            } else if (screenTileEntity.isLarge()) {
                screenTileEntity.setLarge(false);
                this.clearInvisibleBlocks(world, x, y, z);
            } else if (screenTileEntity.isTransparent()) {
                screenTileEntity.setLarge(true);
                this.setInvisibleBlocks(world, x, y, z);
            } else {
                screenTileEntity.setTransparent(true);
            }
            return true;
        }
        if (wrenchUsed == WrenchUsage.SNEAKING) {
            this.breakAndRemember(world, player, x, y, z);
            return true;
        }
        ItemStack itemStack = player.func_70694_bm();
        if (itemStack != null && itemStack.func_77973_b() == Items.field_151100_aR) {
            int damage = itemStack.func_77960_j();
            if (damage < 0) {
                damage = 0;
            } else if (damage > 15) {
                damage = 15;
            }
            int color = ItemDye.field_150922_c[damage];
            ScreenTileEntity screenTileEntity = (ScreenTileEntity)world.func_147438_o(x, y, z);
            screenTileEntity.setColor(color);
            return true;
        }
        return this.openGui(world, x, y, z, player);
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("rftools:" + this.getSideIconName());
    }

    @Override
    public String getSideIconName() {
        return "screenFrame_icon";
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (meta == 2) {
            this.func_149676_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
        }
        if (meta == 3) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
        }
        if (meta == 4) {
            this.func_149676_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (meta == 5) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149633_g(world, x, y, z);
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149655_b(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public int getGuiID() {
        return RFTools.GUI_SCREEN;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            boolean large = tagCompound.func_74767_n("large");
            boolean transparent = tagCompound.func_74767_n("transparent");
            if (large) {
                list.add(EnumChatFormatting.BLUE + "Large screen.");
            }
            if (transparent) {
                list.add(EnumChatFormatting.BLUE + "Transparent screen.");
            }
            int rc = 0;
            NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
                ItemStack stack;
                NBTTagCompound tag = bufferTagList.func_150305_b(i);
                if (tag == null || (stack = ItemStack.func_77949_a((NBTTagCompound)tag)) == null) continue;
                ++rc;
            }
            list.add(EnumChatFormatting.BLUE + String.valueOf(rc) + " modules");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This is a modular screen. As such it doesn't show anything.");
            list.add(EnumChatFormatting.WHITE + "You must insert modules to control what you can see.");
            list.add(EnumChatFormatting.WHITE + "This screen cannot be directly powered. It has to be remotely");
            list.add(EnumChatFormatting.WHITE + "powered by a nearby Screen Controller.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLivingBase, itemStack);
        if (entityLivingBase instanceof EntityPlayer) {
            Achievements.trigger((EntityPlayer)entityLivingBase, Achievements.clearVision);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        ScreenTileEntity screenTileEntity;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ScreenTileEntity && (screenTileEntity = (ScreenTileEntity)te).isLarge()) {
            this.clearInvisibleBlocks(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        ScreenTileEntity screenTileEntity = (ScreenTileEntity)tileEntity;
        ScreenContainer screenContainer = new ScreenContainer(entityPlayer, screenTileEntity);
        return new GuiScreen(screenTileEntity, screenContainer);
    }

    @Override
    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new ScreenContainer(entityPlayer, (ScreenTileEntity)tileEntity);
    }
}

