/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic;

import java.util.Map;
import mcjty.entity.GenericTileEntity;
import mcjty.entity.SyncedValue;
import mcjty.rftools.blocks.BlockTools;
import mcjty.rftools.blocks.logic.SequencerMode;
import mcjty.rftools.network.Argument;
import net.minecraft.nbt.NBTTagCompound;

public class SequencerTileEntity
extends GenericTileEntity {
    public static final String CMD_MODE = "mode";
    public static final String CMD_SETBIT = "setBit";
    public static final String CMD_SETBITS = "setBits";
    public static final String CMD_SETDELAY = "setDelay";
    private SequencerMode mode = SequencerMode.MODE_ONCE1;
    private long cycleBits = 0L;
    private int currentStep = -1;
    private boolean prevIn = false;
    private int delay = 1;
    private int timer = 0;
    private SyncedValue<Boolean> redstoneOut = new SyncedValue<Boolean>(false);

    public SequencerTileEntity() {
        this.registerSyncedObject(this.redstoneOut);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
        this.timer = delay;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public SequencerMode getMode() {
        return this.mode;
    }

    public void setMode(SequencerMode mode) {
        this.mode = mode;
        switch (mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: 
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                this.currentStep = -1;
                break;
            }
            case MODE_LOOP1: 
            case MODE_LOOP2: 
            case MODE_STEP: {
                this.currentStep = 0;
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean getCycleBit(int bit) {
        return (this.cycleBits >> bit & 1L) == 1L;
    }

    public void setCycleBit(int bit, boolean flag) {
        this.cycleBits = flag ? (this.cycleBits |= 1L << bit) : (this.cycleBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setCycleBits(int start, int stop, boolean flag) {
        for (int bit = start; bit <= stop; ++bit) {
            if (flag) {
                this.cycleBits |= 1L << bit;
                continue;
            }
            this.cycleBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    protected void checkStateServer() {
        boolean newout;
        super.checkStateServer();
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean newvalue = BlockTools.getRedstoneSignalIn(meta);
        boolean pulse = newvalue && !this.prevIn;
        this.prevIn = newvalue;
        if (pulse) {
            this.handlePulse();
        }
        this.func_70296_d();
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = this.delay;
        boolean bl = newout = this.currentStep != -1 && this.getCycleBit(this.currentStep);
        if (newout != this.redstoneOut.getValue()) {
            this.redstoneOut.setValue(newout);
            this.notifyBlockUpdate();
        }
        this.handleCycle(newvalue);
    }

    private void handleCycle(boolean redstone) {
        switch (this.mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: {
                if (this.currentStep == -1) break;
                this.nextStepAndStop();
                break;
            }
            case MODE_LOOP1: {
                this.nextStep();
                break;
            }
            case MODE_LOOP2: {
                this.nextStep();
                break;
            }
            case MODE_LOOP3: {
                if (!redstone) break;
                this.nextStep();
                break;
            }
            case MODE_LOOP4: {
                if (redstone) {
                    this.nextStep();
                    break;
                }
                this.currentStep = -1;
                break;
            }
        }
    }

    private void handlePulse() {
        switch (this.mode) {
            case MODE_ONCE1: {
                if (this.currentStep != -1) break;
                this.currentStep = 0;
                break;
            }
            case MODE_ONCE2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP1: {
                break;
            }
            case MODE_LOOP2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                break;
            }
            case MODE_STEP: {
                this.nextStep();
            }
        }
    }

    private void nextStep() {
        ++this.currentStep;
        if (this.currentStep >= 64) {
            this.currentStep = 0;
        }
    }

    private void nextStepAndStop() {
        ++this.currentStep;
        if (this.currentStep >= 64) {
            this.currentStep = -1;
        }
    }

    @Override
    protected int updateMetaData(int meta) {
        meta = super.updateMetaData(meta);
        Boolean value = this.redstoneOut.getValue();
        return BlockTools.setRedstoneSignalOut(meta, value == null ? false : value);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.redstoneOut.setValue(tagCompound.func_74767_n("rs"));
        this.currentStep = tagCompound.func_74762_e("step");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.timer = tagCompound.func_74762_e("timer");
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.cycleBits = tagCompound.func_74763_f("bits");
        int m = tagCompound.func_74762_e(CMD_MODE);
        this.mode = SequencerMode.values()[m];
        this.delay = tagCompound.func_74762_e("delay");
        if (this.delay == 0) {
            this.delay = 1;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        Boolean value = this.redstoneOut.getValue();
        tagCompound.func_74757_a("rs", value == null ? false : value);
        tagCompound.func_74768_a("step", this.currentStep);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74768_a("timer", this.timer);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74772_a("bits", this.cycleBits);
        tagCompound.func_74768_a(CMD_MODE, this.mode.ordinal());
        tagCompound.func_74768_a("delay", this.delay);
    }

    @Override
    public boolean execute(String command, Map<String, Argument> args) {
        boolean rc = super.execute(command, args);
        if (rc) {
            return true;
        }
        if (CMD_MODE.equals(command)) {
            String m = args.get(CMD_MODE).getString();
            this.setMode(SequencerMode.getMode(m));
            return true;
        }
        if (CMD_SETBIT.equals(command)) {
            this.setCycleBit(args.get("bit").getInteger(), args.get("choice").getBoolean());
            return true;
        }
        if (CMD_SETBITS.equals(command)) {
            this.setCycleBits(args.get("start").getInteger(), args.get("stop").getInteger(), args.get("choice").getBoolean());
            return true;
        }
        if (CMD_SETDELAY.equals(command)) {
            this.setDelay(args.get("delay").getInteger());
            return true;
        }
        return false;
    }
}

