/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.infuser;

import mcjty.api.Infusable;
import mcjty.container.InventoryHelper;
import mcjty.entity.GenericEnergyReceiverTileEntity;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.infuser.MachineInfuserContainer;
import mcjty.rftools.items.ModItems;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineInfuserTileEntity
extends GenericEnergyReceiverTileEntity
implements ISidedInventory {
    private InventoryHelper inventoryHelper = new InventoryHelper(this, MachineInfuserContainer.factory, 2);
    private int infusing = 0;

    public MachineInfuserTileEntity() {
        super(DimletConfiguration.INFUSER_MAXENERGY, DimletConfiguration.INFUSER_RECEIVEPERTICK);
    }

    @Override
    protected void checkStateServer() {
        if (this.infusing > 0) {
            --this.infusing;
            if (this.infusing == 0) {
                ItemStack outputStack = this.inventoryHelper.getStacks()[1];
                this.finishInfusing(outputStack);
            }
            this.func_70296_d();
        } else {
            ItemStack inputStack = this.inventoryHelper.getStacks()[0];
            ItemStack outputStack = this.inventoryHelper.getStacks()[1];
            if (inputStack != null && inputStack.func_77973_b() == ModItems.dimensionalShard && this.isInfusable(outputStack)) {
                this.startInfusing();
            }
        }
    }

    private boolean isInfusable(ItemStack stack) {
        NBTTagCompound tagCompound = this.getTagCompound(stack);
        if (tagCompound == null) {
            return false;
        }
        int infused = tagCompound.func_74762_e("infused");
        return infused < DimletConfiguration.maxInfuse;
    }

    private NBTTagCompound getTagCompound(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.field_77994_a != 1) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return null;
        }
        Block block = ((ItemBlock)item).field_150939_a;
        if (!(block instanceof Infusable)) {
            return null;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new NBTTagCompound();
        }
        return tagCompound;
    }

    private void finishInfusing(ItemStack stack) {
        NBTTagCompound tagCompound = this.getTagCompound(stack);
        if (tagCompound == null) {
            return;
        }
        int infused = tagCompound.func_74762_e("infused");
        tagCompound.func_74768_a("infused", infused + 1);
        stack.func_77982_d(tagCompound);
    }

    private void startInfusing() {
        int rf = DimletConfiguration.rfInfuseOperation;
        rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
        if (this.getEnergyStored(ForgeDirection.DOWN) < rf) {
            return;
        }
        this.consumeEnergy(rf);
        this.inventoryHelper.getStacks()[0].func_77979_a(1);
        if (this.inventoryHelper.getStacks()[0].field_77994_a == 0) {
            this.inventoryHelper.getStacks()[0] = null;
        }
        this.infusing = 5;
        this.func_70296_d();
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int index, ItemStack item, int side) {
        return MachineInfuserContainer.factory.isInputSlot(index) || MachineInfuserContainer.factory.isSpecificItemSlot(index);
    }

    public boolean func_102008_b(int index, ItemStack item, int side) {
        return MachineInfuserContainer.factory.isOutputSlot(index);
    }

    public int func_70302_i_() {
        return this.inventoryHelper.getStacks().length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventoryHelper.getStacks()[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public String func_145825_b() {
        return "Infuser Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound);
        this.infusing = tagCompound.func_74762_e("infusing");
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.getStacks()[i] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
    }

    @Override
    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        tagCompound.func_74768_a("infusing", this.infusing);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.inventoryHelper.getStacks().length; ++i) {
            ItemStack stack = this.inventoryHelper.getStacks()[i];
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (stack != null) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }
}

