/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental;

import java.awt.Rectangle;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.events.ValueEvent;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.ScrollableLabel;
import mcjty.gui.widgets.Slider;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerContainer;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerTileEntity;
import mcjty.rftools.network.Argument;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class GuiEnvironmentalController
extends GenericGuiContainer<EnvironmentalControllerTileEntity> {
    public static final int ENV_WIDTH = 179;
    public static final int ENV_HEIGHT = 224;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/environmentalcontroller.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private Panel toplevel;
    private TextField minyTextField;
    private TextField maxyTextField;
    private ImageChoiceLabel redstoneMode;

    public GuiEnvironmentalController(EnvironmentalControllerTileEntity environmentalControllerTileEntity, EnvironmentalControllerContainer container) {
        super(environmentalControllerTileEntity, container);
        this.field_146999_f = 179;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout(new PositionalLayout());
        int r = ((EnvironmentalControllerTileEntity)this.tileEntity).getRadius();
        if (r < 5) {
            r = 5;
        } else if (r > 100) {
            r = 100;
        }
        int miny = ((EnvironmentalControllerTileEntity)this.tileEntity).getMiny();
        int maxy = ((EnvironmentalControllerTileEntity)this.tileEntity).getMaxy();
        Panel radiusPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).setLayoutHint(new PositionalLayout.PositionalHint(25, 10, 149, 16));
        ScrollableLabel radius = ((ScrollableLabel)new ScrollableLabel(this.field_146297_k, (Gui)this).setRealMinimum(5).setRealMaximum(100).setRealValue(r).setDesiredWidth(24)).addValueEvent(new ValueEvent(){

            @Override
            public void valueChanged(Widget parent, int newValue) {
                GuiEnvironmentalController.this.sendServerCommand("setRadius", new Argument[]{new Argument("radius", newValue)});
            }
        });
        Slider slider = new Slider(this.field_146297_k, (Gui)this).setHorizontal().setScrollable(radius);
        ((Panel)((Panel)radiusPanel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Radius:"))).addChild(slider)).addChild(radius);
        Panel minPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).setLayoutHint(new PositionalLayout.PositionalHint(25, 30, 149, 16));
        this.minyTextField = new TextField(this.field_146297_k, (Gui)this).setText(Integer.toString(miny)).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                GuiEnvironmentalController.this.sendBounds(true);
            }
        });
        ((Panel)minPanel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Minimum height:"))).addChild(this.minyTextField);
        Panel maxPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).setLayoutHint(new PositionalLayout.PositionalHint(25, 50, 149, 16));
        this.maxyTextField = new TextField(this.field_146297_k, (Gui)this).setText(Integer.toString(maxy)).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                GuiEnvironmentalController.this.sendBounds(false);
            }
        });
        ((Panel)maxPanel.addChild((Widget)new Label(this.field_146297_k, (Gui)this).setText("Maximum height:"))).addChild(this.maxyTextField);
        this.initRedstoneMode();
        ((Panel)((Panel)((Panel)this.toplevel.addChild(radiusPanel)).addChild(minPanel)).addChild(maxPanel)).addChild(this.redstoneMode);
        this.toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, this.toplevel);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiEnvironmentalController.this.changeRedstoneMode();
            }
        }).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint(new PositionalLayout.PositionalHint(152, 118, 16, 16));
        this.redstoneMode.setCurrentChoice(((EnvironmentalControllerTileEntity)this.tileEntity).getRedstoneMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((EnvironmentalControllerTileEntity)this.tileEntity).setRedstoneMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoice()]);
        this.sendServerCommand("rsMode", new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoice()].getDescription()));
    }

    private void sendBounds(boolean minchanged) {
        int maxy;
        int miny;
        try {
            miny = Integer.parseInt(this.minyTextField.getText());
        }
        catch (NumberFormatException e) {
            miny = 0;
        }
        try {
            maxy = Integer.parseInt(this.maxyTextField.getText());
        }
        catch (NumberFormatException e) {
            maxy = 0;
        }
        if (minchanged) {
            if (miny > maxy) {
                maxy = miny;
                this.maxyTextField.setText(Integer.toString(maxy));
            }
        } else if (miny > maxy) {
            miny = maxy;
            this.minyTextField.setText(Integer.toString(miny));
        }
        this.sendServerCommand("setBounds", new Argument("miny", miny), new Argument("maxy", maxy));
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.window.draw();
    }
}

