/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import mcjty.varia.Coordinate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class EndergenicPearl {
    private int ticksLeft;
    private final Coordinate destination;
    private final int age;

    public EndergenicPearl(int ticksLeft, Coordinate destination, int age) {
        this.ticksLeft = ticksLeft;
        this.destination = destination;
        this.age = age;
    }

    public EndergenicPearl(NBTTagCompound tagCompound) {
        this.ticksLeft = tagCompound.func_74762_e("t");
        this.destination = Coordinate.readFromNBT(tagCompound, "dest");
        this.age = tagCompound.func_74762_e("age");
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public int getAge() {
        return this.age;
    }

    public Coordinate getDestination() {
        return this.destination;
    }

    public boolean handleTick(World world) {
        --this.ticksLeft;
        if (this.ticksLeft <= 0) {
            TileEntity te = world.func_147438_o(this.destination.getX(), this.destination.getY(), this.destination.getZ());
            if (te instanceof EndergenicTileEntity) {
                EndergenicTileEntity endergenicTileEntity = (EndergenicTileEntity)te;
                endergenicTileEntity.receivePearl(this.age);
            } else {
                RFTools.log("Pearl: where did the destination go?");
            }
            return true;
        }
        return false;
    }

    public NBTTagCompound getTagCompound() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("t", this.ticksLeft);
        Coordinate.writeToNBT(tagCompound, "dest", this.destination);
        tagCompound.func_74768_a("age", this.age);
        return tagCompound;
    }
}

