/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.network.PacketHandler;
import mcjty.rftools.network.PacketSendBuffsToClient;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerExtendedProperties
implements IExtendedEntityProperties {
    public static final String ID = "RFToolsPlayerProperties";
    public static final int BUFF_MAXTICKS = 180;
    private int buffTimeout = 0;
    private int target = -1;
    private int teleportTimeout = -1;
    private Entity entity = null;
    private boolean globalSyncNeeded = true;
    private Set<GlobalCoordinate> favoriteDestinations = new HashSet<GlobalCoordinate>();
    private boolean oldAllowFlying = false;
    private boolean allowFlying = false;
    private final Map<PlayerBuff, Integer> buffs = new HashMap<PlayerBuff, Integer>();

    public boolean isTeleporting() {
        return this.target != -1 && this.teleportTimeout >= 0;
    }

    private void syncBuffs() {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketSendBuffsToClient(this.buffs), (EntityPlayerMP)this.entity);
    }

    private void performBuffs() {
        EntityPlayer player = (EntityPlayer)this.entity;
        boolean enableFlight = false;
        for (PlayerBuff buff : this.buffs.keySet()) {
            if (buff != PlayerBuff.BUFF_FLIGHT) continue;
            enableFlight = true;
        }
        boolean oldAllow = player.field_71075_bZ.field_75101_c;
        if (enableFlight) {
            if (!this.allowFlying) {
                this.oldAllowFlying = player.field_71075_bZ.field_75101_c;
                this.allowFlying = true;
            }
            player.field_71075_bZ.field_75101_c = true;
        } else if (this.allowFlying) {
            player.field_71075_bZ.field_75101_c = this.oldAllowFlying;
            if (player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75101_c = true;
            }
            this.allowFlying = false;
        }
        if (player.field_71075_bZ.field_75101_c != oldAllow) {
            if (!player.field_71075_bZ.field_75101_c) {
                player.field_71075_bZ.field_75100_b = false;
            }
            player.func_71016_p();
        }
    }

    public static PlayerExtendedProperties getProperties(EntityPlayer player) {
        IExtendedEntityProperties properties = player.getExtendedProperties(ID);
        return (PlayerExtendedProperties)properties;
    }

    public static void addBuff(EntityPlayer player, PlayerBuff buff, int ticks) {
        PlayerExtendedProperties playerExtendedProperties = PlayerExtendedProperties.getProperties(player);
        playerExtendedProperties.addBuff(buff, ticks);
    }

    public void addBuff(PlayerBuff buff, int ticks) {
        this.buffs.put(buff, ticks + 5);
        this.syncBuffs();
        this.performBuffs();
    }

    public Map<PlayerBuff, Integer> getBuffs() {
        return this.buffs;
    }

    public boolean hasBuff(PlayerBuff buff) {
        return this.buffs.containsKey((Object)buff);
    }

    public boolean isDestinationFavorite(GlobalCoordinate coordinate) {
        return this.favoriteDestinations.contains(coordinate);
    }

    public void setDestinationFavorite(GlobalCoordinate coordinate, boolean favorite) {
        if (favorite) {
            this.favoriteDestinations.add(coordinate);
        } else {
            this.favoriteDestinations.remove(coordinate);
        }
    }

    public void startTeleport(int target, int ticks) {
        this.target = target;
        this.teleportTimeout = ticks;
    }

    public void tick() {
        this.tickTeleport();
        this.tickBuffs();
    }

    private void tickBuffs() {
        --this.buffTimeout;
        if (this.buffTimeout <= 0) {
            this.buffTimeout = 180;
            HashMap<PlayerBuff, Integer> copyBuffs = new HashMap<PlayerBuff, Integer>(this.buffs);
            this.buffs.clear();
            boolean syncNeeded = false;
            for (Map.Entry entry : copyBuffs.entrySet()) {
                int timeout = (Integer)entry.getValue();
                if ((timeout -= 180) > 0) {
                    this.buffs.put((PlayerBuff)((Object)entry.getKey()), timeout);
                    continue;
                }
                syncNeeded = true;
            }
            if (syncNeeded) {
                this.syncBuffs();
                this.performBuffs();
                this.globalSyncNeeded = false;
            }
        }
        if (this.globalSyncNeeded) {
            this.globalSyncNeeded = false;
            this.syncBuffs();
            this.performBuffs();
        }
    }

    private void tickTeleport() {
        if (this.teleportTimeout < 0) {
            return;
        }
        --this.teleportTimeout;
        if (this.teleportTimeout <= 0) {
            EntityPlayer player = (EntityPlayer)this.entity;
            TeleportDestinations destinations = TeleportDestinations.getDestinations(this.entity.field_70170_p);
            GlobalCoordinate coordinate = destinations.getCoordinateForId(this.target);
            if (coordinate == null) {
                RFTools.message(player, EnumChatFormatting.RED + "Something went wrong! The target has disappeared!");
                TeleportationTools.applyEffectForSeverity(player, 3, false);
                return;
            }
            TeleportDestination destination = destinations.getDestination(coordinate);
            TeleportationTools.performTeleport((EntityPlayer)this.entity, destination, 0, 10, false);
            this.teleportTimeout = -1;
            this.target = -1;
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74768_a("target", this.target);
        compound.func_74768_a("ticks", this.teleportTimeout);
        compound.func_74768_a("buffTicks", this.buffTimeout);
        compound.func_74757_a("allowFlying", this.allowFlying);
        compound.func_74757_a("oldAllowFlying", this.oldAllowFlying);
        int[] buffArray = new int[this.buffs.size()];
        int[] timeoutArray = new int[this.buffs.size()];
        int idx = 0;
        for (Map.Entry<PlayerBuff, Integer> entry : this.buffs.entrySet()) {
            PlayerBuff buff = entry.getKey();
            buffArray[idx] = buff.ordinal();
            timeoutArray[idx] = entry.getValue();
            ++idx;
        }
        compound.func_74783_a("buffs", buffArray);
        compound.func_74783_a("buffTimeouts", timeoutArray);
        PlayerExtendedProperties.writeFavoritesToNBT(compound, this.favoriteDestinations);
    }

    private static void writeFavoritesToNBT(NBTTagCompound tagCompound, Collection<GlobalCoordinate> destinations) {
        NBTTagList lst = new NBTTagList();
        for (GlobalCoordinate destination : destinations) {
            NBTTagCompound tc = new NBTTagCompound();
            Coordinate c = destination.getCoordinate();
            tc.func_74768_a("x", c.getX());
            tc.func_74768_a("y", c.getY());
            tc.func_74768_a("z", c.getZ());
            tc.func_74768_a("dim", destination.getDimension());
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("destinations", (NBTBase)lst);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.target = compound.func_74764_b("target") ? compound.func_74762_e("target") : -1;
        this.teleportTimeout = compound.func_74764_b("ticks") ? compound.func_74762_e("ticks") : -1;
        this.buffTimeout = compound.func_74762_e("buffTicks");
        int[] buffArray = compound.func_74759_k("buffs");
        int[] timeoutArray = compound.func_74759_k("buffTimeouts");
        this.buffs.clear();
        for (int i = 0; i < buffArray.length; ++i) {
            int buffIdx = buffArray[i];
            this.buffs.put(PlayerBuff.values()[buffIdx], timeoutArray[i]);
        }
        this.allowFlying = compound.func_74767_n("allowFlying");
        this.oldAllowFlying = compound.func_74767_n("oldAllowFlying");
        this.globalSyncNeeded = true;
        this.favoriteDestinations.clear();
        PlayerExtendedProperties.readCoordinatesFromNBT(compound, this.favoriteDestinations);
    }

    private static void readCoordinatesFromNBT(NBTTagCompound tagCompound, Set<GlobalCoordinate> destinations) {
        NBTTagList lst = tagCompound.func_150295_c("destinations", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            Coordinate c = new Coordinate(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
            destinations.add(new GlobalCoordinate(c, tc.func_74762_e("dim")));
        }
    }

    public void init(Entity entity, World world) {
        this.entity = entity;
        this.globalSyncNeeded = true;
    }
}

