/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import mcjty.rftools.BedControl;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.PlayerExtendedProperties;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.dimlets.DimletConfiguration;
import mcjty.rftools.blocks.environmental.PeacefulAreaManager;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import mcjty.varia.Coordinate;
import mcjty.varia.GlobalCoordinate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ForgeEventHandlers {
    @SubscribeEvent
    public void onAttackEntityEvent(AttackEntityEvent event) {
        DimensionStorage storage;
        int energy;
        World world = event.entityPlayer.func_130014_f_();
        int id = world.field_73011_w.field_76574_g;
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        if (dimensionManager.getDimensionInformation(id) != null && (energy = (storage = DimensionStorage.getDimensionStorage(world)).getEnergyLevel(id)) <= 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityConstructingEvent(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            PlayerExtendedProperties properties = new PlayerExtendedProperties();
            event.entity.registerExtendedProperties("RFToolsPlayerProperties", (IExtendedEntityProperties)properties);
        }
    }

    @SubscribeEvent
    public void onPlayerInterractEvent(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            RfToolsDimensionManager dimensionManager;
            Block block;
            World world = event.world;
            if (!world.field_72995_K && (block = world.func_147439_a(event.x, event.y, event.z)) instanceof BlockBed && (dimensionManager = RfToolsDimensionManager.getDimensionManager(world)).getDimensionInformation(world.field_73011_w.field_76574_g) != null) {
                switch (DimletConfiguration.bedBehaviour) {
                    case 0: {
                        event.setCanceled(true);
                        RFTools.message(event.entityPlayer, "You cannot sleep in this dimension!");
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        event.setCanceled(true);
                        int meta = BedControl.getBedMeta(world, event.x, event.y, event.z);
                        if (meta == -1) break;
                        BedControl.trySleep(world, event.entityPlayer, event.x, event.y, event.z, meta);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        Coordinate coordinate;
        DimensionStorage storage;
        int energy;
        RfToolsDimensionManager dimensionManager;
        World world = event.world;
        int id = world.field_73011_w.field_76574_g;
        if (DimletConfiguration.preventSpawnUnpowered && (dimensionManager = RfToolsDimensionManager.getDimensionManager(world)).getDimensionInformation(id) != null && (energy = (storage = DimensionStorage.getDimensionStorage(world)).getEnergyLevel(id)) <= 0) {
            event.setResult(Event.Result.DENY);
            RFTools.logDebug("Dimension power low: Prevented a spawn of " + event.entity.getClass().getName());
        }
        if (event.entity instanceof IMob && PeacefulAreaManager.isPeaceful(new GlobalCoordinate(coordinate = new Coordinate((int)event.entity.field_70165_t, (int)event.entity.field_70163_u, (int)event.entity.field_70161_v), id))) {
            event.setResult(Event.Result.DENY);
            RFTools.logDebug("Peaceful manager: Prevented a spawn of " + event.entity.getClass().getName());
        }
    }

    @SubscribeEvent
    public void onLivingFallEvent(LivingFallEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            PlayerExtendedProperties playerExtendedProperties = PlayerExtendedProperties.getProperties(player);
            if (!player.field_70170_p.field_72995_K) {
                if (playerExtendedProperties.hasBuff(PlayerBuff.BUFF_FEATHERFALLING)) {
                    event.distance /= 2.0f;
                } else if (playerExtendedProperties.hasBuff(PlayerBuff.BUFF_FEATHERFALLINGPLUS)) {
                    event.distance /= 8.0f;
                }
            }
        }
    }
}

