/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.gui.RenderHelper;
import mcjty.gui.Window;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.Widget;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TextPage
extends AbstractWidget<TextPage> {
    private final List<Page> pages = new ArrayList<Page>();
    private final Map<String, Integer> nodes = new HashMap<String, Integer>();
    private int pageIndex = 0;
    private final List<Line> lines = new ArrayList<Line>();
    private final List<Link> links = new ArrayList<Link>();
    private ResourceLocation arrowImage = null;
    private int arrowU;
    private int arrowV;
    private ResourceLocation craftingGridImage = null;
    private int craftU;
    private int craftV;
    private int tabCounter = 0;

    public TextPage(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public TextPage setArrowImage(ResourceLocation image, int u, int v) {
        this.arrowImage = image;
        this.arrowU = u;
        this.arrowV = v;
        return this;
    }

    public TextPage setCraftingGridImage(ResourceLocation image, int u, int v) {
        this.craftingGridImage = image;
        this.craftU = u;
        this.craftV = v;
        return this;
    }

    private void setPage(Page page) {
        this.lines.clear();
        this.links.clear();
        if (!this.pages.isEmpty()) {
            int y = 3;
            int tab = 0;
            for (Line line : page.lines) {
                this.lines.add(line);
                if (line.isNexttab()) {
                    y = 3;
                    ++tab;
                } else if (line.isLink()) {
                    this.links.add(new Link(tab, y, y + 13, line.node));
                }
                y += line.height;
            }
        }
    }

    private void newPage(Page page) {
        if (!page.isEmpty()) {
            this.pages.add(page);
        }
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public TextPage setText(ResourceLocation manualResource) {
        Page page = new Page();
        try {
            IResourceManager resourceManager = this.mc.func_110442_L();
            IResource iresource = resourceManager.func_110536_a(manualResource);
            InputStream inputstream = iresource.func_110527_b();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("{------")) {
                    this.newPage(page);
                    page = new Page();
                } else {
                    Line l = page.addLine(line);
                    if (l.isNode()) {
                        this.nodes.put(l.node, this.pages.size());
                    }
                }
                line = br.readLine();
            }
            this.newPage(page);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.showCurrentPage();
        return this;
    }

    public void prevPage() {
        --this.pageIndex;
        if (this.pageIndex < 0) {
            this.pageIndex = 0;
        }
        this.showCurrentPage();
    }

    public void nextPage() {
        ++this.pageIndex;
        if (this.pageIndex >= this.pages.size()) {
            this.pageIndex = this.pages.size() - 1;
        }
        this.showCurrentPage();
    }

    private void showCurrentPage() {
        this.setPage(this.pages.get(this.pageIndex));
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        if (this.isEnabledAndVisible()) {
            window.setTextFocus(this);
            for (Link link : this.links) {
                int t;
                if (this.tabCounter == 0) {
                    if (link.y1 > y || y > link.y2 || !this.gotoLink(link)) continue;
                    return this;
                }
                int n = t = x < this.getBounds().width / 2 ? 0 : 1;
                if (link.y1 > y || y > link.y2 || link.tab != t || !this.gotoLink(link)) continue;
                return this;
            }
            return this;
        }
        return null;
    }

    private boolean gotoLink(Link link) {
        Integer page = this.nodes.get(link.node);
        if (page != null) {
            this.pageIndex = page;
            this.showCurrentPage();
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(Window window, char typedChar, int keyCode) {
        boolean rc = super.keyTyped(window, typedChar, keyCode);
        if (rc) {
            return true;
        }
        if (this.isEnabledAndVisible()) {
            if (keyCode == 14 || keyCode == 203) {
                this.prevPage();
                return true;
            }
            if (keyCode == 57 || keyCode == 205) {
                this.nextPage();
                return true;
            }
            if (keyCode == 199) {
                this.pageIndex = 0;
                this.showCurrentPage();
            } else if (keyCode == 207 && !this.pages.isEmpty()) {
                this.pageIndex = this.pages.size() - 1;
                this.showCurrentPage();
            }
        }
        return false;
    }

    @Override
    public void draw(Window window, int x, int y) {
        super.draw(window, x, y);
        this.tabCounter = 0;
        int starty = y += 3;
        for (Line line : this.lines) {
            if (line.isNexttab()) {
                y = starty;
                x += this.getBounds().width / 2;
                ++this.tabCounter;
            } else if (line.recipe != null) {
                y += 4;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ShapedRecipes shapedRecipes = (ShapedRecipes)line.recipe;
                if (this.craftingGridImage != null) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.mc.func_110434_K().func_110577_a(this.craftingGridImage);
                    this.gui.func_73729_b(25 + x, y, this.craftU, this.craftV, 57, 57);
                }
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (i >= shapedRecipes.field_77576_b || j >= shapedRecipes.field_77577_c) continue;
                        RenderHelper.renderObject(this.mc, 26 + x + i * 18, 1 + y + j * 18, shapedRecipes.field_77574_d[i + j * 3], false);
                    }
                }
                if (this.arrowImage != null) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.mc.func_110434_K().func_110577_a(this.arrowImage);
                    this.gui.func_73729_b(x + 25 + 67, y + 18, this.arrowU, this.arrowV, 16, 16);
                }
                if (this.craftingGridImage != null) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.mc.func_110434_K().func_110577_a(this.craftingGridImage);
                    this.gui.func_73729_b(x + 25 + 92, y + 16, this.craftU, this.craftV, 18, 18);
                }
                RenderHelper.renderObject(this.mc, x + 25 + 93, y + 17, shapedRecipes.func_77571_b(), false);
                y -= 4;
            } else if (line.line != null) {
                char c;
                String s = "";
                int col = -16777216;
                int dx = 0;
                if (line.isBold()) {
                    c = '\u00a7';
                    s = Character.toString(c) + "l";
                }
                if (line.isLink()) {
                    c = '\u00a7';
                    s = Character.toString(c) + "n";
                    col = -16760662;
                    dx = 25;
                }
                s = s + line.line;
                this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(s, this.bounds.width - dx), x + dx + this.bounds.x, y + this.bounds.y, col);
            }
            y += line.height;
        }
    }

    private static IRecipe findRecipe(ItemStack item) {
        if (item == null) {
            return null;
        }
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            ItemStack recipeOutput;
            if (!(recipe instanceof ShapedRecipes) || (recipeOutput = recipe.func_77571_b()) == null || !recipeOutput.func_77969_a(item)) continue;
            return recipe;
        }
        return null;
    }

    public static class Link {
        final int tab;
        final int y1;
        final int y2;
        final String node;

        public Link(int tab, int y1, int y2, String node) {
            this.tab = tab;
            this.y1 = y1;
            this.y2 = y2;
            this.node = node;
        }
    }

    public static class Page {
        final List<Line> lines = new ArrayList<Line>();

        public boolean isEmpty() {
            return this.lines.isEmpty();
        }

        public Line addLine(String line) {
            Line l = new Line(line);
            this.lines.add(l);
            return l;
        }
    }

    private static class Line {
        private boolean bold = false;
        private boolean islink = false;
        private boolean isnode;
        private boolean nexttab = false;
        String node = null;
        String line = null;
        IRecipe recipe = null;
        int height = 14;

        public boolean isBold() {
            return this.bold;
        }

        public boolean isLink() {
            return this.islink;
        }

        public boolean isNode() {
            return this.isnode;
        }

        public boolean isNexttab() {
            return this.nexttab;
        }

        Line(String line) {
            if (line.startsWith("{b}")) {
                this.bold = true;
                this.line = line.substring(3);
            } else if (line.startsWith("{/}")) {
                this.nexttab = true;
                this.height = 0;
            } else if (line.startsWith("{n:")) {
                int end = line.indexOf(125);
                if (end == -1) {
                    this.line = line;
                } else {
                    this.node = line.substring(3, end);
                    this.isnode = true;
                    this.line = null;
                }
                this.height = 0;
            } else if (line.startsWith("{l:")) {
                int end = line.indexOf(125);
                if (end == -1) {
                    this.line = line;
                } else {
                    this.node = line.substring(3, end);
                    this.islink = true;
                    this.line = line.substring(end + 1);
                }
            } else if (line.startsWith("{ri:")) {
                int end = line.indexOf(125);
                if (end == -1) {
                    this.line = line;
                } else {
                    Item item = GameRegistry.findItem((String)"rftools", (String)line.substring(4, end));
                    this.recipe = TextPage.findRecipe(new ItemStack(item));
                    if (this.recipe == null) {
                        this.line = line;
                    } else if (!(this.recipe instanceof ShapedRecipes)) {
                        this.recipe = null;
                        this.line = line;
                    } else {
                        this.height = 62;
                    }
                }
            } else if (line.startsWith("{rb:")) {
                int end = line.indexOf(125);
                if (end == -1) {
                    this.line = line;
                } else {
                    Block block = GameRegistry.findBlock((String)"rftools", (String)line.substring(4, end));
                    this.recipe = TextPage.findRecipe(new ItemStack(block));
                    if (this.recipe == null) {
                        this.line = line;
                    } else {
                        this.height = 62;
                    }
                }
            } else {
                this.line = line;
            }
        }
    }
}

