/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import mcjty.gui.RenderHelper;
import mcjty.gui.Scrollable;
import mcjty.gui.Window;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class Slider
extends AbstractWidget<Slider> {
    private boolean dragging = false;
    private int dx;
    private int dy;
    private boolean horizontal = false;
    private Scrollable scrollable;

    public Slider(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public Scrollable getScrollable() {
        return this.scrollable;
    }

    public Slider setScrollable(Scrollable scrollable) {
        this.scrollable = scrollable;
        return this;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public boolean isVertical() {
        return !this.horizontal;
    }

    public Slider setHorizontal() {
        this.horizontal = true;
        return this;
    }

    public Slider setVertical() {
        this.horizontal = false;
        return this;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        Gui.func_73734_a((int)xx, (int)yy, (int)(xx + this.bounds.width - 1), (int)(yy + this.bounds.height - 1), (int)-16777216);
        int divider = this.scrollable.getMaximum() - this.scrollable.getCountSelected();
        if (this.horizontal) {
            int size = this.calculateKnobSize(divider, this.bounds.width);
            int first = this.calculateKnobOffset(divider, size, this.bounds.width);
            RenderHelper.drawBeveledBox(xx + 2 + first, yy + 2, xx + 2 + first + size - 1, yy + this.bounds.height - 4, -1118482, -13421773, -10066330);
        } else {
            int size = this.calculateKnobSize(divider, this.bounds.height);
            int first = this.calculateKnobOffset(divider, size, this.bounds.height);
            RenderHelper.drawBeveledBox(xx + 2, yy + 2 + first, xx + this.bounds.width - 3, yy + 2 + first + size - 1, -1118482, -13421773, -10066330);
        }
    }

    private int calculateKnobOffset(int divider, int size, int boundsSize) {
        int first = divider <= 0 ? 0 : this.scrollable.getFirstSelected() * (boundsSize - 4 - size) / divider;
        return first;
    }

    private int calculateKnobSize(int divider, int boundsSize) {
        int size = divider <= 0 ? boundsSize - 4 : this.scrollable.getCountSelected() * (boundsSize - 4) / this.scrollable.getMaximum();
        if (size < 4) {
            size = 4;
        }
        return size;
    }

    private void updateScrollable(int x, int y) {
        int first;
        int divider = this.scrollable.getMaximum() - this.scrollable.getCountSelected();
        if (divider <= 0) {
            first = 0;
        } else if (this.horizontal) {
            int size = this.calculateKnobSize(divider, this.bounds.width);
            first = (x - this.bounds.x - this.dx) * divider / (this.bounds.width - 4 - size);
        } else {
            int size = this.calculateKnobSize(divider, this.bounds.height);
            first = (y - this.bounds.y - this.dy) * divider / (this.bounds.height - 4 - size);
        }
        if (first > divider) {
            first = divider;
        }
        if (first < 0) {
            first = 0;
        }
        this.scrollable.setFirstSelected(first);
    }

    @Override
    public Widget mouseClick(Window window, int x, int y, int button) {
        super.mouseClick(window, x, y, button);
        this.dragging = true;
        int divider = this.scrollable.getMaximum() - this.scrollable.getCountSelected();
        if (this.horizontal) {
            int size = this.calculateKnobSize(divider, this.bounds.width);
            int first = this.calculateKnobOffset(divider, size, this.bounds.width);
            this.dx = x - this.bounds.x - first;
            this.dy = 0;
        } else {
            int size = this.calculateKnobSize(divider, this.bounds.height);
            int first = this.calculateKnobOffset(divider, size, this.bounds.height);
            this.dx = 0;
            this.dy = y - this.bounds.y - first;
        }
        return this;
    }

    @Override
    public void mouseRelease(int x, int y, int button) {
        super.mouseRelease(x, y, button);
        if (this.dragging) {
            this.updateScrollable(x, y);
            this.dragging = false;
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        super.mouseMove(x, y);
        if (this.dragging) {
            this.updateScrollable(x, y);
        }
    }
}

