/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import mcjty.gui.Window;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.VerticalAlignment;
import mcjty.gui.widgets.AbstractWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class Label<P extends Label>
extends AbstractWidget<P> {
    private String text;
    private int color = -16777216;
    private int disabledColor = -11184811;
    private HorizontalAlignment horizontalAlignment = HorizontalAlignment.ALIGN_CENTER;
    private VerticalAlignment verticalAlignment = VerticalAlignment.ALIGN_CENTER;
    private boolean dynamic = false;

    public Label(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public P setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return (P)this;
    }

    @Override
    public int getDesiredWidth() {
        int w = super.getDesiredWidth();
        if (this.dynamic) {
            return w;
        }
        if (w == -1) {
            w = this.mc.field_71466_p.func_78256_a(this.text) + 6;
        }
        return w;
    }

    @Override
    public int getDesiredHeight() {
        int h = super.getDesiredHeight();
        if (this.dynamic) {
            return h;
        }
        if (h == -1) {
            h = this.mc.field_71466_p.field_78288_b + 2;
        }
        return h;
    }

    public String getText() {
        return this.text;
    }

    public P setText(String text) {
        this.text = text;
        return (P)this;
    }

    public int getColor() {
        return this.color;
    }

    public P setColor(int color) {
        this.color = color;
        return (P)this;
    }

    public int getDisabledColor() {
        return this.disabledColor;
    }

    public P setDisabledColor(int disabledColor) {
        this.disabledColor = disabledColor;
        return (P)this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public P setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return (P)this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public P setVerticalAlignment(VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return (P)this;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        int dx = this.calculateHorizontalOffset();
        int dy = this.calculateVerticalOffset();
        int col = this.color;
        if (!this.isEnabled()) {
            col = this.disabledColor;
        }
        if (this.text == null) {
            this.mc.field_71466_p.func_78276_b("", x + dx + this.bounds.x, y + dy + this.bounds.y, col);
        } else {
            this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(this.text, this.bounds.width), x + dx + this.bounds.x, y + dy + this.bounds.y, col);
        }
    }

    private int calculateVerticalOffset() {
        if (this.verticalAlignment != VerticalAlignment.ALIGN_TOP) {
            int h = this.mc.field_71466_p.field_78288_b;
            if (this.verticalAlignment == VerticalAlignment.ALIGN_BOTTOM) {
                return this.bounds.height - h;
            }
            return (this.bounds.height - h) / 2;
        }
        return 0;
    }

    private int calculateHorizontalOffset() {
        if (this.horizontalAlignment != HorizontalAlignment.ALIGH_LEFT) {
            int w = this.mc.field_71466_p.func_78256_a(this.text);
            if (this.horizontalAlignment == HorizontalAlignment.ALIGN_RIGHT) {
                return this.bounds.width - w;
            }
            return (this.bounds.width - w) / 2;
        }
        return 0;
    }
}

