/*
 * Decompiled with CFR 0.152.
 */
package mcjty.gui.widgets;

import cofh.api.energy.IEnergyHandler;
import java.util.ArrayList;
import java.util.List;
import mcjty.gui.RenderHelper;
import mcjty.gui.Window;
import mcjty.gui.widgets.AbstractWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyBar
extends AbstractWidget<EnergyBar> {
    private int value;
    private int maxValue;
    private int color = -16777216;
    private int leftColor = -65536;
    private int rightColor = -11206656;
    private boolean horizontal = false;
    private IEnergyHandler handler = null;
    private boolean showText = true;
    private boolean showRfPerTick = false;
    private int rfPerTick = 0;

    public EnergyBar(Minecraft mc, Gui gui) {
        super(mc, gui);
    }

    public EnergyBar setHorizontal() {
        this.horizontal = true;
        return this;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public EnergyBar setHandler(IEnergyHandler handler) {
        this.handler = handler;
        return this;
    }

    public IEnergyHandler getHandler() {
        return this.handler;
    }

    public EnergyBar setVertical() {
        this.horizontal = false;
        return this;
    }

    public boolean isVertical() {
        return !this.horizontal;
    }

    @Override
    public List<String> getTooltips() {
        if (this.tooltips == null) {
            String s = this.getValue() + " / " + this.getMaxValue();
            ArrayList<String> tt = new ArrayList<String>();
            tt.add(s);
            return tt;
        }
        return this.tooltips;
    }

    public boolean isShowText() {
        return this.showText;
    }

    public EnergyBar setShowText(boolean showText) {
        this.showText = showText;
        return this;
    }

    public boolean isShowRfPerTick() {
        return this.showRfPerTick;
    }

    public EnergyBar setShowRfPerTick(boolean showRfPerTick) {
        this.showRfPerTick = showRfPerTick;
        return this;
    }

    public int getRfPerTick() {
        return this.rfPerTick;
    }

    public EnergyBar setRfPerTick(int rfPerTick) {
        this.rfPerTick = rfPerTick;
        return this;
    }

    public int getValue() {
        if (this.handler != null) {
            return this.handler.getEnergyStored(ForgeDirection.DOWN);
        }
        return this.value;
    }

    public EnergyBar setValue(int value) {
        this.value = value;
        return this;
    }

    public int getMaxValue() {
        if (this.handler != null) {
            return this.handler.getMaxEnergyStored(ForgeDirection.DOWN);
        }
        return this.maxValue;
    }

    public EnergyBar setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public EnergyBar setColor(int color) {
        this.color = color;
        return this;
    }

    public int getColor1() {
        return this.leftColor;
    }

    public EnergyBar setColor1(int leftColor) {
        this.leftColor = leftColor;
        return this;
    }

    public int getColor2() {
        return this.rightColor;
    }

    public EnergyBar setColor2(int rightColor) {
        this.rightColor = rightColor;
        return this;
    }

    @Override
    public void draw(Window window, int x, int y) {
        if (!this.visible) {
            return;
        }
        super.draw(window, x, y);
        int currentValue = this.getValue();
        int maximum = this.getMaxValue();
        if (maximum > 0) {
            int w = 0;
            if (this.horizontal) {
                w = (int)((float)this.bounds.width * (float)currentValue / (float)maximum);
                RenderHelper.drawHorizontalGradientRect(x + this.bounds.x, y + this.bounds.y, x + this.bounds.x + w, y + this.bounds.y + this.bounds.height - 1, this.leftColor, this.rightColor);
            } else {
                w = (int)((float)this.bounds.height * (float)currentValue / (float)maximum);
                RenderHelper.drawVerticalGradientRect(x + this.bounds.x, y + this.bounds.y + this.bounds.height - w, x + this.bounds.x + this.bounds.width - 1, y + this.bounds.y + this.bounds.height, this.leftColor, this.rightColor);
            }
        }
        if (this.showText) {
            String s = this.showRfPerTick ? this.rfPerTick + "RF/t" : currentValue + "/" + maximum;
            this.mc.field_71466_p.func_78276_b(this.mc.field_71466_p.func_78269_a(s, this.getBounds().width), x + this.bounds.x, y + this.bounds.y + (this.bounds.height - this.mc.field_71466_p.field_78288_b) / 2, this.color);
        }
    }
}

