/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.startinginventory;

import bspkrs.util.CommonUtils;
import bspkrs.util.Const;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.SaveHandler;
import org.apache.logging.log4j.Level;

public class StartingInventory {
    public static final String VERSION_NUMBER = Const.MCVERSION + ".r02";
    boolean canGiveItems;
    private static String fileName = "startingInventory.txt";
    private static String configPath = "/config/";
    private static File file = new File(new File(CommonUtils.getMinecraftDir()), configPath + fileName);
    private static Scanner scan;
    private static List<ItemStack> itemsList;
    private static final String[] defaultItems;

    public static void init() {
        if (!file.exists()) {
            StartingInventory.createFile();
        } else {
            try {
                scan = new Scanner(file);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        StartingInventory.readItems();
    }

    public static boolean isPlayerNewToWorld(MinecraftServer server, EntityPlayer player) {
        SaveHandler saveHandler = (SaveHandler)server.func_71218_a(0).func_72860_G();
        File dir = new File(saveHandler.func_75765_b(), "/StartingInv");
        return !dir.exists() || !new File(dir, player.func_146103_bH().getName() + ".si").exists();
    }

    public static boolean isPlayerInventoryEmpty(InventoryPlayer inv) {
        int i;
        for (i = 0; i < inv.field_70462_a.length; ++i) {
            if (inv.field_70462_a[i] == null) continue;
            return false;
        }
        for (i = 0; i < inv.field_70460_b.length; ++i) {
            if (inv.field_70460_b[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean createPlayerFile(MinecraftServer server, EntityPlayer player) {
        SaveHandler saveHandler = (SaveHandler)server.func_71218_a(0).func_72860_G();
        File dir = new File(saveHandler.func_75765_b(), "/StartingInv");
        if (!dir.exists() && !dir.mkdir()) {
            return false;
        }
        File pFile = new File(dir, player.func_146103_bH().getName() + ".si");
        try {
            pFile.createNewFile();
            PrintWriter out = new PrintWriter(new FileWriter(pFile));
            out.println("I was here!");
            out.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean addItems(EntityPlayer player) {
        for (int i = 0; i < Math.min(player.field_71071_by.func_70302_i_(), itemsList.size()); ++i) {
            StartingInventory.addItemToInv(itemsList.get(i), player);
        }
        return true;
    }

    private static String[] parseLine(String entry) {
        String[] r = new String[]{"", "1", "0", ""};
        int d1 = entry.indexOf(44);
        int d2 = entry.indexOf(44, d1 + 1);
        int d3 = entry.indexOf(44, d2 + 1);
        if (d1 != -1) {
            r[0] = entry.substring(0, d1);
            if (d2 != -1) {
                r[1] = entry.substring(d1 + 1, d2);
                if (d3 != -1) {
                    r[2] = entry.substring(d2 + 1, d3);
                    r[3] = entry.substring(d3 + 1);
                } else {
                    r[2] = entry.substring(d2 + 1);
                }
            } else {
                r[1] = entry.substring(d1 + 1);
            }
        } else {
            r[0] = entry;
        }
        return r;
    }

    private static void addItemToInv(ItemStack itemStack, EntityPlayer player) {
        if (itemStack != null) {
            player.field_71071_by.func_70441_a(itemStack.func_77946_l());
        }
    }

    private static void readItems() {
        if (scan != null) {
            itemsList.clear();
            while (scan.hasNextLine()) {
                String[] item = StartingInventory.parseLine(scan.nextLine());
                if (GameData.getItemRegistry().func_82594_a(item[0]) == null) continue;
                ItemStack itemStack = new ItemStack((Item)GameData.getItemRegistry().func_82594_a(item[0]), CommonUtils.parseInt((String)item[1]), CommonUtils.parseInt((String)item[2]));
                if (!item[3].isEmpty()) {
                    try {
                        NBTTagCompound nbt;
                        itemStack.field_77990_d = nbt = (NBTTagCompound)JsonToNBT.func_150315_a((String)item[3].replace("\\n", "\n"));
                    }
                    catch (Throwable e) {
                        FMLLog.log((String)"StartingInventory", (Level)Level.ERROR, (String)"Error parsing NBT JSON: %s", (Object[])new Object[]{item[3]});
                        e.printStackTrace();
                    }
                }
                itemsList.add(itemStack);
            }
            scan.close();
        }
    }

    private static void createFile() {
        File dir = new File(new File(CommonUtils.getMinecraftDir()), configPath);
        file = !dir.exists() && dir.mkdir() ? new File(dir, fileName) : new File(dir, fileName);
        try {
            file.createNewFile();
            PrintWriter out = new PrintWriter(new FileWriter(file));
            for (String s : defaultItems) {
                out.println(s);
            }
            out.close();
            scan = new Scanner(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void writeConfigFileFromInventory(EntityPlayer player) {
        itemsList.clear();
        try {
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            PrintWriter out = new PrintWriter(new FileWriter(file));
            for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
                if (itemStack == null) continue;
                itemsList.add(itemStack);
            }
            for (ItemStack itemStack : itemsList) {
                String name = GameData.getItemRegistry().func_148750_c((Object)itemStack.func_77973_b());
                if (name == null || name.isEmpty()) continue;
                String line = name + "," + itemStack.field_77994_a + "," + itemStack.func_77960_j();
                if (itemStack.func_77942_o()) {
                    line = line + "," + itemStack.field_77990_d.toString().replace("\n", "\\n");
                }
                out.println(line);
            }
            out.close();
            scan = new Scanner(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StartingInventory.readItems();
    }

    protected static void loadInventoryFromConfigFile(EntityPlayer player) {
        player.field_71071_by.func_146027_a(null, -1);
        StartingInventory.init();
        StartingInventory.addItems(player);
    }

    static {
        itemsList = new ArrayList<ItemStack>();
        defaultItems = new String[]{"minecraft:stone_pickaxe, 1", "minecraft:stone_shovel, 1", "minecraft:stone_sword, 1", "minecraft:stone_axe, 1", "minecraft:apple, 16", "minecraft:torch, 16"};
    }
}

