/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.util.collapsible;

import com.carpentersblocks.data.Collapsible;
import com.carpentersblocks.tileentity.TEBase;

public class CollapsibleUtil {
    public static double CENTER_YMAX;
    public static double offset_XZNN;
    public static double offset_XZNP;
    public static double offset_XZPN;
    public static double offset_XZPP;

    public static boolean isFullyCollapsed(TEBase TE) {
        int combinedHeight = Collapsible.getQuadHeight(TE, 0) + Collapsible.getQuadHeight(TE, 1) + Collapsible.getQuadHeight(TE, 2) + Collapsible.getQuadHeight(TE, 3);
        return combinedHeight == 64;
    }

    public static boolean isFullHeight(TEBase TE) {
        int combinedHeight = Collapsible.getQuadHeight(TE, 0) + Collapsible.getQuadHeight(TE, 1) + Collapsible.getQuadHeight(TE, 2) + Collapsible.getQuadHeight(TE, 3);
        return combinedHeight == 0;
    }

    public static void computeOffsets(TEBase TE) {
        double BIAS = CollapsibleUtil.isFullyCollapsed(TE) ? 0.0 : 9.765625E-4;
        offset_XZNN = ((double)Collapsible.getQuadHeight(TE, 0) - 1.0) / 15.0 + BIAS;
        offset_XZNP = ((double)Collapsible.getQuadHeight(TE, 1) - 1.0) / 15.0 + BIAS;
        offset_XZPN = ((double)Collapsible.getQuadHeight(TE, 2) - 1.0) / 15.0 + BIAS;
        offset_XZPP = ((double)Collapsible.getQuadHeight(TE, 3) - 1.0) / 15.0 + BIAS;
        double NW_SE = Math.abs(offset_XZNN - offset_XZPP);
        double NE_SW = Math.abs(offset_XZPN - offset_XZNP);
        CENTER_YMAX = NW_SE < NE_SW ? (offset_XZPN + offset_XZNP) / 2.0 : (offset_XZNN + offset_XZPP) / 2.0;
    }

    public static float getBoundsMaxHeight(TEBase TE) {
        float maxHeight = 0.0f;
        for (int quadrant = 0; quadrant < 4; ++quadrant) {
            float quadHeight = ((float)Collapsible.getQuadHeight(TE, quadrant) - 1.0f) / 15.0f;
            if (!(quadHeight > maxHeight)) continue;
            maxHeight = quadHeight;
        }
        return maxHeight;
    }

    public static float[] genBounds(TEBase TE, int quad) {
        float xMin = 0.0f;
        float zMin = 0.0f;
        float xMax = 1.0f;
        float zMax = 1.0f;
        switch (quad) {
            case 0: {
                xMax = 0.5f;
                zMax = 0.5f;
                break;
            }
            case 1: {
                xMax = 0.5f;
                zMin = 0.5f;
                break;
            }
            case 2: {
                xMin = 0.5f;
                zMax = 0.5f;
                break;
            }
            case 3: {
                xMin = 0.5f;
                zMin = 0.5f;
            }
        }
        float maxHeight = CollapsibleUtil.getBoundsMaxHeight(TE);
        float height = ((float)Collapsible.getQuadHeight(TE, quad) - 1.0f) / 15.0f;
        if (maxHeight - height > 0.5f) {
            height = maxHeight - 0.5f;
        }
        return new float[]{xMin, 0.0f, zMin, xMax, height, zMax};
    }
}

