/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.util.AEColor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.container.AbstractContainerCellTerminalBase;
import thaumicenergistics.container.ContainerEssentiaTerminal;
import thaumicenergistics.gui.GuiEssentiaCellTerminal;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.texture.BlockTextureManager;
import thaumicenergistics.util.PrivateInventory;

public class AEPartEssentiaTerminal
extends AbstractAEPartBase {
    private static final double IDLE_POWER_DRAIN = 0.5;
    private static final String SORT_MODE_NBT_KEY = "sortMode";
    private static final String INVENTORY_NBT_KEY = "slots";
    private List<ContainerEssentiaTerminal> listeners = new ArrayList<ContainerEssentiaTerminal>();
    private boolean inventoryLocked = false;
    private AspectStackComparator.ComparatorMode sortMode = AspectStackComparator.ComparatorMode.MODE_ALPHABETIC;
    private PrivateInventory inventory = new PrivateInventory("thaumicenergistics.part.aspect.terminal", 2, 64){

        @Override
        public boolean func_94041_b(int slotId, ItemStack itemStack) {
            return EssentiaItemContainerHelper.instance.isContainerOrLabel(itemStack);
        }
    };

    public AEPartEssentiaTerminal() {
        super(AEPartsEnum.EssentiaTerminal);
    }

    @Override
    protected boolean canPlayerOpenGui(int playerID) {
        return true;
    }

    public void addListener(AbstractContainerCellTerminalBase container) {
        if (container instanceof ContainerEssentiaTerminal) {
            this.listeners.add((ContainerEssentiaTerminal)container);
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        helper.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        helper.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[3];
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return GuiEssentiaCellTerminal.NewEssentiaTerminalGui(this, player);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        if (wrenched) {
            return;
        }
        for (int slotIndex = 0; slotIndex < 2; ++slotIndex) {
            ItemStack slotStack = this.inventory.func_70301_a(slotIndex);
            if (slotStack == null) continue;
            drops.add(slotStack);
        }
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.5;
    }

    public PrivateInventory getInventory() {
        return this.inventory;
    }

    @Override
    public int getLightLevel() {
        return this.isActive ? 10 : 0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerEssentiaTerminal(this, player);
    }

    public AspectStackComparator.ComparatorMode getSortingMode() {
        return this.sortMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean lockInventoryForWork() {
        boolean gotLock = false;
        PrivateInventory privateInventory = this.inventory;
        synchronized (privateInventory) {
            if (!this.inventoryLocked) {
                this.inventoryLocked = true;
                gotLock = true;
            }
        }
        return gotLock;
    }

    public void notifyListenersSortingModeChanged() {
        for (ContainerEssentiaTerminal listener : this.listeners) {
            listener.onSortingModeChanged(this.sortMode);
        }
    }

    public void onClientRequestSortingModeChange(AspectStackComparator.ComparatorMode sortMode) {
        this.sortMode = sortMode;
        this.notifyListenersSortingModeChanged();
        this.host.markForSave();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(SORT_MODE_NBT_KEY)) {
            this.sortMode = AspectStackComparator.ComparatorMode.VALUES[data.func_74762_e(SORT_MODE_NBT_KEY)];
        }
        if (data.func_74764_b(INVENTORY_NBT_KEY)) {
            this.inventory.loadFromNBT(data, INVENTORY_NBT_KEY);
        }
    }

    public void removeListener(ContainerEssentiaTerminal containerAspectTerminal) {
        this.listeners.remove(containerAspectTerminal);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[3];
        helper.setTexture(side);
        helper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        helper.renderInventoryBox(renderer);
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        ts.func_78380_c(0xD000D0);
        helper.setInvColor(0xFFFFFF);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], ForgeDirection.SOUTH, renderer);
        helper.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        helper.setInvColor(AEColor.Transparent.blackVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0], ForgeDirection.SOUTH, renderer);
        helper.setInvColor(AEColor.Transparent.mediumVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[1], ForgeDirection.SOUTH, renderer);
        helper.setInvColor(AEColor.Transparent.whiteVariant);
        helper.renderInventoryFace(BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[2], ForgeDirection.SOUTH, renderer);
        helper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[3];
        helper.setTexture(side);
        helper.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        helper.renderBlock(x, y, z, renderer);
        helper.setTexture(side, side, side, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        ts.func_78378_d(0xFFFFFF);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[4], ForgeDirection.SOUTH, renderer);
        helper.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        ts.func_78378_d(this.host.getColor().blackVariant);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(this.host.getColor().mediumVariant);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[1], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(this.host.getColor().whiteVariant);
        helper.renderFace(x, y, z, BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[2], ForgeDirection.SOUTH, renderer);
        helper.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void unlockInventory() {
        PrivateInventory privateInventory = this.inventory;
        synchronized (privateInventory) {
            this.inventoryLocked = false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a(SORT_MODE_NBT_KEY, this.sortMode.ordinal());
        this.inventory.saveToNBT(data, INVENTORY_NBT_KEY);
    }
}

