/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.network.packet.AbstractPacket;
import thaumicenergistics.network.packet.AbstractServerPacket;
import thaumicenergistics.tileentities.TileEssentiaCellWorkbench;

public class PacketServerEssentiaCellWorkbench
extends AbstractServerPacket {
    private static final byte MODE_REQUEST_ADD_ASPECT = 0;
    private static final byte MODE_REQUEST_REMOVE_ASPECT = 1;
    private static final byte MODE_REQUEST_REPLACE_ASPECT = 2;
    private static final byte MODE_REQUEST_FULL_LIST = 4;
    private static final byte MODE_REQUEST_CLEAR = 5;
    private static final byte MODE_REQUEST_PARITION_CONTENTS = 6;
    private Aspect arAspect;
    private Aspect replaceAspect;
    private TileEssentiaCellWorkbench workbench;

    @Override
    protected void readData(ByteBuf stream) {
        this.workbench = (TileEssentiaCellWorkbench)AbstractPacket.readTileEntity(stream);
        switch (this.mode) {
            case 0: 
            case 1: {
                this.arAspect = AbstractPacket.readAspect(stream);
                break;
            }
            case 2: {
                this.arAspect = AbstractPacket.readAspect(stream);
                this.replaceAspect = AbstractPacket.readAspect(stream);
            }
        }
    }

    @Override
    protected void writeData(ByteBuf stream) {
        AbstractPacket.writeTileEntity(this.workbench, stream);
        switch (this.mode) {
            case 0: 
            case 1: {
                AbstractPacket.writeAspect(this.arAspect, stream);
                break;
            }
            case 2: {
                AbstractPacket.writeAspect(this.arAspect, stream);
                AbstractPacket.writeAspect(this.replaceAspect, stream);
            }
        }
    }

    public PacketServerEssentiaCellWorkbench createRequestAddAspect(EntityPlayer player, TileEssentiaCellWorkbench workbench, Aspect aspect) {
        this.player = player;
        this.mode = 0;
        this.arAspect = aspect;
        this.workbench = workbench;
        return this;
    }

    public PacketServerEssentiaCellWorkbench createRequestClearPartitioning(EntityPlayer player, TileEssentiaCellWorkbench workbench) {
        this.player = player;
        this.mode = (byte)5;
        this.workbench = workbench;
        return this;
    }

    public PacketServerEssentiaCellWorkbench createRequestGetPartitionList(EntityPlayer player, TileEssentiaCellWorkbench workbench) {
        this.player = player;
        this.mode = (byte)4;
        this.workbench = workbench;
        return this;
    }

    public PacketServerEssentiaCellWorkbench createRequestPartitionToContents(EntityPlayer player, TileEssentiaCellWorkbench workbench) {
        this.player = player;
        this.mode = (byte)6;
        this.workbench = workbench;
        return this;
    }

    public PacketServerEssentiaCellWorkbench createRequestRemoveAspect(EntityPlayer player, TileEssentiaCellWorkbench workbench, Aspect aspect) {
        this.player = player;
        this.mode = 1;
        this.arAspect = aspect;
        this.workbench = workbench;
        return this;
    }

    public PacketServerEssentiaCellWorkbench createRequestReplaceAspect(EntityPlayer player, TileEssentiaCellWorkbench workbench, Aspect originalAspect, Aspect newAspect) {
        this.player = player;
        this.mode = (byte)2;
        this.arAspect = originalAspect;
        this.replaceAspect = newAspect;
        this.workbench = workbench;
        return this;
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.workbench.onClientRequestAddAspectToPartitionList(this.player, this.arAspect);
                break;
            }
            case 1: {
                this.workbench.onClientRequestRemoveAspectFromPartitionList(this.player, this.arAspect);
                break;
            }
            case 2: {
                this.workbench.onClientRequestReplaceAspectFromPartitionList(this.player, this.arAspect, this.replaceAspect);
                break;
            }
            case 4: {
                this.workbench.onClientRequestPartitionList(this.player);
                break;
            }
            case 5: {
                this.workbench.onClientRequestClearPartitioning(this.player);
                break;
            }
            case 6: {
                this.workbench.onClientRequestPartitionToContents(this.player);
            }
        }
    }
}

