/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import thaumicenergistics.gui.ThEGuiHandler;
import thaumicenergistics.network.packet.AbstractPacket;
import thaumicenergistics.network.packet.AbstractServerPacket;
import thaumicenergistics.parts.AbstractAEPartBase;

public class PacketServerChangeGui
extends AbstractServerPacket {
    private static final byte MODE_REGULAR = 0;
    private static final byte MODE_PART = 1;
    private int guiID;
    private AbstractAEPartBase part;
    private World world;
    private int x;
    private int y;
    private int z;

    public PacketServerChangeGui createChangeGuiRequest(AbstractAEPartBase part, EntityPlayer player, World world, int x, int y, int z) {
        this.player = player;
        this.mode = 1;
        this.part = part;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public PacketServerChangeGui createChangeGuiRequest(int guiID, EntityPlayer player, World world, int x, int y, int z) {
        this.player = player;
        this.mode = 0;
        this.guiID = guiID;
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @Override
    public void execute() {
        if (this.mode == 0) {
            ThEGuiHandler.launchGui(this.guiID, this.player, this.world, this.x, this.y, this.z);
        } else if (this.mode == 1) {
            ThEGuiHandler.launchGui(this.part, this.player, this.world, this.x, this.y, this.z);
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        if (this.mode == 0) {
            this.guiID = stream.readInt();
        } else if (this.mode == 1) {
            this.part = AbstractPacket.readPart(stream);
        }
        this.world = AbstractPacket.readWorld(stream);
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
    }

    @Override
    public void writeData(ByteBuf stream) {
        if (this.mode == 0) {
            stream.writeInt(this.guiID);
        } else if (this.mode == 1) {
            AbstractPacket.writePart(this.part, stream);
        }
        AbstractPacket.writeWorld(this.world, stream);
        stream.writeInt(this.x);
        stream.writeInt(this.y);
        stream.writeInt(this.z);
    }
}

