/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.client;

import appeng.api.config.RedstoneMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.gui.GuiEssentiaLevelEmitter;
import thaumicenergistics.network.packet.AbstractClientPacket;
import thaumicenergistics.registries.EnumCache;

public class PacketClientEssentiaEmitter
extends AbstractClientPacket {
    private static final byte MODE_FULL_UPDATE = 0;
    private static final byte MODE_UPDATE_WANTED = 1;
    private static final byte MODE_UPDATE_REDSTONE = 2;
    private RedstoneMode redstoneMode;
    private long wantedAmount;

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void wrappedExecute() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiEssentiaLevelEmitter) {
            switch (this.mode) {
                case 0: {
                    ((GuiEssentiaLevelEmitter)gui).onServerUpdateWantedAmount(this.wantedAmount);
                    ((GuiEssentiaLevelEmitter)gui).onServerUpdateRedstoneMode(this.redstoneMode);
                    break;
                }
                case 1: {
                    ((GuiEssentiaLevelEmitter)gui).onServerUpdateWantedAmount(this.wantedAmount);
                    break;
                }
                case 2: {
                    ((GuiEssentiaLevelEmitter)gui).onServerUpdateRedstoneMode(this.redstoneMode);
                }
            }
        }
    }

    public PacketClientEssentiaEmitter createFullUpdate(RedstoneMode redstoneMode, long wantedAmount, EntityPlayer player) {
        this.player = player;
        this.mode = 0;
        this.redstoneMode = redstoneMode;
        this.wantedAmount = wantedAmount;
        return this;
    }

    public PacketClientEssentiaEmitter createRedstoneModeUpdate(RedstoneMode redstoneMode, EntityPlayer player) {
        this.player = player;
        this.mode = (byte)2;
        this.redstoneMode = redstoneMode;
        return this;
    }

    public PacketClientEssentiaEmitter createWantedAmountUpdate(long wantedAmount, EntityPlayer player) {
        this.player = player;
        this.mode = 1;
        this.wantedAmount = wantedAmount;
        return this;
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.redstoneMode = EnumCache.AE_REDSTONE_MODES[stream.readInt()];
                this.wantedAmount = stream.readLong();
                break;
            }
            case 1: {
                this.wantedAmount = stream.readLong();
                break;
            }
            case 2: {
                this.redstoneMode = EnumCache.AE_REDSTONE_MODES[stream.readInt()];
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                stream.writeInt(this.redstoneMode.ordinal());
                stream.writeLong(this.wantedAmount);
                break;
            }
            case 1: {
                stream.writeLong(this.wantedAmount);
                break;
            }
            case 2: {
                stream.writeInt(this.redstoneMode.ordinal());
            }
        }
    }
}

