/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.gui.GuiEssentiaCellTerminal;
import thaumicenergistics.network.packet.AbstractClientPacket;
import thaumicenergistics.network.packet.AbstractPacket;

public class PacketClientEssentiaCellTerminal
extends AbstractClientPacket {
    private static final byte MODE_FULL_LIST = 0;
    private static final byte MODE_SELECTED_ASPECT = 1;
    private static final byte MODE_SORT_MODE_CHANGED = 2;
    private static final byte MODE_LIST_CHANGED = 3;
    private List<AspectStack> aspectStackList;
    private Aspect selectedAspect;
    private AspectStackComparator.ComparatorMode sortMode;
    private AspectStack change;

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void wrappedExecute() {
        GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiEssentiaCellTerminal) {
            switch (this.mode) {
                case 0: {
                    ((GuiEssentiaCellTerminal)gui).onReceiveAspectList(this.aspectStackList);
                    break;
                }
                case 1: {
                    ((GuiEssentiaCellTerminal)gui).onReceiveSelectedAspect(this.selectedAspect);
                    break;
                }
                case 2: {
                    ((GuiEssentiaCellTerminal)gui).onSortModeChanged(this.sortMode);
                    break;
                }
                case 3: {
                    ((GuiEssentiaCellTerminal)gui).onReceiveAspectListChange(this.change);
                }
            }
        }
    }

    public PacketClientEssentiaCellTerminal createListChanged(EntityPlayer player, AspectStack change) {
        this.player = player;
        this.mode = (byte)3;
        this.change = change;
        return this;
    }

    public PacketClientEssentiaCellTerminal createSelectedAspectUpdate(EntityPlayer player, Aspect selectedAspect) {
        this.player = player;
        this.mode = 1;
        this.selectedAspect = selectedAspect;
        return this;
    }

    public PacketClientEssentiaCellTerminal createSortModeUpdate(EntityPlayer player, AspectStackComparator.ComparatorMode sortMode) {
        this.player = player;
        this.mode = (byte)2;
        this.sortMode = sortMode;
        return this;
    }

    public PacketClientEssentiaCellTerminal createUpdateFullList(EntityPlayer player, List<AspectStack> list) {
        this.player = player;
        this.mode = 0;
        this.useCompression = true;
        this.aspectStackList = list;
        return this;
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.aspectStackList = new ArrayList<AspectStack>();
                while (stream.readableBytes() > 0) {
                    this.aspectStackList.add(new AspectStack(AbstractPacket.readAspect(stream), stream.readLong()));
                }
                break;
            }
            case 1: {
                this.selectedAspect = AbstractPacket.readAspect(stream);
                break;
            }
            case 2: {
                this.sortMode = AspectStackComparator.ComparatorMode.VALUES[stream.readInt()];
                break;
            }
            case 3: {
                this.change = new AspectStack(AbstractPacket.readAspect(stream), stream.readLong());
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                for (AspectStack stack : this.aspectStackList) {
                    AbstractPacket.writeAspect(stack.aspect, stream);
                    stream.writeLong(stack.amount);
                }
                break;
            }
            case 1: {
                AbstractPacket.writeAspect(this.selectedAspect, stream);
                break;
            }
            case 2: {
                stream.writeInt(this.sortMode.ordinal());
                break;
            }
            case 3: {
                AbstractPacket.writeAspect(this.change.aspect, stream);
                stream.writeLong(this.change.amount);
            }
        }
    }
}

