/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.beams.FXBeam;
import thaumicenergistics.network.packet.AbstractAreaPacket;

public class PacketAreaParticleFX
extends AbstractAreaPacket {
    private static final byte MODE_WRENCH_FX = 0;
    private float dX;
    private float dY;
    private float dZ;
    private int aspectColor;

    @SideOnly(value=Side.CLIENT)
    private void addWrenchFX() {
        Color color = new Color(this.aspectColor);
        FXBeam beam = new FXBeam(this.targetWorld, (double)this.targetX, (double)this.targetY + 1.5, (double)this.targetZ, (double)this.dX + 0.5, (double)this.dY + 0.5, (double)this.dZ + 0.5, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 6);
        beam.field_70130_N = 0.2f;
        ParticleEngine.instance.addEffect(this.targetWorld, (EntityFX)beam);
    }

    @Override
    protected void readData(ByteBuf stream) {
        super.readData(stream);
        switch (this.mode) {
            case 0: {
                this.dX = stream.readFloat();
                this.dY = stream.readFloat();
                this.dZ = stream.readFloat();
                this.aspectColor = stream.readInt();
            }
        }
    }

    @Override
    protected void writeData(ByteBuf stream) {
        super.writeData(stream);
        switch (this.mode) {
            case 0: {
                stream.writeFloat(this.dX);
                stream.writeFloat(this.dY);
                stream.writeFloat(this.dZ);
                stream.writeInt(this.aspectColor);
            }
        }
    }

    public PacketAreaParticleFX createWrenchFX(World world, double sourceX, double sourceY, double sourceZ, double destinationX, double destinationY, double destinationZ, Aspect aspectColor) {
        this.mode = 0;
        this.targetWorld = world;
        this.targetX = (float)sourceX;
        this.targetY = (float)sourceY;
        this.targetZ = (float)sourceZ;
        this.dX = (float)destinationX;
        this.dY = (float)destinationY;
        this.dZ = (float)destinationZ;
        this.aspectColor = aspectColor.getColor();
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void wrappedExecute() {
        if (this.targetWorld == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 2) {
            return;
        }
        switch (this.mode) {
            case 0: {
                this.addWrenchFX();
            }
        }
    }
}

