/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.World;
import thaumicenergistics.network.ChannelHandler;
import thaumicenergistics.network.packet.AbstractPacket;
import thaumicenergistics.util.EffectiveSide;

public abstract class AbstractAreaPacket
extends AbstractPacket {
    protected float targetX;
    protected float targetY;
    protected float targetZ;
    protected World targetWorld;

    @SideOnly(value=Side.CLIENT)
    private void setClientWorld() {
        this.targetWorld = FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    protected void readData(ByteBuf stream) {
        this.targetX = stream.readFloat();
        this.targetY = stream.readFloat();
        this.targetZ = stream.readFloat();
    }

    @Override
    protected void writeData(ByteBuf stream) {
        stream.writeFloat(this.targetX);
        stream.writeFloat(this.targetY);
        stream.writeFloat(this.targetZ);
    }

    @Override
    public final void execute() {
        if (EffectiveSide.isClientSide()) {
            this.setClientWorld();
            this.wrappedExecute();
        }
    }

    public void sendToAllAround(int range) {
        ChannelHandler.sendPacketToAllAround(this, this.targetWorld.field_73011_w.field_76574_g, this.targetX, this.targetY, this.targetZ, range);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void wrappedExecute();
}

